/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.bit;

import io.github.binaryfoo.bit.BitPackage;
import io.github.binaryfoo.bit.EmvBit;
import io.github.binaryfoo.decoders.bit.BitStringField;
import io.github.binaryfoo.decoders.bit.EmvBitStringParser;
import io.github.binaryfoo.decoders.bit.EmvBitStringParserKt;
import io.github.binaryfoo.decoders.bit.EnumeratedBitStringField;
import io.github.binaryfoo.decoders.bit.FullByteField;
import io.github.binaryfoo.decoders.bit.NumericBitStringField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0007J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lio/github/binaryfoo/decoders/bit/EmvBitStringParser;", "", "()V", "FULL_BYTE_FIELD_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getFULL_BYTE_FIELD_PATTERN", "()Ljava/util/regex/Pattern;", "NUMERIC_FIELD_PATTERN", "getNUMERIC_FIELD_PATTERN", "SINGLE_BIT_PATTERN", "getSINGLE_BIT_PATTERN", "parse", "", "Lio/github/binaryfoo/decoders/bit/BitStringField;", "lines", "", "parseEnumeratedField", "key", "label", "parseField", "parseFullByteField", "parseNumericField", "emv-bertlv"})
public final class EmvBitStringParser {
    private static final Pattern SINGLE_BIT_PATTERN;
    private static final Pattern NUMERIC_FIELD_PATTERN;
    private static final Pattern FULL_BYTE_FIELD_PATTERN;
    public static final EmvBitStringParser INSTANCE;

    public final Pattern getSINGLE_BIT_PATTERN() {
        return SINGLE_BIT_PATTERN;
    }

    public final Pattern getNUMERIC_FIELD_PATTERN() {
        return NUMERIC_FIELD_PATTERN;
    }

    public final Pattern getFULL_BYTE_FIELD_PATTERN() {
        return FULL_BYTE_FIELD_PATTERN;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<BitStringField> parse(@NotNull List<String> lines) {
        void $this$mapTo$iv$iv;
        String p1;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        parse.1 $fun$usefulLine$1 = parse.1.INSTANCE;
        Iterable $this$filter$iv = lines;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p1 = (String)element$iv$iv;
            boolean bl = false;
            if (!parse.1.INSTANCE.invoke(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p1 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)it;
            Regex regex = new Regex("\\s*:\\s*");
            int n = 2;
            boolean bl2 = false;
            List fields = regex.split(charSequence, n);
            BitStringField bitStringField = INSTANCE.parseField((String)fields.get(0), (String)fields.get(1));
            collection.add(bitStringField);
        }
        return (List)destination$iv$iv;
    }

    private final BitStringField parseField(String key, String label) {
        if (StringsKt.contains$default((CharSequence)key, (CharSequence)"-", (boolean)false, (int)2, null)) {
            return this.parseNumericField(key, label);
        }
        if (StringsKt.contains$default((CharSequence)key, (CharSequence)",", (boolean)false, (int)2, null)) {
            return this.parseEnumeratedField(key, label);
        }
        return this.parseFullByteField(key, label);
    }

    private final BitStringField parseNumericField(String key, String label) {
        Pattern pattern = NUMERIC_FIELD_PATTERN;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"NUMERIC_FIELD_PATTERN");
        Matcher matcher = EmvBitStringParserKt.access$match(key, pattern, "numeric");
        String string = matcher.group(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(1)");
        String string2 = string;
        boolean bl = false;
        int byteNumber = Integer.parseInt(string2);
        String string3 = matcher.group(2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"matcher.group(2)");
        String string4 = string3;
        boolean bl2 = false;
        int firstBit = Integer.parseInt(string4);
        String string5 = matcher.group(3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"matcher.group(3)");
        String string6 = string5;
        boolean bl3 = false;
        int lastBit = Integer.parseInt(string6);
        return new NumericBitStringField(byteNumber, firstBit, lastBit, label);
    }

    /*
     * WARNING - void declaration
     */
    private final BitStringField parseEnumeratedField(String key, String label) {
        Collection<EmvBit> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)key, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            EmvBit emvBit = EmvBitStringParserKt.access$parseBit((String)p1);
            collection.add(emvBit);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        TreeSet bits = new TreeSet(collection2);
        return new EnumeratedBitStringField(bits, label);
    }

    private final BitStringField parseFullByteField(String key, String label) {
        String hexValue;
        Pattern pattern = FULL_BYTE_FIELD_PATTERN;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"FULL_BYTE_FIELD_PATTERN");
        Matcher matcher = EmvBitStringParserKt.access$match(key, pattern, "full byte");
        String string = matcher.group(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group(1)");
        String string2 = string;
        boolean bl = false;
        int byteNumber = Integer.parseInt(string2);
        String string3 = hexValue = matcher.group(2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"hexValue");
        Set<EmvBit> bits = BitPackage.fromHex(string3, byteNumber);
        return new FullByteField(bits, byteNumber, hexValue, label);
    }

    private EmvBitStringParser() {
    }

    static {
        EmvBitStringParser emvBitStringParser;
        INSTANCE = emvBitStringParser = new EmvBitStringParser();
        SINGLE_BIT_PATTERN = Pattern.compile("\\s*\\((\\d+),(\\d+)\\)=(\\d+)\\s*");
        NUMERIC_FIELD_PATTERN = Pattern.compile("\\s*\\((\\d+),(\\d+)-(\\d+)\\)=INT\\s*");
        FULL_BYTE_FIELD_PATTERN = Pattern.compile("\\s*\\((\\d+)\\)=0x([0-9a-fA-F]{2})\\s*");
    }
}

