/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.bit;

import io.github.binaryfoo.bit.EmvBit;
import io.github.binaryfoo.decoders.bit.BitStringField;
import java.util.BitSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0016\u0010\u000f\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/binaryfoo/decoders/bit/NumericBitStringField;", "Lio/github/binaryfoo/decoders/bit/BitStringField;", "byteNumber", "", "firstBit", "lastBit", "name", "", "(IIILjava/lang/String;)V", "getLengthInBytes", "getPositionIn", "bits", "", "Lio/github/binaryfoo/bit/EmvBit;", "getStartBytesOffset", "getValueIn", "emv-bertlv"})
public final class NumericBitStringField
implements BitStringField {
    private final int byteNumber;
    private final int firstBit;
    private final int lastBit;
    private final String name;

    @Override
    @NotNull
    public String getPositionIn(@Nullable Set<EmvBit> bits) {
        return "Byte " + this.byteNumber + " Bits " + this.firstBit + '-' + this.lastBit;
    }

    @Override
    @NotNull
    public String getValueIn(@NotNull Set<EmvBit> bits) {
        Intrinsics.checkParameterIsNotNull(bits, (String)"bits");
        BitSet theByte = new BitSet(8);
        for (EmvBit bit : bits) {
            if (bit.getByteNumber() != this.byteNumber || bit.getBitNumber() > this.firstBit || bit.getBitNumber() < this.lastBit) continue;
            theByte.set(bit.getBitNumber() - 1, bit.getSet());
        }
        byte[] bytes = theByte.toByteArray();
        int i = bytes.length == 0 ? 0 : (bytes[0] & 0xFF) >>> this.lastBit - 1;
        return this.name + " = " + i;
    }

    @Override
    public int getStartBytesOffset() {
        return this.byteNumber - 1;
    }

    @Override
    public int getLengthInBytes() {
        return 1;
    }

    public NumericBitStringField(int byteNumber, int firstBit, int lastBit, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.byteNumber = byteNumber;
        this.firstBit = firstBit;
        this.lastBit = lastBit;
        this.name = name;
        if (this.lastBit > this.firstBit) {
            throw (Throwable)new IllegalArgumentException("Must be left to right order: " + this.lastBit + " > " + this.firstBit);
        }
    }
}

