/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.tlv;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ISOUtil {
    private static final Pattern HEX_CHARACTERS = Pattern.compile("[0-9a-fA-F]+");

    @NotNull
    public static String hexString(byte[] b) {
        return ISOUtil.hexString(b, 0, b.length);
    }

    @NotNull
    public static String hexString(byte[] b, int offset, int len) {
        StringBuilder d = new StringBuilder(b.length * 2);
        for (int i = 0; i < len; ++i) {
            byte byteI = b[offset + i];
            ISOUtil.toHex(d, byteI);
        }
        return d.toString();
    }

    @NotNull
    public static String hexString(Iterable<Byte> iterable) {
        StringBuilder s = new StringBuilder();
        for (Byte b : iterable) {
            ISOUtil.toHex(s, b);
        }
        return s.toString();
    }

    @NotNull
    public static String hexString(byte b) {
        StringBuilder s = new StringBuilder();
        ISOUtil.toHex(s, b);
        return s.toString();
    }

    public static void toHex(StringBuilder s, byte b) {
        char hi = Character.forDigit(b >> 4 & 0xF, 16);
        char lo = Character.forDigit(b & 0xF, 16);
        s.append(Character.toUpperCase(hi));
        s.append(Character.toUpperCase(lo));
    }

    public static byte[] hex2byte(byte[] b, int offset, int len) {
        byte[] d = new byte[len];
        for (int i = 0; i < len * 2; ++i) {
            int shift = i % 2 == 1 ? 0 : 4;
            int n = i >> 1;
            d[n] = (byte)(d[n] | Character.digit((char)b[offset + i], 16) << shift);
        }
        return d;
    }

    @NotNull
    public static byte[] hex2byte(String s) {
        if (s.length() % 2 == 0) {
            return ISOUtil.hex2byte(s.getBytes(), 0, s.length() >> 1);
        }
        throw new RuntimeException("Uneven number(" + s.length() + ") of hex digits passed to hex2byte.");
    }

    public static String dumpString(byte[] b) {
        StringBuilder d = new StringBuilder(b.length * 2);
        for (byte aB : b) {
            char c = (char)aB;
            if (Character.isISOControl(c)) {
                switch (c) {
                    case '\r': {
                        d.append("{CR}");
                        break;
                    }
                    case '\n': {
                        d.append("{LF}");
                        break;
                    }
                    case '\u0000': {
                        d.append("{NULL}");
                        break;
                    }
                    default: {
                        char hi = Character.forDigit(aB >> 4 & 0xF, 16);
                        char lo = Character.forDigit(aB & 0xF, 16);
                        d.append('[').append(Character.toUpperCase(hi)).append(Character.toUpperCase(lo)).append(']');
                        break;
                    }
                }
                continue;
            }
            d.append(c);
        }
        return d.toString();
    }

    public static boolean isValidHexString(String s) {
        return HEX_CHARACTERS.matcher(s).matches();
    }
}

