/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.tlv;

import io.github.binaryfoo.tlv.CompliantTagMode;
import io.github.binaryfoo.tlv.HexExtensionsKt;
import io.github.binaryfoo.tlv.TagRecognitionMode;
import java.io.ByteArrayOutputStream;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lio/github/binaryfoo/tlv/QuirkListTagMode;", "Lio/github/binaryfoo/tlv/TagRecognitionMode;", "nonStandard", "", "", "(Ljava/util/Set;)V", "getNonStandard", "()Ljava/util/Set;", "keepReading", "", "current", "", "all", "Ljava/io/ByteArrayOutputStream;", "emv-bertlv"})
public final class QuirkListTagMode
implements TagRecognitionMode {
    @NotNull
    private final Set<String> nonStandard;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean keepReading(byte current, @NotNull ByteArrayOutputStream all) {
        Intrinsics.checkParameterIsNotNull((Object)all, (String)"all");
        if (!CompliantTagMode.INSTANCE.keepReading(current, all)) return false;
        byte[] byArray = all.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"all.toByteArray()");
        if (this.nonStandard.contains(HexExtensionsKt.toHexString(byArray))) return false;
        return true;
    }

    @NotNull
    public final Set<String> getNonStandard() {
        return this.nonStandard;
    }

    public QuirkListTagMode(@NotNull Set<String> nonStandard) {
        Intrinsics.checkParameterIsNotNull(nonStandard, (String)"nonStandard");
        this.nonStandard = nonStandard;
    }
}

