/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.tlv;

import io.github.binaryfoo.TagInfo;
import io.github.binaryfoo.TagMetaData;
import io.github.binaryfoo.tlv.CompliantTagMode;
import io.github.binaryfoo.tlv.ISOUtil;
import io.github.binaryfoo.tlv.TagRecognitionMode;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J#\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0006\u0010\u001e\u001a\u00020\u0005J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lio/github/binaryfoo/tlv/Tag;", "", "bytes", "", "compliant", "", "([BZ)V", "", "", "(Ljava/util/List;Z)V", "byteArray", "getByteArray", "()[B", "getBytes", "()Ljava/util/List;", "getCompliant", "()Z", "constructed", "getConstructed", "hexString", "", "getHexString", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "isConstructed", "toString", "tagInfo", "Lio/github/binaryfoo/TagInfo;", "tagMetaData", "Lio/github/binaryfoo/TagMetaData;", "validate", "", "b", "Companion", "emv-bertlv"})
public final class Tag {
    @NotNull
    private final List<Byte> bytes;
    private final boolean compliant;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    private final void validate(List<Byte> b) {
        if (b.size() == 0) {
            throw (Throwable)new IllegalArgumentException("Tag must be constructed with a non-empty byte array");
        }
        if (b.size() == 1) {
            if ((((Number)b.get(0)).byteValue() & 0x1F) == 31) {
                throw (Throwable)new IllegalArgumentException("If bit 6 to bit 1 are set tag must not be only one byte long");
            }
        } else {
            int n;
            int n2;
            if ((((Number)b.get(b.size() - 1)).byteValue() & 0x80) != 0) {
                throw (Throwable)new IllegalArgumentException("For multibyte tag bit 8 of the final byte must be 0: " + Integer.toHexString(((Number)b.get(b.size() - 1)).byteValue()));
            }
            if (b.size() > 2 && (n2 = 1) <= (n = b.size() - 2)) {
                while (true) {
                    void i;
                    if ((((Number)b.get((int)i)).byteValue() & 0x80) != 128) {
                        throw (Throwable)new IllegalArgumentException("For multibyte tag bit 8 of the internal bytes must be 1: " + Integer.toHexString(((Number)b.get((int)i)).byteValue()));
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }
    }

    @NotNull
    public final String getHexString() {
        String string = ISOUtil.hexString((Iterable<Byte>)this.bytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(bytes)");
        return string;
    }

    public final boolean getConstructed() {
        return (((Number)this.bytes.get(0)).byteValue() & 0x20) == 32;
    }

    @NotNull
    public final byte[] getByteArray() {
        return CollectionsKt.toByteArray((Collection)this.bytes);
    }

    public final boolean isConstructed() {
        return this.getConstructed();
    }

    @NotNull
    public String toString() {
        String string = ISOUtil.hexString((Iterable<Byte>)this.bytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(bytes)");
        return string;
    }

    @NotNull
    public final String toString(@NotNull TagMetaData tagMetaData) {
        Intrinsics.checkParameterIsNotNull((Object)tagMetaData, (String)"tagMetaData");
        return this.toString(tagMetaData.get(this));
    }

    @NotNull
    public final String toString(@NotNull TagInfo tagInfo) {
        Intrinsics.checkParameterIsNotNull((Object)tagInfo, (String)"tagInfo");
        return ISOUtil.hexString((Iterable<Byte>)this.bytes) + " (" + tagInfo.getFullName() + ')';
    }

    @NotNull
    public final List<Byte> getBytes() {
        return this.bytes;
    }

    public final boolean getCompliant() {
        return this.compliant;
    }

    public Tag(@NotNull List<Byte> bytes, boolean compliant) {
        Intrinsics.checkParameterIsNotNull(bytes, (String)"bytes");
        this.bytes = bytes;
        this.compliant = compliant;
        if (this.compliant) {
            this.validate(this.bytes);
        }
    }

    public /* synthetic */ Tag(List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(list, bl);
    }

    public Tag(@NotNull byte[] bytes, boolean compliant) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        this(ArraysKt.toMutableList((byte[])bytes), compliant);
    }

    public /* synthetic */ Tag(byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(byArray, bl);
    }

    @NotNull
    public final List<Byte> component1() {
        return this.bytes;
    }

    public final boolean component2() {
        return this.compliant;
    }

    @NotNull
    public final Tag copy(@NotNull List<Byte> bytes, boolean compliant) {
        Intrinsics.checkParameterIsNotNull(bytes, (String)"bytes");
        return new Tag(bytes, compliant);
    }

    @NotNull
    public static /* synthetic */ Tag copy$default(Tag tag, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list = tag.bytes;
        }
        if ((n & 2) != 0) {
            bl = tag.compliant;
        }
        return tag.copy(list, bl);
    }

    public int hashCode() {
        List<Byte> list = this.bytes;
        int n = (list != null ? ((Object)list).hashCode() : 0) * 31;
        int n2 = this.compliant ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Tag)) break block3;
                Tag tag = (Tag)object;
                if (!Intrinsics.areEqual(this.bytes, tag.bytes) || !(this.compliant == tag.compliant)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Tag fromHex(@NotNull String hexString) {
        return Companion.fromHex(hexString);
    }

    @JvmStatic
    @NotNull
    public static final Tag parse(@NotNull ByteBuffer buffer) {
        return Companion.parse(buffer);
    }

    @JvmStatic
    @NotNull
    public static final Tag parse(@NotNull ByteBuffer buffer, @NotNull TagRecognitionMode recognitionMode) {
        return Companion.parse(buffer, recognitionMode);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lio/github/binaryfoo/tlv/Tag$Companion;", "", "()V", "fromHex", "Lio/github/binaryfoo/tlv/Tag;", "hexString", "", "parse", "buffer", "Ljava/nio/ByteBuffer;", "recognitionMode", "Lio/github/binaryfoo/tlv/TagRecognitionMode;", "emv-bertlv"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Tag fromHex(@NotNull String hexString) {
            Intrinsics.checkParameterIsNotNull((Object)hexString, (String)"hexString");
            byte[] byArray = ISOUtil.hex2byte(hexString);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ISOUtil.hex2byte(hexString)");
            return new Tag(byArray, false, 2, null);
        }

        @JvmStatic
        @NotNull
        public final Tag parse(@NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            return this.parse(buffer, CompliantTagMode.INSTANCE);
        }

        @JvmStatic
        @NotNull
        public final Tag parse(@NotNull ByteBuffer buffer, @NotNull TagRecognitionMode recognitionMode) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull((Object)recognitionMode, (String)"recognitionMode");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte b = buffer.get();
            out.write(b);
            if ((b & 0x1F) == 31) {
                do {
                    b = buffer.get();
                    out.write(b);
                } while (recognitionMode.keepReading(b, out));
            }
            byte[] byArray = out.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"out.toByteArray()");
            return new Tag(byArray, Intrinsics.areEqual((Object)recognitionMode, (Object)CompliantTagMode.INSTANCE));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

