/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.pathcmd;

import com.kitfox.svg.pathcmd.Arc;
import com.kitfox.svg.pathcmd.Cubic;
import com.kitfox.svg.pathcmd.CubicSmooth;
import com.kitfox.svg.pathcmd.Horizontal;
import com.kitfox.svg.pathcmd.LineTo;
import com.kitfox.svg.pathcmd.MoveTo;
import com.kitfox.svg.pathcmd.PathCommand;
import com.kitfox.svg.pathcmd.Quadratic;
import com.kitfox.svg.pathcmd.QuadraticSmooth;
import com.kitfox.svg.pathcmd.Terminal;
import com.kitfox.svg.pathcmd.Vertical;
import java.util.ArrayList;

public class PathParser {
    int iteration = 0;
    boolean dotAllowed = true;
    boolean signAllowed = true;
    boolean exponentAllowed = true;
    private final String input;
    private final int inputLength;
    private int index;
    private char currentCommand;

    public PathParser(String input) {
        this.input = input.trim();
        this.inputLength = this.input.length();
    }

    private boolean isCommandChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private boolean isWhiteSpaceOrSeparator(char c) {
        return c <= ' ' || c == ',';
    }

    private char peek() {
        return this.input.charAt(this.index);
    }

    private void consume() {
        ++this.index;
    }

    private boolean hasNext() {
        return this.index < this.inputLength;
    }

    private boolean isValidNumberChar(char c, PathParser state) {
        boolean valid;
        boolean bl = valid = '0' <= c && c <= '9';
        if (valid && state.iteration == 1 && this.input.charAt(this.index - 1) == '0') {
            return false;
        }
        boolean bl2 = state.signAllowed = state.signAllowed && !valid;
        if (state.dotAllowed && !valid) {
            valid = c == '.';
            boolean bl3 = state.dotAllowed = !valid;
        }
        if (state.signAllowed && !valid) {
            state.signAllowed = valid = c == '+' || c == '-';
        }
        if (state.exponentAllowed && !valid) {
            valid = c == 'e' || c == 'E';
            state.exponentAllowed = !valid;
            state.signAllowed = valid;
        }
        ++state.iteration;
        return valid;
    }

    private boolean isValidFlagChar(char c) {
        return '0' <= c && c <= '1';
    }

    private void consumeWhiteSpaceOrSeparator() {
        while (this.hasNext() && this.isWhiteSpaceOrSeparator(this.peek())) {
            this.consume();
        }
    }

    private float nextFloat() {
        int start = this.index;
        PathParser state = this.resetNumberCharState();
        while (this.hasNext() && this.isValidNumberChar(this.peek(), state)) {
            this.consume();
        }
        int end = this.index;
        this.consumeWhiteSpaceOrSeparator();
        String token = this.input.substring(start, end);
        try {
            return Float.parseFloat(token);
        }
        catch (NumberFormatException e) {
            String msg = "Unexpected element while parsing cmd '" + this.currentCommand + "' encountered token '" + token + "' rest=" + this.input.substring(start, Math.min(this.input.length(), start + 10)) + " (index=" + this.index + " in input=" + this.input + ")";
            throw new IllegalStateException(msg, e);
        }
    }

    private boolean nextFlag() {
        int start = this.index;
        if (this.hasNext() && this.isValidFlagChar(this.peek())) {
            this.consume();
        }
        int end = this.index;
        this.consumeWhiteSpaceOrSeparator();
        String token = this.input.substring(start, end);
        if (token.isEmpty()) {
            String msg = "Unexpected element while parsing cmd '" + this.currentCommand + "' encountered empty flag. rest=" + this.input.substring(start, Math.min(this.input.length(), start + 10)) + " (index=" + this.index + " in input=" + this.input + ")";
            throw new IllegalStateException(msg);
        }
        return "1".equals(token);
    }

    public PathCommand[] parsePathCommand() {
        ArrayList<Terminal> commands = new ArrayList<Terminal>();
        this.currentCommand = (char)90;
        while (this.hasNext()) {
            PathCommand cmd;
            char peekChar = this.peek();
            if (this.isCommandChar(peekChar)) {
                this.consume();
                this.currentCommand = peekChar;
            }
            this.consumeWhiteSpaceOrSeparator();
            switch (this.currentCommand) {
                case 'M': {
                    cmd = new MoveTo(false, this.nextFloat(), this.nextFloat());
                    this.currentCommand = (char)76;
                    break;
                }
                case 'm': {
                    cmd = new MoveTo(true, this.nextFloat(), this.nextFloat());
                    this.currentCommand = (char)108;
                    break;
                }
                case 'L': {
                    cmd = new LineTo(false, this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'l': {
                    cmd = new LineTo(true, this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'H': {
                    cmd = new Horizontal(false, this.nextFloat());
                    break;
                }
                case 'h': {
                    cmd = new Horizontal(true, this.nextFloat());
                    break;
                }
                case 'V': {
                    cmd = new Vertical(false, this.nextFloat());
                    break;
                }
                case 'v': {
                    cmd = new Vertical(true, this.nextFloat());
                    break;
                }
                case 'A': {
                    cmd = new Arc(false, this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFlag(), this.nextFlag(), this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'a': {
                    cmd = new Arc(true, this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFlag(), this.nextFlag(), this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'Q': {
                    cmd = new Quadratic(false, this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'q': {
                    cmd = new Quadratic(true, this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'T': {
                    cmd = new QuadraticSmooth(false, this.nextFloat(), this.nextFloat());
                    break;
                }
                case 't': {
                    cmd = new QuadraticSmooth(true, this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'C': {
                    cmd = new Cubic(false, this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'c': {
                    cmd = new Cubic(true, this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'S': {
                    cmd = new CubicSmooth(false, this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat());
                    break;
                }
                case 's': {
                    cmd = new CubicSmooth(true, this.nextFloat(), this.nextFloat(), this.nextFloat(), this.nextFloat());
                    break;
                }
                case 'Z': 
                case 'z': {
                    cmd = new Terminal();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid path element " + this.currentCommand + "(at index=" + this.index + " in input=" + this.input + ")");
                }
            }
            commands.add((Terminal)cmd);
        }
        return commands.toArray(new PathCommand[0]);
    }

    private PathParser resetNumberCharState() {
        this.iteration = 0;
        this.dotAllowed = true;
        this.signAllowed = true;
        this.exponentAllowed = true;
        return this;
    }
}

