/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.util;

import com.kitfox.svg.Font;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.util.FontSystem;
import com.kitfox.svg.xml.StyleAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FontUtil {
    private static final String DEFAULT_FONT_FAMILY = "sans-serif";
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private static final int DEFAULT_LETTER_SPACING = 0;
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_WEIGHT = 0;

    private FontUtil() {
    }

    public static FontInfo parseFontInfo(SVGElement element, StyleAttribute sty) throws SVGException {
        String fontFamily = DEFAULT_FONT_FAMILY;
        if (element.getStyle(sty.setName("font-family"))) {
            fontFamily = sty.getStringValue();
        }
        float fontSize = 12.0f;
        if (element.getStyle(sty.setName("font-size"))) {
            fontSize = sty.getFloatValueWithUnits();
        }
        float letterSpacing = 0.0f;
        if (element.getStyle(sty.setName("letter-spacing"))) {
            letterSpacing = sty.getFloatValueWithUnits();
        }
        int fontStyle = 0;
        if (element.getStyle(sty.setName("font-style"))) {
            String s = sty.getStringValue();
            if ("normal".equals(s)) {
                fontStyle = 0;
            } else if ("italic".equals(s)) {
                fontStyle = 1;
            } else if ("oblique".equals(s)) {
                fontStyle = 2;
            }
        }
        int fontWeight = 0;
        if (element.getStyle(sty.setName("font-weight"))) {
            String s = sty.getStringValue();
            if ("normal".equals(s)) {
                fontWeight = 0;
            } else if ("bold".equals(s)) {
                fontWeight = 1;
            }
        }
        String[] split = fontFamily.split("\\s*#\\s*");
        return new FontInfo(split, fontSize, fontStyle, fontWeight, letterSpacing);
    }

    public static Font getFont(FontInfo info, SVGDiagram diagram) {
        return FontUtil.getFont(info.families, info.style, info.weight, info.size, diagram);
    }

    private static Font getFont(String[] families, int fontStyle, int fontWeight, float fontSize, SVGDiagram diagram) {
        Font font = null;
        for (String family : families) {
            font = diagram.getUniverse().getFont(family);
            if (font != null) break;
        }
        if (font == null) {
            font = FontSystem.createFont(families, fontStyle, fontWeight, fontSize);
        }
        if (font == null) {
            Logger.getLogger(FontSystem.class.getName()).log(Level.WARNING, "Could not create font " + Arrays.toString(families));
            String[] defaultFont = new String[]{DEFAULT_FONT_FAMILY};
            font = FontSystem.createFont(defaultFont, fontStyle, fontWeight, fontSize);
        }
        return font;
    }

    public static final class FontInfo {
        public final String[] families;
        public final float size;
        public final int style;
        public final int weight;
        public final float letterSpacing;

        public FontInfo(String[] families, float size, int style, int weight, float letterSpacing) {
            this.families = families;
            this.size = size;
            this.style = style;
            this.weight = weight;
            this.letterSpacing = letterSpacing;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FontInfo)) {
                return false;
            }
            FontInfo fontInfo = (FontInfo)o;
            return Float.compare(fontInfo.size, this.size) == 0 && this.style == fontInfo.style && this.weight == fontInfo.weight && Float.compare(fontInfo.letterSpacing, this.letterSpacing) == 0 && Arrays.equals(this.families, fontInfo.families);
        }

        public int hashCode() {
            int result = Objects.hash(Float.valueOf(this.size), this.style, this.weight, Float.valueOf(this.letterSpacing));
            result = 31 * result + Arrays.hashCode(this.families);
            return result;
        }
    }
}

