/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import android.content.Context;
import android.text.TextUtils;
import cn.bmob.v3.BmobConfig;
import cn.bmob.v3.BmobConstants;
import cn.bmob.v3.BmobWrapper;
import cn.bmob.v3.datatype.BmobFile;
import cn.bmob.v3.datatype.BmobTableSchema;
import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.listener.QueryListListener;
import cn.bmob.v3.listener.QueryListener;
import cn.bmob.v3.listener.UploadBatchListener;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public final class Bmob {
    private static byte[] lock = new byte[0];

    public static void initialize(Context context, String appkey) {
        Bmob.initialize(context, appkey, "Default", false);
    }

    @Deprecated
    public static void initialize(Context context, String appkey, String channel) {
        Bmob.initialize(context, appkey, channel, true);
    }

    private static void initialize(Context context, String appkey, String channel, boolean openStat) {
        BmobWrapper.initialize(new BmobConfig.Builder(context).setApplicationId(appkey).setUploadBlockSize(BmobConstants.BLOCK_SIZE).setFileExpiration(BmobConstants.EXPIRATION).setConnectTimeout(BmobConstants.CONNECT_TIMEOUT).build());
    }

    public static void initialize(BmobConfig config) {
        if (TextUtils.isEmpty((CharSequence)config.applicationId)) {
            throw new RuntimeException("ApplicationId is null. You must call setApplicationId(Your AppId) method in BmobConfig.Builder(context).");
        }
        BmobWrapper.initialize(config);
    }

    public static File getCacheDir() {
        return BmobWrapper.getInstance().getCacheDir();
    }

    public static File getFilesDir() {
        return BmobWrapper.getInstance().getFilesDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getCacheDir(String subDir) {
        byte[] byArray = lock;
        synchronized (lock) {
            File dir = new File(Bmob.getCacheDir(), subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFilesDir(String subDir) {
        byte[] byArray = lock;
        synchronized (lock) {
            File dir = new File(Bmob.getFilesDir(), subDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dir;
        }
    }

    private static void checkContext() {
        if (BmobWrapper.getInstance().getApplicationContext() == null) {
            throw new RuntimeException("applicationContext is null. You must call initialize  before using the Bmob library.");
        }
    }

    public static Context getApplicationContext() {
        Bmob.checkContext();
        return BmobWrapper.getInstance().getApplicationContext();
    }

    public static long getConnectTimeout() {
        Bmob.checkContext();
        return BmobWrapper.getInstance().getConnectTimeout();
    }

    public static int getFileBlockSize() {
        Bmob.checkContext();
        return BmobWrapper.getInstance().getUploadBlockSize();
    }

    public static long getFileExpiration() {
        Bmob.checkContext();
        return BmobWrapper.getInstance().getFileExpiration();
    }

    @Deprecated
    public static void uploadBatch(String[] filePaths, UploadBatchListener listener) {
        BmobFile.uploadBatch(filePaths, listener);
    }

    public static Disposable getServerTime(QueryListener<Long> listener) {
        return BmobFactory.getInstance().createTimeRequest(listener).getDisposable();
    }

    public static Observable<Long> getServerTimeObservable() {
        return BmobFactory.getInstance().createTimeRequest(null).getObservable();
    }

    private static RxBmob getAllTableSchemaRequest(QueryListListener<BmobTableSchema> listener) {
        JSONObject params = new JSONObject();
        try {
            params = new JSONObject();
            JSONObject data = new JSONObject();
            params.put("data", (Object)data);
            params.put("c", (Object)"");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createAllTableSchemaRequest(params, listener);
    }

    public static Disposable getAllTableSchema(QueryListListener<BmobTableSchema> listener) {
        return Bmob.getAllTableSchemaRequest(listener).getDisposable();
    }

    public static Observable<List<BmobTableSchema>> getAllTableSchemaObservable() {
        return Bmob.getAllTableSchemaRequest(null).getObservable();
    }

    private static RxBmob getTableSchemaRequest(String tableName, QueryListener<BmobTableSchema> listener) {
        JSONObject params = new JSONObject();
        try {
            params = new JSONObject();
            JSONObject data = new JSONObject();
            params.put("data", (Object)data);
            params.put("c", (Object)tableName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createTableSchemaRequest(params, listener);
    }

    public static Disposable getTableSchema(String tableName, QueryListener<BmobTableSchema> listener) {
        return Bmob.getTableSchemaRequest(tableName, listener).getDisposable();
    }

    public static Observable<BmobTableSchema> getTableSchemaObservable(String tableName) {
        return Bmob.getTableSchemaRequest(tableName, null).getObservable();
    }

    public static void resetDomain(String newDomain, String ioDomain) {
        BmobClient.setIsNewDomain(true);
        BmobClient.setHasInit(false);
        BmobURL.getDefault().setDefaultBaseUrl(newDomain, ioDomain);
    }

    public static void resetDomain(String newDomain) {
        Bmob.resetDomain(newDomain, null);
    }
}

