/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import android.text.TextUtils;
import cn.bmob.v3.BmobRole;
import cn.bmob.v3.BmobUser;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BmobACL
implements Serializable {
    private static final long serialVersionUID = 3706778250022037535L;
    private Map<String, Object> acl = new HashMap<String, Object>();
    private static final String WRITE = "write";
    private static final String READ = "read";

    public Map<String, Object> getAcl() {
        return this.acl;
    }

    public void setAcl(Map<String, Object> acl) {
        this.acl = acl;
    }

    private void setAccess(String accessType, String userId, boolean allowed) {
        if (this.acl.containsKey(userId)) {
            Map m = (Map)this.acl.get(userId);
            m.put(accessType, allowed);
            this.acl.put(userId, m);
        } else {
            HashMap<String, Boolean> access = new HashMap<String, Boolean>();
            access.put(accessType, allowed);
            this.acl.put(userId, access);
        }
    }

    public void setReadAccess(String userId, boolean allowed) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("cannot setReadAccess for null userId");
        }
        if (allowed) {
            this.setAccess(READ, userId, allowed);
        }
    }

    public void setReadAccess(BmobUser user, boolean allowed) {
        if (user == null) {
            throw new IllegalArgumentException("cannot setReadAccess for null user");
        }
        if (TextUtils.isEmpty((CharSequence)user.getObjectId())) {
            throw new IllegalArgumentException("cannot setReadAccess for null userId");
        }
        if (allowed) {
            this.setAccess(READ, user.getObjectId(), allowed);
        }
    }

    public void setWriteAccess(String userId, boolean allowed) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("cannot setReadAccess for null userId");
        }
        if (allowed) {
            this.setAccess(WRITE, userId, allowed);
        }
    }

    public void setWriteAccess(BmobUser user, boolean allowed) {
        if (user == null) {
            throw new IllegalArgumentException("cannot setReadAccess for null user");
        }
        if (TextUtils.isEmpty((CharSequence)user.getObjectId())) {
            throw new IllegalArgumentException("cannot setReadAccess for null userId");
        }
        if (allowed) {
            this.setAccess(WRITE, user.getObjectId(), allowed);
        }
    }

    public void setRoleReadAccess(String roleName, boolean allowed) {
        if (TextUtils.isEmpty((CharSequence)roleName)) {
            throw new IllegalArgumentException("cannot setReadAccess for null roleName");
        }
        if (allowed) {
            this.setAccess(READ, "role:" + roleName, allowed);
        }
    }

    public void setRoleReadAccess(BmobRole role, boolean allowed) {
        if (role == null) {
            throw new IllegalArgumentException("cannot setReadAccess for null role");
        }
        if (TextUtils.isEmpty((CharSequence)role.getName())) {
            throw new IllegalArgumentException("cannot setReadAccess for null roleName");
        }
        if (allowed) {
            this.setAccess(READ, "role:" + role.getName(), allowed);
        }
    }

    public void setRoleWriteAccess(String roleName, boolean allowed) {
        if (TextUtils.isEmpty((CharSequence)roleName)) {
            throw new IllegalArgumentException("cannot setReadAccess for null roleName");
        }
        if (allowed) {
            this.setAccess(WRITE, "role:" + roleName, allowed);
        }
    }

    public void setRoleWriteAccess(BmobRole role, boolean allowed) {
        if (role == null) {
            throw new IllegalArgumentException("cannot setReadAccess for null role");
        }
        if (TextUtils.isEmpty((CharSequence)role.getName())) {
            throw new IllegalArgumentException("cannot setReadAccess for null roleName");
        }
        if (allowed) {
            this.setAccess(WRITE, "role:" + role.getName(), allowed);
        }
    }

    public void setPublicReadAccess(boolean allowed) {
        if (allowed) {
            this.setReadAccess("*", allowed);
        }
    }

    public void setPublicWriteAccess(boolean allowed) {
        if (allowed) {
            this.setWriteAccess("*", allowed);
        }
    }
}

