/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import cn.bmob.v3.BmobObject;
import cn.bmob.v3.BmobUser;
import cn.bmob.v3.datatype.BatchResult;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.listener.QueryListListener;
import cn.bmob.v3.util.BmobContentProvider;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BmobBatch {
    private final JSONArray requests = new JSONArray();

    public BmobBatch insertBatch(List<BmobObject> objects) {
        return this.process("POST", objects);
    }

    public BmobBatch deleteBatch(List<BmobObject> objects) {
        return this.process("DELETE", objects);
    }

    public BmobBatch updateBatch(List<BmobObject> objects) {
        return this.process("PUT", objects);
    }

    private BmobBatch process(String method, List<BmobObject> objects) {
        try {
            for (BmobObject bmobObject : objects) {
                if (bmobObject instanceof BmobUser) {
                    throw new IllegalArgumentException("BmobUser does not support batch operations");
                }
                JSONObject object = new JSONObject(GsonUtil.toJson(bmobObject));
                JSONObject jo = new JSONObject();
                jo.put("method", (Object)method);
                if (method.equals("PUT") || method.equals("DELETE")) {
                    jo.put("token", (Object)BmobContentProvider.getSessionToken());
                    jo.put("path", (Object)("/1/classes/" + bmobObject.getTableName() + "/" + bmobObject.getObjectId()));
                    object.remove("createdAt");
                    object.remove("updatedAt");
                    object.remove("objectId");
                } else {
                    jo.put("path", (Object)("/1/classes/" + bmobObject.getTableName()));
                }
                object.remove("_c_");
                jo.put("body", (Object)BmobObject.disposePointerType(bmobObject, object));
                this.requests.put((Object)jo);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    private RxBmob createBatchRequest(QueryListListener<BatchResult> listener) {
        JSONObject params = new JSONObject();
        try {
            params.put("data", (Object)new JSONObject().put("requests", (Object)this.requests));
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        return new RxBmob.Builder().check(BmobFactory.rByBatch(this.requests)).nextTest(BmobURL.getDefault().getUrl("batch"), params).mapBatch().subscribe(listener).build();
    }

    public Observable<List<BatchResult>> doBatchObservable() {
        return this.createBatchRequest(null).getObservable();
    }

    public Disposable doBatch(QueryListListener<BatchResult> listener) {
        return this.createBatchRequest(listener).getDisposable();
    }
}

