/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import android.content.Context;

public final class BmobConfig {
    public Context context;
    public String applicationId;
    public long connectTimeout;
    public int uploadBlockSize;
    public long fileExpiration;

    private BmobConfig(Builder builder) {
        this.context = builder.context;
        this.applicationId = builder.applicationId;
        this.connectTimeout = builder.connectTimeout;
        this.uploadBlockSize = builder.uploadBlockSize;
        this.fileExpiration = builder.fileExpiration;
    }

    public static final class Builder {
        private Context context;
        private String applicationId;
        private long connectTimeout;
        private int uploadBlockSize;
        private long fileExpiration;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder setConnectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setUploadBlockSize(int blockSize) {
            this.uploadBlockSize = blockSize;
            return this;
        }

        public Builder setFileExpiration(long expiration) {
            this.fileExpiration = expiration;
            return this;
        }

        public BmobConfig build() {
            return new BmobConfig(this);
        }
    }
}

