/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import android.annotation.SuppressLint;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.BmobInstallation;
import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.InstallationListener;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.RequestUtils;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.BmobContentProvider;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;

public class BmobInstallationManager {
    private static BmobInstallationManager INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BmobInstallationManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<BmobInstallationManager> clazz = BmobInstallationManager.class;
        synchronized (BmobInstallationManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new BmobInstallationManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public BmobInstallation getCurrentInstallation() {
        String installation = BmobContentProvider.getInstallation();
        BmobInstallation bmobInstallation = (BmobInstallation)GsonUtil.toObject(installation, BmobInstallation.class);
        return bmobInstallation;
    }

    @SuppressLint(value={"CheckResult"})
    public void initialize(final InstallationListener<BmobInstallation> installationListener) {
        BmobQuery<BmobInstallation> query = new BmobQuery<BmobInstallation>();
        query.addWhereEqualTo("installationId", RequestUtils.getInstallationId(Bmob.getApplicationContext()));
        query.findObjectsObservable(BmobInstallation.class).subscribe((Consumer)new Consumer<List<BmobInstallation>>(){

            public void accept(List<BmobInstallation> bmobInstallations) {
                if (bmobInstallations != null && bmobInstallations.size() > 0) {
                    BmobInstallationManager.this.saveInstallation(bmobInstallations.get(0), installationListener);
                } else {
                    BmobInstallationManager.this.saveInstallation(installationListener);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                BmobInstallationManager.this.saveInstallation(installationListener);
            }
        });
    }

    private void saveInstallation(BmobInstallation installation, InstallationListener installationListener) {
        BmobContentProvider.updateInstallation(GsonUtil.toJson(installation));
        installationListener.done(installation, null);
    }

    @SuppressLint(value={"CheckResult"})
    private void saveInstallation(final InstallationListener<BmobInstallation> installationListener) {
        final BmobInstallation bmobInstallation = new BmobInstallation();
        bmobInstallation.setInstallationId(RequestUtils.getInstallationId(Bmob.getApplicationContext()));
        bmobInstallation.setTimeZone(TimeZone.getDefault().getID());
        bmobInstallation.saveObservable().subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                BLog.i(s);
                BmobContentProvider.updateInstallation(GsonUtil.toJson(bmobInstallation));
                installationListener.done(bmobInstallation, null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                BLog.e(throwable.getMessage());
                installationListener.done(null, new BmobException(9015, "\u4fdd\u5b58installation\u8868\u5931\u8d25\uff0c\u539f\u56e0:" + throwable.getMessage()));
            }
        });
    }

    public static String getInstallationId() {
        return RequestUtils.getInstallationId(Bmob.getApplicationContext());
    }

    public void subscribe(String channel, InstallationListener<BmobInstallation> installationListener) {
        this.subscribe(Arrays.asList(channel), installationListener);
    }

    public void subscribe(List<String> channels, InstallationListener<BmobInstallation> installationListener) {
        BmobInstallation bmobInstallation = this.getCurrentInstallation();
        bmobInstallation.addAllUnique("channels", channels);
        ArrayList<String> channelsBefore = new ArrayList<String>();
        channelsBefore.addAll(bmobInstallation.getChannels());
        channelsBefore.addAll(channels);
        ArrayList<String> channelsAfter = new ArrayList<String>(new HashSet(channelsBefore));
        bmobInstallation.setChannels(channelsAfter);
        this.update(bmobInstallation, installationListener);
    }

    public void unsubscribe(String channel, InstallationListener<BmobInstallation> installationListener) {
        this.unsubscribe(Arrays.asList(channel), installationListener);
    }

    public void unsubscribe(List<String> channels, InstallationListener<BmobInstallation> installationListener) {
        BmobInstallation bmobInstallation = this.getCurrentInstallation();
        bmobInstallation.removeAll("channels", channels);
        ArrayList<String> channelsBefore = new ArrayList<String>();
        channelsBefore.addAll(bmobInstallation.getChannels());
        channelsBefore.removeAll(channels);
        ArrayList<String> channelsAfter = new ArrayList<String>(new HashSet(channelsBefore));
        bmobInstallation.setChannels(channelsAfter);
        this.update(bmobInstallation, installationListener);
    }

    @SuppressLint(value={"CheckResult"})
    public void update(final BmobInstallation bmobInstallation, final InstallationListener<BmobInstallation> installationListener) {
        bmobInstallation.updateObservable().subscribe((Consumer)new Consumer<BmobException>(){

            public void accept(BmobException aVoid) {
                BmobContentProvider.updateInstallation(GsonUtil.toJson(bmobInstallation));
                installationListener.done(bmobInstallation, null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                installationListener.done(null, new BmobException(9015, "\u66f4\u65b0\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + throwable.getMessage()));
            }
        });
    }
}

