/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import cn.bmob.v3.BmobACL;
import cn.bmob.v3.BmobInstallation;
import cn.bmob.v3.BmobRole;
import cn.bmob.v3.BmobUser;
import cn.bmob.v3.datatype.BmobDate;
import cn.bmob.v3.datatype.BmobFile;
import cn.bmob.v3.datatype.BmobGeoPoint;
import cn.bmob.v3.datatype.BmobRelation;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.listener.SaveListener;
import cn.bmob.v3.listener.UpdateListener;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.JsonUtil;
import com.google.gson.JsonElement;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BmobObject
implements Serializable {
    protected static List<JSONObject> increments = new ArrayList<JSONObject>();
    protected static JSONObject data;
    private String objectId;
    private String createdAt;
    private String updatedAt;
    private BmobACL ACL;
    private String _c_;

    public BmobObject() {
        this._c_ = this.getClass().getSimpleName();
        BLog.e(this._c_);
        data = new JSONObject();
    }

    public BmobObject(String tableName) {
        this._c_ = tableName;
        data = new JSONObject();
    }

    public void setTableName(String tableName) {
        this._c_ = tableName;
    }

    public String getTableName() {
        return this._c_;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    protected void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public BmobACL getACL() {
        return this.ACL;
    }

    public void setACL(BmobACL aCL) {
        this.ACL = aCL;
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(String key, Number amount) {
        JSONObject increment = new JSONObject();
        try {
            increment.put("__op", (Object)"Increment");
            increment.put("amount", (Object)amount);
            increment.put("key", (Object)key);
            increments.add(increment);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void add(String key, Object value) {
        this.addAll(key, Arrays.asList(value));
    }

    public void addAll(String key, Collection<?> values) {
        try {
            data.put(key, (Object)this.addFieldOperation("Add", values));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addUnique(String key, Object value) {
        this.addAllUnique(key, Arrays.asList(value));
    }

    public void addAllUnique(String key, Collection<?> values) {
        try {
            data.put(key, (Object)this.addFieldOperation("AddUnique", values));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void removeAll(String key, Collection<?> values) {
        try {
            data.put(key, (Object)this.addFieldOperation("Remove", values));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void remove(String key) {
        try {
            data.put(key, (Object)new JSONObject().put("__op", (Object)"Delete"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private JSONObject addFieldOperation(String type, Collection<?> values) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("__op", (Object)type);
        JSONArray array = new JSONArray();
        for (Object object : values) {
            if (object instanceof String) {
                array.put(object);
                continue;
            }
            JSONObject obj = new JSONObject(GsonUtil.toJson(object));
            array.put((Object)obj);
        }
        j.put("objects", (Object)array);
        return j;
    }

    public void setValue(String key, Object value) {
        try {
            data.put(key, this.parseValue(value));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private Object parseValue(Object value) throws JSONException {
        if (value instanceof BmobDate || value instanceof BmobFile || value instanceof BmobGeoPoint || value instanceof BmobRelation) {
            return new JSONObject(GsonUtil.toJson(value));
        }
        if (value instanceof BmobObject) {
            BmobObject object = (BmobObject)value;
            JSONObject obj = new JSONObject();
            obj.put("__type", (Object)"Pointer");
            obj.put("objectId", (Object)(object.getObjectId() == null ? "" : object.getObjectId()));
            obj.put("className", (Object)object.getTableName());
            return obj;
        }
        if (value instanceof String || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof Character || value instanceof Boolean) {
            return value;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            JSONArray array = new JSONArray();
            for (Object object : values) {
                if (object instanceof String) {
                    array.put(object);
                    continue;
                }
                JSONObject obj = new JSONObject(GsonUtil.toJson(object));
                array.put((Object)obj);
            }
            return array;
        }
        JSONObject obj = new JSONObject(GsonUtil.toJson(value));
        return obj;
    }

    public static JSONObject disposePointerType(BmobObject bmobObject, JSONObject object) throws JSONException {
        Field[] fields;
        for (Field f : fields = bmobObject.getClass().getDeclaredFields()) {
            JSONObject obj;
            if (BmobUser.class.isAssignableFrom(f.getType())) {
                if (object.isNull(f.getName())) continue;
                obj = new JSONObject();
                obj.put("__type", (Object)"Pointer");
                obj.put("objectId", (Object)object.optJSONObject(f.getName()).optString("objectId", "null"));
                obj.put("className", (Object)"_User");
                object.put(f.getName(), (Object)obj);
                continue;
            }
            if (BmobInstallation.class.isAssignableFrom(f.getType())) {
                if (object.isNull(f.getName())) continue;
                obj = new JSONObject();
                obj.put("__type", (Object)"Pointer");
                obj.put("objectId", (Object)object.optJSONObject(f.getName()).optString("objectId", "null"));
                obj.put("className", (Object)"_Installation");
                object.put(f.getName(), (Object)obj);
                continue;
            }
            if (BmobRole.class.isAssignableFrom(f.getType())) {
                if (object.isNull(f.getName())) continue;
                obj = new JSONObject();
                obj.put("__type", (Object)"Pointer");
                obj.put("objectId", (Object)object.optJSONObject(f.getName()).optString("objectId", "null"));
                obj.put("className", (Object)"_Role");
                object.put(f.getName(), (Object)obj);
                continue;
            }
            if (!BmobObject.class.isAssignableFrom(f.getType()) || object.isNull(f.getName())) continue;
            obj = new JSONObject();
            obj.put("__type", (Object)"Pointer");
            obj.put("objectId", (Object)object.optJSONObject(f.getName()).optString("objectId", "null"));
            obj.put("className", (Object)f.getType().getSimpleName());
            object.put(f.getName(), (Object)obj);
        }
        return object;
    }

    protected JSONObject getCurrentData() {
        JSONObject object = null;
        try {
            object = new JSONObject(GsonUtil.toJson(this));
            object = BmobObject.disposePointerType(this, object);
            object.remove("_c_");
            if (data.length() > 0) {
                Iterator keys = data.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    object.put(key, data.opt(key));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

    private JSONObject buildParams() {
        JSONObject params = new JSONObject();
        try {
            JSONObject object = this.getCurrentData();
            object.remove("createdAt");
            object.remove("updatedAt");
            object.remove("objectId");
            params.put("data", (Object)object);
            params.put("c", (Object)this.getTableName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return params;
    }

    private JSONObject updateParams(String objectId, BmobFactory.CheckInfo checkInfo) {
        checkInfo.work();
        JSONObject params = new JSONObject();
        try {
            JSONObject object = this.getCurrentData();
            object.remove("createdAt");
            object.remove("updatedAt");
            object.remove("objectId");
            if (BmobInstallation.class.isAssignableFrom(this.getClass())) {
                object.remove("deviceType");
                object.remove("installationId");
            } else if (BmobRole.class.isAssignableFrom(this.getClass())) {
                object.remove("name");
            }
            params.put("c", (Object)this.getTableName());
            if (increments.size() > 0) {
                for (JSONObject increment : increments) {
                    String key = increment.optString("key");
                    increment.remove("key");
                    object.put(key, (Object)increment);
                }
                increments.clear();
            }
            params.put("data", (Object)object);
            params.put("objectId", (Object)objectId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return params;
    }

    private RxBmob updateRequest(String objectId, UpdateListener listener) {
        JSONObject params = this.updateParams(objectId, BmobFactory.checkNull(objectId));
        return new RxBmob.Builder().check(BmobFactory.rByContext(objectId, " objectId can't be empty ")).nextTest(BmobURL.getDefault().getUrl("update"), params).map(new Function<JsonElement, Object>(){

            public Object apply(JsonElement e) {
                String updatedAt = JsonUtil.getString(e, "updatedAt");
                BmobObject.this.setUpdatedAt(updatedAt);
                return new BmobException();
            }
        }).subscribe(listener).build();
    }

    public Observable<BmobException> updateObservable(String objectId) {
        return this.updateRequest(objectId, null).getObservable();
    }

    public Observable<BmobException> updateObservable() {
        return this.updateObservable(this.getObjectId());
    }

    public Disposable update(UpdateListener listener) {
        return this.update(this.getObjectId(), listener);
    }

    public Disposable update(String objectId, UpdateListener listener) {
        return this.updateRequest(objectId, listener).getDisposable();
    }

    public String updateSync(String objectId) throws BmobException {
        String updatedAt = BmobClient.getInstance().updateSync(this.updateParams(objectId, new BmobFactory.CheckInfo(objectId, "objectId")));
        if (updatedAt != null) {
            this.setUpdatedAt(updatedAt);
        }
        return updatedAt;
    }

    public String updateSync() throws BmobException {
        String updatedAt = BmobClient.getInstance().updateSync(this.updateParams(this.getObjectId(), new BmobFactory.CheckInfo(this.objectId, "objectId")));
        if (updatedAt != null) {
            this.setUpdatedAt(updatedAt);
        }
        return updatedAt;
    }

    private RxBmob deleteRequest(String objectId, UpdateListener listener) {
        JSONObject params = new JSONObject();
        try {
            params.put("objectId", (Object)objectId);
            params.put("c", (Object)this.getTableName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(BmobFactory.rByContext(objectId, " objectId can't be empty ")).nextTest(BmobURL.getDefault().getUrl("delete"), params).mapVoid().subscribe(listener).build();
    }

    public Observable<Exception> deleteObservable(String objectId) {
        return this.deleteRequest(objectId, null).getObservable();
    }

    @Deprecated
    protected Disposable delete() {
        return this.delete(null);
    }

    public Disposable delete(UpdateListener listener) {
        return this.delete(this.getObjectId(), listener);
    }

    public Disposable delete(String objectId, UpdateListener listener) {
        return this.deleteRequest(objectId, listener).getDisposable();
    }

    public Disposable save(SaveListener<String> listener) {
        return this.saveRequest(listener).getDisposable();
    }

    private RxBmob saveRequest(SaveListener<String> listener) {
        JSONObject params = this.buildParams();
        RxBmob request = new RxBmob.Builder().checkTest(true, BmobFactory.rBySave(this.getTableName()), listener).nextTest(BmobURL.getDefault().getUrl("create"), params).map(new Function<JsonElement, String>(){

            public String apply(JsonElement e) {
                String objectId = JsonUtil.getString(e, "objectId");
                String createdAt = JsonUtil.getString(e, "createdAt");
                BmobObject.this.setObjectId(objectId);
                BmobObject.this.setCreatedAt(createdAt);
                return objectId;
            }
        }).subscribe(listener).build();
        return request;
    }

    public String saveSync() throws BmobException {
        JSONObject params = new JSONObject();
        try {
            JSONObject object = this.getCurrentData();
            object.remove("createdAt");
            object.remove("updatedAt");
            object.remove("objectId");
            params.put("data", (Object)object);
            params.put("c", (Object)this.getTableName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String objectId = BmobClient.getInstance().saveSync(params);
        return objectId;
    }

    public Observable<String> saveObservable() {
        return this.saveRequest(null).getObservable();
    }

    private RxBmob saveReq(SaveListener<String> listener) {
        JSONObject params = this.buildParams();
        RxBmob req = new RxBmob.Builder().check(BmobFactory.rBySave(this.getTableName())).nextTest(BmobURL.getDefault().getUrl("create"), params).map(new Function<JsonElement, String>(){

            public String apply(JsonElement element) {
                String objectId = JsonUtil.getString(element, "objectId");
                String createdAt = JsonUtil.getString(element, "createdAt");
                BmobObject.this.setObjectId(objectId);
                BmobObject.this.setCreatedAt(createdAt);
                return objectId;
            }
        }).subscribe(listener).build();
        return req;
    }
}

