/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import android.text.TextUtils;
import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.listener.PushListener;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Collections;
import org.json.JSONException;
import org.json.JSONObject;

public class BmobPushManager<T> {
    private BmobQuery<T> query;

    public Disposable pushMessage(String message) {
        return this.pushMessageTime(message, null, new PushListener(){

            @Override
            public void done(BmobException e) {
            }
        });
    }

    public Disposable pushMessageTime(String message, String push_time) {
        return this.pushMessageTime(message, push_time, new PushListener(){

            @Override
            public void done(BmobException e) {
            }
        });
    }

    public Disposable pushMessageTime(String message, String push_time, PushListener listener) {
        if (this.query != null) {
            return this.createStringRequest(message, push_time, this.query.getWhere(), listener).getDisposable();
        }
        return this.pushMessageAll(message, push_time, listener);
    }

    public Disposable pushMessage(String message, PushListener listener) {
        return this.pushMessageTime(message, null, listener);
    }

    public Disposable pushMessage(JSONObject data) {
        return this.pushMessage(data, new PushListener(){

            @Override
            public void done(BmobException e) {
            }
        });
    }

    public Disposable pushMessage(JSONObject data, PushListener listener) {
        if (this.query != null) {
            return this.createJSONRequest(data, this.query.getWhere(), listener).getDisposable();
        }
        return this.pushMessageAll(data, listener);
    }

    public Disposable pushMessageAll(JSONObject data) {
        return this.pushMessageAll(data, null);
    }

    public Disposable pushMessageAll(String message, String push_time, PushListener listener) {
        return this.createStringRequest(message, push_time, null, listener).getDisposable();
    }

    public Observable<Void> pushMessageAllObservable(String message) {
        return this.createStringRequest(message, null, null, null).getObservable();
    }

    public Disposable pushMessageAll(JSONObject data, PushListener listener) {
        return this.createJSONRequest(data, null, listener).getDisposable();
    }

    public Observable<Void> pushMessageAllObservable(JSONObject data) {
        return this.createJSONRequest(data, null, null).getObservable();
    }

    private RxBmob createStringRequest(String message, String push_time, JSONObject where, PushListener listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject alert = new JSONObject();
            alert.put("alert", (Object)message);
            JSONObject data = new JSONObject();
            data.put("data", (Object)alert);
            if (where != null) {
                params.put("where", (Object)where);
            }
            if (!TextUtils.isEmpty((CharSequence)push_time)) {
                params.put("push_time", (Object)push_time);
                params.put("expiration_interval", 518400);
            }
            params.put("data", (Object)data);
            System.out.println("params:" + params.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(Collections.emptyList()).nextTest(BmobURL.getDefault().getUrl("push"), params).mapVoid().subscribe(listener).build();
    }

    private RxBmob createJSONRequest(JSONObject message, JSONObject where, PushListener listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("data", (Object)message);
            if (where != null) {
                data.put("where", (Object)where);
            }
            params.put("data", (Object)data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(Collections.emptyList()).nextTest(BmobURL.getDefault().getUrl("push"), params).mapVoid().subscribe(listener).build();
    }

    public BmobQuery<T> getQuery() {
        return this.query;
    }

    public void setQuery(BmobQuery<T> query) {
        this.query = query;
    }
}

