/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.datatype.BmobGeoPoint;
import cn.bmob.v3.datatype.BmobPointer;
import cn.bmob.v3.datatype.BmobQueryResult;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.BmobNative;
import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.QueryConditions;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.http.cache.PolicyFactory;
import cn.bmob.v3.listener.BmobCallback;
import cn.bmob.v3.listener.CountListener;
import cn.bmob.v3.listener.FindListener;
import cn.bmob.v3.listener.QueryListener;
import cn.bmob.v3.listener.SQLQueryListener;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.CacheHelper;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BmobQuery<T> {
    private Context appContext;
    private CachePolicy cachePolicy;
    private long maxCacheAge;
    private String _c_;
    private QueryConditions conditions;
    private Class<T> queryClass;
    private boolean isUsingRelation = false;

    public BmobQuery() {
        this(null);
    }

    public BmobQuery(String tableName) {
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            this._c_ = tableName;
        }
        this.cachePolicy = CachePolicy.IGNORE_CACHE;
        this.maxCacheAge = 18000000L;
        this.conditions = new QueryConditions();
        this.appContext = Bmob.getApplicationContext();
    }

    protected Class<T> getQueryClass() {
        return this.queryClass;
    }

    protected void setQueryClass(Class<T> queryClass) {
        this.queryClass = queryClass;
    }

    private JSONObject getParams() {
        return this.conditions.getParams();
    }

    public JSONObject getWhere() {
        return this.conditions.getWhere();
    }

    public BmobQuery<T> addWhereLessThan(String key, Object value) {
        this.conditions.addWhereLessThan(key, value);
        return this;
    }

    public BmobQuery<T> addWhereLessThanOrEqualTo(String key, Object value) {
        this.conditions.addWhereLessThanOrEqualTo(key, value);
        return this;
    }

    public BmobQuery<T> addWhereGreaterThan(String key, Object value) {
        this.conditions.addWhereGreaterThan(key, value);
        return this;
    }

    public BmobQuery<T> addWhereGreaterThanOrEqualTo(String key, Object value) {
        this.conditions.addWhereGreaterThanOrEqualTo(key, value);
        return this;
    }

    public BmobQuery<T> addWhereEqualTo(String key, Object value) {
        this.conditions.addWhereEqualTo(key, value);
        return this;
    }

    public BmobQuery<T> addWhereNotEqualTo(String key, Object value) {
        this.conditions.addWhereNotEqualTo(key, value);
        return this;
    }

    public BmobQuery<T> addWhereContainsAll(String key, Collection<?> values) {
        this.conditions.addWhereContainsAll(key, values);
        return this;
    }

    public BmobQuery<T> addWhereContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.addWhereContainedIn(key, values);
        return this;
    }

    public BmobQuery<T> addWhereNotContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.addWhereNotContainedIn(key, values);
        return this;
    }

    public BmobQuery<T> addWhereMatches(String key, String regex) {
        this.conditions.addWhereMatches(key, regex);
        return this;
    }

    public BmobQuery<T> addWhereContains(String key, String value) {
        String regex = Pattern.quote(value);
        this.addWhereMatches(key, regex);
        return this;
    }

    public BmobQuery<T> addWhereStartsWith(String key, String prefix) {
        String regex = "^" + Pattern.quote(prefix);
        this.addWhereMatches(key, regex);
        return this;
    }

    public BmobQuery<T> addWhereEndsWith(String key, String suffix) {
        String regex = Pattern.quote(suffix) + "$";
        this.addWhereMatches(key, regex);
        return this;
    }

    public BmobQuery<T> addWhereNear(String key, BmobGeoPoint point) {
        this.conditions.addWhereNear(key, point);
        return this;
    }

    public BmobQuery<T> addWhereWithinMiles(String key, BmobGeoPoint point, double maxDistance) {
        this.conditions.addWhereWithinMiles(key, point, maxDistance);
        return this;
    }

    public BmobQuery<T> addWhereWithinKilometers(String key, BmobGeoPoint point, double maxDistance) {
        this.conditions.addWhereWithinKilometers(key, point, maxDistance);
        return this;
    }

    public BmobQuery<T> addWhereWithinRadians(String key, BmobGeoPoint point, double maxDistance) {
        this.conditions.addWhereWithinRadians(key, point, maxDistance);
        return this;
    }

    public BmobQuery<T> addWhereWithinGeoBox(String key, BmobGeoPoint southwest, BmobGeoPoint northeast) {
        this.conditions.addWhereWithinGeoBox(key, southwest, northeast);
        return this;
    }

    public BmobQuery<T> addWhereExists(String key) {
        this.conditions.addWhereExists(key);
        return this;
    }

    public BmobQuery<T> addWhereDoesNotExists(String key) {
        this.conditions.addWhereDoesNotExists(key);
        return this;
    }

    public BmobQuery<T> addWhereRelatedTo(String key, BmobPointer pointer) {
        this.conditions.addWhereRelatedTo(key, pointer);
        this.isUsingRelation = true;
        return this;
    }

    public <E> BmobQuery<T> addWhereMatchesQuery(String key, String className, BmobQuery<E> innerQuery) {
        this.conditions.addWhereMatchesQuery(key, className, innerQuery);
        return this;
    }

    public <E> BmobQuery<T> addWhereDoesNotMatchQuery(String key, String className, BmobQuery<E> innerQuery) {
        this.conditions.addWhereDoesNotMatchQuery(key, className, innerQuery);
        return this;
    }

    public BmobQuery<T> addQueryKeys(String keys) {
        this.conditions.addQueryKeys(keys);
        return this;
    }

    public BmobQuery<T> setLimit(int newLimit) {
        this.conditions.setLimit(newLimit);
        return this;
    }

    public BmobQuery<T> setPage(int currentPage, int count) {
        if (currentPage < 1) {
            currentPage = 1;
        }
        this.conditions.setSkip((currentPage - 1) * count);
        this.conditions.setLimit(count);
        return this;
    }

    public BmobQuery<T> setSkip(int newSkip) {
        this.conditions.setSkip(newSkip);
        return this;
    }

    public BmobQuery<T> order(String order) {
        this.conditions.setOrder(order);
        return this;
    }

    public BmobQuery<T> include(String fieldName) {
        this.conditions.setInclude(fieldName);
        return this;
    }

    public BmobQuery<T> or(List<BmobQuery<T>> where) {
        this.conditions.or(where);
        return this;
    }

    public BmobQuery<T> and(List<BmobQuery<T>> where) {
        this.conditions.and(where);
        return this;
    }

    public void setCachePolicy(CachePolicy newCachePolicy) {
        this.cachePolicy = newCachePolicy;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public void setMaxCacheAge(long maxAgeInMilliseconds) {
        this.maxCacheAge = maxAgeInMilliseconds;
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    private JSONObject generateQueryParams(Context context, Class<T> clazz) {
        this.conditions.setClazz(clazz);
        this.conditions.assembleParams();
        return BmobClient.generateCacheKey(context, this.getParams());
    }

    public Observable hasCachedResultObservable(final Class<T> clazz) {
        return new RxBmob.Builder().create((ObservableOnSubscribe)new ObservableOnSubscribe<Boolean>(){

            public void subscribe(ObservableEmitter<Boolean> emitter) {
                emitter.onNext((Object)BmobQuery.this.hasCachedResult(clazz));
            }
        }).subscribeOn(Schedulers.io()).build().getObservable();
    }

    public boolean hasCachedResult(Class<T> clazz) {
        String raw = CacheHelper.loadFromKeyValueCache(CacheHelper.getCacheKey(this.generateQueryParams(this.appContext, clazz)), this.maxCacheAge);
        return raw != null;
    }

    public void clearCachedResult(Class<T> clazz) {
        CacheHelper.clearFromKeyValueCache(CacheHelper.getCacheKey(this.generateQueryParams(this.appContext, clazz)));
    }

    public static void clearAllCachedResults() {
        CacheHelper.clearCacheDir();
    }

    private RxBmob findObjectsByTableRequest(boolean isNull, QueryListener<JSONArray> listener) {
        this.conditions.setQueryType(1);
        JSONObject params = this.conditions.assembleParams();
        try {
            params.put("c", (Object)this._c_);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().direct(BmobURL.getDefault().getUrl("find"), params).mapJSONArray().subscribe(listener).build();
    }

    public Observable<JSONArray> findObjectsByTableObservable() {
        return this.findObjectsByTableRequest(null).getObservable();
    }

    public Disposable findObjectsByTable(QueryListener<JSONArray> listener) {
        return this.doQueryTablenameGeneral(null, listener, false).getDisposable();
    }

    public Disposable getObjectByTable(String objectId, QueryListener<JSONObject> listener) {
        return this.doQueryTablenameGeneral(objectId, listener, true).getDisposable();
    }

    private RxBmob findObjectsByTableRequest(QueryListener<JSONArray> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        this.conditions.setQueryType(1);
        JSONObject params = this.conditions.assembleParams();
        try {
            params.put("c", (Object)this._c_);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().direct(BmobURL.getDefault().getUrl("find"), params).mapJSONArray().subscribe(listener).build();
    }

    private RxBmob getObjectByTableRequest(String objectId, QueryListener<JSONObject> listener) {
        if (TextUtils.isEmpty((CharSequence)objectId) || listener == null) {
            throw new IllegalArgumentException(" objectId or listener must not be null");
        }
        this.conditions.setQueryType(1);
        this.conditions.setObjectId(objectId);
        JSONObject params = this.conditions.assembleParams();
        try {
            params.put("c", (Object)this._c_);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().direct(BmobURL.getDefault().getUrl("find"), params).mapJSONObject().subscribe(listener).build();
    }

    private RxBmob doQueryTablenameGeneral(String objectId, BmobCallback listener, boolean isGetObj) {
        this.conditions.setQueryType(1);
        if (isGetObj) {
            if (TextUtils.isEmpty((CharSequence)objectId) || listener == null) {
                throw new IllegalArgumentException(" objectId or listener must not be null");
            }
            this.conditions.setObjectId(objectId);
        } else if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        JSONObject params = this.conditions.assembleParams();
        try {
            params.put("c", (Object)this._c_);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (isGetObj) {
            return new RxBmob.Builder().nextTest(BmobURL.getDefault().getUrl("find"), params).mapJSONObject().subscribe(listener).build();
        }
        return new RxBmob.Builder().nextTest(BmobURL.getDefault().getUrl("find"), params).mapJSONArray().subscribe(listener).build();
    }

    public Observable<JSONObject> getObjectByTableObservable(String objectId) {
        if (TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException(" objectId must not be null");
        }
        return this.getObjectByTableRequest(objectId, null).getObservable();
    }

    protected Disposable query(String objectId, Class<T> clazz, BmobCallback listener) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        this.conditions.setQueryType(2);
        if (!TextUtils.isEmpty((CharSequence)objectId)) {
            this.conditions.setObjectId(objectId);
        }
        this.conditions.setClazz(clazz);
        JSONObject params = this.conditions.assembleParams();
        return PolicyFactory.getInstance().createPolicySubscription(objectId, clazz, this.cachePolicy, this.maxCacheAge, BmobURL.getDefault().getUrl("find"), params, listener);
    }

    protected Disposable query(String objectId, BmobCallback listener, boolean isGetObj) {
        if (isGetObj) {
            if (TextUtils.isEmpty((CharSequence)objectId) || listener == null) {
                Log.e((String)"bmob", (String)"objectId or listener must not be null");
                return null;
            }
            this.conditions.setObjectId(objectId);
        } else if (listener == null) {
            Log.e((String)"bmob", (String)" listener must not be null ");
            return null;
        }
        return this.doQueryGeneral(objectId, listener, 2);
    }

    private Disposable doQueryGeneral(String objectId, BmobCallback listener, int queryType) {
        this.conditions.setQueryType(queryType);
        Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.conditions.setClazz(clazz);
        JSONObject params = this.conditions.assembleParams();
        return PolicyFactory.getInstance().createPolicySubscription(objectId, clazz, this.cachePolicy, this.maxCacheAge, BmobURL.getDefault().getUrl("find"), params, listener);
    }

    public Disposable findObjects(FindListener<T> listener) {
        return this.query(null, listener, false);
    }

    public List<T> findObjectsSync(Class<T> clazz) throws BmobException {
        if (!BmobNative.hasKey()) {
            BmobClient.getInstance().syncInitSDK();
        }
        this.conditions.setClazz(clazz);
        JSONObject params = this.conditions.assembleParams();
        return BmobClient.getInstance().findObjectsSync(clazz, params, this.cachePolicy);
    }

    public Observable<List<T>> findObjectsObservable(final Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return new RxBmob.Builder().create(new ObservableOnSubscribe<List<T>>(){

            public void subscribe(final ObservableEmitter<List<T>> emitter) throws Exception {
                if (emitter.isDisposed()) {
                    BLog.e("bmob", "findObjectsObservable: subscriber is unsubscribed ");
                    return;
                }
                BmobQuery.this.query(null, clazz, new FindListener<T>(){

                    @Override
                    public void done(List<T> t, BmobException e) {
                        if (e == null) {
                            emitter.onNext(t);
                        } else {
                            emitter.onError((Throwable)e);
                        }
                        emitter.onComplete();
                    }
                });
            }
        }).build().getObservable();
    }

    public Disposable getObject(String objectId, QueryListener<T> listener) {
        return this.query(objectId, listener, true);
    }

    public Observable<T> getObjectObservable(final Class<T> clazz, final String objectId) {
        if (TextUtils.isEmpty((CharSequence)objectId)) {
            throw new IllegalArgumentException(" objectId must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return new RxBmob.Builder().create(new ObservableOnSubscribe<T>(){

            public void subscribe(final ObservableEmitter<T> emitter) throws Exception {
                if (emitter.isDisposed()) {
                    BLog.e("bmob", "getObjectObservable: subscriber is unsubscribed ");
                    return;
                }
                BmobQuery.this.query(objectId, clazz, new QueryListener<T>(){

                    @Override
                    public void done(T t, BmobException e) {
                        if (e == null) {
                            emitter.onNext(t);
                        } else {
                            emitter.onError((Throwable)e);
                        }
                        emitter.onComplete();
                    }
                });
            }
        }).build().getObservable();
    }

    private RxBmob countRequest(Class<T> clazz, CountListener listener) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        this.conditions.setQueryType(3);
        this.conditions.setClazz(clazz);
        JSONObject params = this.conditions.assembleParams();
        return BmobFactory.getInstance().createCountRequest(BmobFactory.rByContext("no check", " no check"), BmobURL.getDefault().getUrl("find"), params, listener);
    }

    public Observable<Integer> countObservable(Class<T> clazz) {
        return this.countRequest(clazz, null).getObservable();
    }

    public Disposable count(Class<T> clazz, CountListener listener) {
        return this.countRequest(clazz, listener).getDisposable();
    }

    public BmobQuery<T> setHasGroupCount(boolean hasCount) {
        this.conditions.setHasGroupCount(hasCount);
        return this;
    }

    public BmobQuery<T> groupby(String[] groupKeys) {
        this.conditions.groupby(groupKeys);
        return this;
    }

    public BmobQuery<T> sum(String[] sumKeys) {
        this.conditions.sum(sumKeys);
        return this;
    }

    public BmobQuery<T> average(String[] averageKeys) {
        this.conditions.average(averageKeys);
        return this;
    }

    public BmobQuery<T> max(String[] maxKeys) {
        this.conditions.max(maxKeys);
        return this;
    }

    public BmobQuery<T> min(String[] minKeys) {
        this.conditions.min(minKeys);
        return this;
    }

    public BmobQuery<T> having(HashMap<String, Object> map) {
        this.conditions.having(map);
        return this;
    }

    public Disposable findStatistics(Class<?> clazz, QueryListener<JSONArray> listener) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return this.findStatisticsRequest(clazz, listener).getDisposable();
    }

    public Observable<JSONArray> findStatisticsObservable(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return this.findStatisticsRequest(clazz, null).getObservable();
    }

    private RxBmob findStatisticsRequest(Class<?> clazz, QueryListener<JSONArray> listener) {
        this.conditions.setQueryType(4);
        this.conditions.setClazz(clazz);
        JSONObject params = this.conditions.assembleParams();
        return BmobFactory.getInstance().createStatisticsRequest(BmobFactory.rByContext("no check", " no check"), BmobURL.getDefault().getUrl("find"), params, listener);
    }

    public BmobQuery<T> setSQL(String bql) {
        this.conditions.setBql(bql);
        return this;
    }

    public BmobQuery<T> setPreparedParams(Object[] values) {
        this.conditions.setValues(values);
        return this;
    }

    private Disposable doSQLQuery(Class<T> clazz, SQLQueryListener<T> listener) {
        this.conditions.setQueryType(5);
        JSONObject params = this.conditions.assembleParams();
        return PolicyFactory.getInstance().createPolicySubscription(null, clazz, this.cachePolicy, this.maxCacheAge, BmobURL.getDefault().getUrl("cloud_query"), params, listener);
    }

    public Disposable doSQLQuery(SQLQueryListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return this.doSQLQuery(clazz, listener);
    }

    public Observable<BmobQueryResult<T>> doSQLQueryObservable(final Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return new RxBmob.Builder().create(new ObservableOnSubscribe<BmobQueryResult<T>>(){

            public void subscribe(final ObservableEmitter<BmobQueryResult<T>> emitter) {
                if (emitter.isDisposed()) {
                    BLog.e("bmob", "doSQLQueryObservable: subscriber is unSubscribed ");
                    return;
                }
                BmobQuery.this.doSQLQuery(clazz, new SQLQueryListener<T>(){

                    @Override
                    public void done(BmobQueryResult<T> t, BmobException e) {
                        if (e == null) {
                            emitter.onNext(t);
                        } else {
                            emitter.onError((Throwable)e);
                        }
                        emitter.onComplete();
                    }
                });
            }
        }).build().getObservable();
    }

    public Disposable doSQLQuery(String bql, SQLQueryListener<T> listener) {
        return this.doSQLQuery(bql, listener, new Object[0]);
    }

    public Disposable doSQLQuery(String bql, SQLQueryListener<T> listener, Object ... params) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return this.doBql(clazz, bql, listener, params);
    }

    public Disposable doStatisticQuery(String bql, QueryListener<JSONArray> listener) {
        return this.doBql(null, bql, listener, new Object[0]);
    }

    public Disposable doStatisticQuery(String bql, QueryListener<JSONArray> listener, Object ... params) {
        return this.doBql(null, bql, listener, params);
    }

    private Disposable doBql(Class<T> clazz, String bql, BmobCallback listener, Object ... values) {
        this.conditions.setQueryType(5);
        this.conditions.setBql(bql);
        if (values != null && values.length > 0) {
            Object[] objects = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                objects[i] = values[i];
            }
            this.conditions.setValues(objects);
        }
        JSONObject params = this.conditions.assembleParams();
        if (listener instanceof QueryListener) {
            return BmobFactory.getInstance().createBQLStatisticRequest(BmobURL.getDefault().getUrl("cloud_query"), params, listener).getDisposable();
        }
        if (listener instanceof SQLQueryListener) {
            return PolicyFactory.getInstance().createPolicySubscription(null, clazz, this.cachePolicy, this.maxCacheAge, BmobURL.getDefault().getUrl("cloud_query"), params, listener);
        }
        throw new IllegalArgumentException("doBql does not support this BmobCallback");
    }

    public static enum CachePolicy {
        IGNORE_CACHE,
        CACHE_ONLY,
        NETWORK_ONLY,
        CACHE_ELSE_NETWORK,
        NETWORK_ELSE_CACHE,
        CACHE_THEN_NETWORK;

    }
}

