/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import cn.bmob.v3.datatype.BmobSmsState;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.http.bean.R1;
import cn.bmob.v3.listener.QueryListener;
import cn.bmob.v3.listener.UpdateListener;
import com.google.gson.JsonElement;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class BmobSMS {
    private static RxBmob createRequest(List<R1> list, String url, JSONObject params, QueryListener<Integer> listener) {
        return new RxBmob.Builder().check(list).nextTest(url, params).map(new Function<JsonElement, Integer>(){

            public Integer apply(JsonElement data) {
                Integer smsId = data.getAsJsonObject().get("smsId").getAsInt();
                return smsId;
            }
        }).subscribe(listener).build();
    }

    private static RxBmob createSMSRequest(String phoneNumber, String smsContent, String sendTime, QueryListener<Integer> listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("mobilePhoneNumber", (Object)phoneNumber);
            data.put("content", (Object)smsContent);
            data.put("sendTime", (Object)sendTime);
            params.put("data", (Object)data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BmobSMS.createRequest(BmobFactory.rByNull(phoneNumber, "phoneNumber can't be empty", smsContent, "smsContent can't be empty", sendTime, "sendTime can't be empty"), BmobURL.getDefault().getUrl("request_sms"), params, listener);
    }

    private static Disposable requestSMS(String phoneNumber, String smsContent, String sendTime, QueryListener<Integer> listener) {
        return BmobSMS.createSMSRequest(phoneNumber, smsContent, sendTime, listener).getDisposable();
    }

    private static Observable<Integer> requestSMSObservable(String phoneNumber, String smsContent, String sendTime) {
        return BmobSMS.createSMSRequest(phoneNumber, smsContent, sendTime, null).getObservable();
    }

    private static RxBmob createSMSCodeRequest(String phoneNumber, String template, QueryListener<Integer> listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("mobilePhoneNumber", (Object)phoneNumber);
            data.put("template", (Object)template);
            params.put("data", (Object)data);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return BmobSMS.createRequest(BmobFactory.rByNull(phoneNumber, "phoneNumber can't be empty", template, "template can't be empty"), BmobURL.getDefault().getUrl("request_sms_code"), params, listener);
    }

    public static Disposable requestSMSCode(String phoneNumber, String template, QueryListener<Integer> listener) {
        return BmobSMS.createSMSCodeRequest(phoneNumber, template, listener).getDisposable();
    }

    public static Observable<Integer> requestSMSCodeObservable(String phoneNumber, String template) {
        return BmobSMS.createSMSCodeRequest(phoneNumber, template, null).getObservable();
    }

    private static RxBmob createVerifyRequest(String phoneNumber, String code, UpdateListener listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("mobilePhoneNumber", (Object)phoneNumber);
            data.put("smsCode", (Object)code);
            params.put("data", (Object)data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(BmobFactory.rByNull(phoneNumber, "phoneNumber can't be empty", code, "smsCode can't be empty")).nextTest(BmobURL.getDefault().getUrl("verify_sms_code"), params).mapVoid().subscribe(listener).build();
    }

    public static Disposable verifySmsCode(String phoneNumber, String smsCode, UpdateListener listener) {
        return BmobSMS.createVerifyRequest(phoneNumber, smsCode, listener).getDisposable();
    }

    public static Observable<Void> verifySmsCodeObservable(String phoneNumber, String smsCode) {
        return BmobSMS.createVerifyRequest(phoneNumber, smsCode, null).getObservable();
    }

    private static RxBmob createSmsStateRequest(Integer smsId, QueryListener<BmobSmsState> listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("smsId", (Object)smsId);
            params.put("data", (Object)data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(BmobFactory.rByNull(smsId, "smsId is null!")).nextTest(BmobURL.getDefault().getUrl("query_sms"), params).map(new Function<JsonElement, BmobSmsState>(){

            public BmobSmsState apply(JsonElement data) {
                String smsState = data.getAsJsonObject().get("sms_state").getAsString();
                String verifyState = data.getAsJsonObject().get("verify_state").getAsString();
                return new BmobSmsState(smsState, verifyState);
            }
        }).subscribe(listener).build();
    }

    public static Disposable querySmsState(Integer smsId, QueryListener<BmobSmsState> listener) {
        return BmobSMS.createSmsStateRequest(smsId, listener).getDisposable();
    }

    public static Observable<BmobSmsState> querySmsStateObservable(Integer smsId) {
        return BmobSMS.createSmsStateRequest(smsId, null).getObservable();
    }
}

