/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import android.text.TextUtils;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.BmobObject;
import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.http.bean.R1;
import cn.bmob.v3.listener.FetchUserInfoListener;
import cn.bmob.v3.listener.LogInListener;
import cn.bmob.v3.listener.QueryListener;
import cn.bmob.v3.listener.SaveListener;
import cn.bmob.v3.listener.UpdateListener;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.CacheManager;
import cn.bmob.v3.util.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class BmobUser
extends BmobObject {
    static JSONObject current;
    private static final long serialVersionUID = -1589804003600796026L;
    private String username;
    private String password;
    private String email;
    private Boolean emailVerified;
    private String sessionToken;
    private String mobilePhoneNumber;
    private Boolean mobilePhoneNumberVerified;

    @Override
    public String getTableName() {
        return "_User";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(Boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    public String getSessionToken() {
        return BmobContentProvider.getSessionToken();
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getMobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    public void setMobilePhoneNumber(String mobilePhoneNumber) {
        this.mobilePhoneNumber = mobilePhoneNumber;
    }

    public Boolean getMobilePhoneNumberVerified() {
        return this.mobilePhoneNumberVerified;
    }

    public void setMobilePhoneNumberVerified(Boolean mobilePhoneNumberVerified) {
        this.mobilePhoneNumberVerified = mobilePhoneNumberVerified;
    }

    public <T> Disposable signOrLogin(String smsCode, SaveListener<T> listener) {
        return this.requestSignSubscription(BmobFactory.rByContext(smsCode, " Verify code can't be empty "), BmobURL.getDefault().getUrl("login_or_signup"), smsCode, listener);
    }

    public <T> Observable<T> signOrLoginObservable(Class<T> clazz, String smsCode) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return this.signRequest(clazz, BmobFactory.rByContext(smsCode, " Verify code can't be empty "), BmobURL.getDefault().getUrl("login_or_signup"), smsCode, null).getObservable();
    }

    public <T> Observable<T> signUpObservable(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return this.signRequest(clazz, BmobFactory.rByContext("no check", " no check "), BmobURL.getDefault().getUrl("signup"), null, null).getObservable();
    }

    public <T> Disposable signUp(SaveListener<T> listener) {
        return this.requestSignSubscription(BmobFactory.rByContext("no check", " no check "), BmobURL.getDefault().getUrl("signup"), null, listener);
    }

    private <T> RxBmob signRequest(final Class<T> clazz, List<R1> list, String url, String code, SaveListener<T> listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject data = this.getCurrentData();
            if (!TextUtils.isEmpty((CharSequence)code)) {
                data.put("smsCode", (Object)code);
            }
            params.put("data", (Object)data);
            params.put("c", (Object)this.getTableName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(list).nextTest(url, params).map(new Function<JsonElement, Object>(){

            public T apply(JsonElement data) {
                String user = BmobUser.this.getUserJson(data, clazz);
                BmobContentProvider.updateUser(user, clazz);
                JsonElement session = data.getAsJsonObject().get("sessionToken");
                if (session != null) {
                    String sessionToken = session.getAsString();
                    BmobContentProvider.updateSessionToken(sessionToken);
                }
                return GsonUtil.toObject(user, clazz);
            }
        }).subscribe(listener).build();
    }

    private <T> String getUserJson(JsonElement data, Class<T> clazz) {
        String user = "";
        if (data.isJsonObject()) {
            JSONObject obj;
            JsonObject dataJson = data.getAsJsonObject();
            if (dataJson.has("objectId")) {
                this.setObjectId(dataJson.get("objectId").getAsString());
            }
            if (dataJson.has("createdAt")) {
                this.setCreatedAt(dataJson.get("createdAt").getAsString());
            }
            if (dataJson.has("sessionToken")) {
                String session = data.getAsJsonObject().get("sessionToken").getAsString();
                this.setSessionToken(session);
            }
            if (dataJson.has("mobilePhoneNumber")) {
                this.setMobilePhoneNumber(dataJson.get("mobilePhoneNumber").getAsString());
            }
            if (dataJson.has("mobilePhoneNumberVerified")) {
                this.setMobilePhoneNumberVerified(dataJson.get("mobilePhoneNumberVerified").getAsBoolean());
            }
            if ((obj = this.getCurrentData()).has("password")) {
                obj.remove("password");
            }
            user = obj.toString();
            JsonElement session = data.getAsJsonObject().get("sessionToken");
            if (session != null) {
                String sessionToken = session.getAsString();
                BmobContentProvider.updateSessionToken(sessionToken);
            }
            BmobContentProvider.updateUser(user, clazz);
        }
        return user;
    }

    private <T> Disposable requestSignSubscription(List<R1> list, String url, String code, SaveListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return this.signRequest(clazz, list, url, code, listener).getDisposable();
    }

    private <T> RxBmob loginRequest(final Class<T> clazz, SaveListener<T> listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject object = new JSONObject();
            object.put("username", (Object)this.getUsername());
            object.put("password", (Object)this.getPassword());
            params.put("data", (Object)object);
            params.put("c", (Object)this.getTableName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(BmobFactory.rByEmpty(this.getUsername(), " username can't be empty ", this.getPassword(), " password can't be empty ")).nextTest(BmobURL.getDefault().getUrl("login"), params).doOnNext(new Consumer<JsonElement>(){

            public void accept(JsonElement data) {
                String user = data.getAsJsonObject().toString();
                JsonElement session = data.getAsJsonObject().get("sessionToken");
                if (session != null) {
                    String sessionToken = session.getAsString();
                    BmobContentProvider.updateSessionToken(sessionToken);
                }
                BmobContentProvider.updateUser(user, clazz);
            }
        }).map(new Function<JsonElement, Object>(){

            public T apply(JsonElement data) {
                BmobUser.this.setObjectId(JsonUtil.getString(data, "objectId"));
                BmobUser.this.setCreatedAt(JsonUtil.getString(data, "createdAt"));
                BmobUser.this.setUpdatedAt(JsonUtil.getString(data, "updatedAt"));
                BmobUser.this.setSessionToken(JsonUtil.getString(data, "sessionToken"));
                if (data.getAsJsonObject().has("emailVerified")) {
                    BmobUser.this.setEmailVerified(JsonUtil.getBoolean(data, "emailVerified"));
                }
                return GsonUtil.toObject(data, clazz);
            }
        }).subscribe(listener).build();
    }

    public <T> Disposable login(SaveListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return this.loginRequest(clazz, listener).getDisposable();
    }

    public <T> Observable<T> loginObservable(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return this.loginRequest(clazz, null).getObservable();
    }

    @Deprecated
    public Disposable save(SaveListener listener) {
        throw new IllegalArgumentException(" _User does not support save operation,please use login / signUp method.");
    }

    @Override
    public Disposable update(UpdateListener listener) {
        return this.update(this.getObjectId(), listener);
    }

    private RxBmob updateRequest(final String objectId, UpdateListener listener) {
        final Class<?> targetClass = this.getClass();
        final JSONObject params = new JSONObject();
        try {
            current = new JSONObject(GsonUtil.toJson(this));
            JSONObject data = this.getCurrentData();
            data.remove("objectId");
            data.remove("sessionToken");
            data.remove("createdAt");
            data.remove("updatedAt");
            if (increments.size() > 0) {
                for (JSONObject increment : increments) {
                    String key = increment.optString("key");
                    increment.remove("key");
                    data.put(key, (Object)increment);
                }
                increments.clear();
            }
            params.put("data", (Object)data);
            params.put("c", (Object)this.getTableName());
            params.put("objectId", (Object)objectId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(BmobFactory.rByContext(objectId, " objectId can't be empty ")).nextTest(BmobURL.getDefault().getUrl("update"), params).doOnNext(new Consumer<JsonElement>(){

            public void accept(JsonElement element) {
                try {
                    String updatedAt = element.getAsJsonObject().get("updatedAt").getAsString();
                    current.put("updatedAt", (Object)updatedAt);
                    if (objectId.equals(BmobUser.getCurrentUser().getObjectId())) {
                        String data = params.getJSONObject("data").toString();
                        CacheManager.getInstance(Bmob.getApplicationContext()).changeCurrentUser(current.toString(), data, targetClass);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).map(new Function<JsonElement, BmobException>(){

            public BmobException apply(JsonElement element) {
                String updatedAt = element.getAsJsonObject().get("updatedAt").getAsString();
                BmobUser.this.setUpdatedAt(updatedAt);
                BmobUser.this.setObjectId(objectId);
                return new BmobException();
            }
        }).subscribe(listener).build();
    }

    @Override
    public Observable<BmobException> updateObservable(String objectId) {
        return this.updateRequest(objectId, null).getObservable();
    }

    @Override
    public Disposable update(String objectId, UpdateListener listener) {
        return this.updateRequest(objectId, listener).getDisposable();
    }

    private static RxBmob loginWithAuthDataRequest(BmobThirdUserAuth authInfo, LogInListener<JSONObject> listener) {
        final JSONObject auth = authInfo == null ? new JSONObject() : authInfo.toJSONObject();
        JSONObject params = new JSONObject();
        try {
            params.put("data", (Object)new JSONObject().put("authData", (Object)auth));
            params.put("c", (Object)"_User");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(BmobFactory.rByNull(authInfo, "authInfo is null")).nextTest(BmobURL.getDefault().getUrl("login_or_signup"), params).doOnNext(new Consumer<JsonElement>(){

            public void accept(JsonElement element) {
                try {
                    BmobContentProvider.updateUser(element.toString(), BmobUser.class);
                    JsonElement session = element.getAsJsonObject().get("sessionToken");
                    if (session != null) {
                        String sessionToken = session.getAsString();
                        BmobContentProvider.updateSessionToken(sessionToken);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).map(new Function<JsonElement, Object>(){

            public JSONObject apply(JsonElement element) {
                return auth;
            }
        }).subscribe(listener).build();
    }

    public static Disposable loginWithAuthData(BmobThirdUserAuth authInfo, LogInListener<JSONObject> listener) {
        return BmobUser.loginWithAuthDataRequest(authInfo, listener).getDisposable();
    }

    public static Observable<JSONObject> loginWithAuthDataObservable(BmobThirdUserAuth authInfo) {
        return BmobUser.loginWithAuthDataRequest(authInfo, null).getObservable();
    }

    private static RxBmob associateWithAuthDataRequest(BmobThirdUserAuth authInfo, UpdateListener listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject authObj = new JSONObject();
            params.put("data", (Object)authObj.put("authData", (Object)authInfo.toJSONObject()));
            params.put("c", (Object)"_User");
            params.put("objectId", (Object)BmobUser.getCurrentUser().getObjectId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createCheckRequest(BmobFactory.rByNull(BmobUser.getCurrentUser(), " user must be login before associate ", authInfo, " authInfo is null"), BmobURL.getDefault().getUrl("update"), params, listener);
    }

    public static Observable<Void> associateWithAuthDataObservable(BmobThirdUserAuth authInfo, UpdateListener listener) {
        return BmobUser.associateWithAuthDataRequest(authInfo, listener).getObservable();
    }

    public static Disposable associateWithAuthData(BmobThirdUserAuth authInfo, UpdateListener listener) {
        return BmobUser.associateWithAuthDataRequest(authInfo, listener).getDisposable();
    }

    private static RxBmob dissociateAuthDataRequest(String type, UpdateListener listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject authObj = new JSONObject();
            authObj.put("authData", (Object)new JSONObject().put(type, JSONObject.NULL));
            params.put("data", (Object)authObj);
            params.put("c", (Object)"_User");
            params.put("objectId", (Object)BmobUser.getCurrentUser().getObjectId());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return BmobFactory.getInstance().createCheckRequest(BmobFactory.rByNull(BmobUser.getCurrentUser(), " user must be login before disassociate ", type, " type  is null"), BmobURL.getDefault().getUrl("update"), params, listener);
    }

    public static Disposable dissociateAuthData(String type, UpdateListener listener) {
        return BmobUser.dissociateAuthDataRequest(type, listener).getDisposable();
    }

    public Observable<Void> dissociateAuthDataObservable(String type) {
        return BmobUser.dissociateAuthDataRequest(type, null).getObservable();
    }

    private static RxBmob requestEmailVerifyRequest(String email, UpdateListener listener) {
        JSONObject params = new JSONObject();
        try {
            params = new JSONObject();
            params.put("data", (Object)new JSONObject().put("email", (Object)email));
            params.put("c", (Object)"_User");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createCheckRequest(BmobFactory.rByContext(email, " email  can't be empty"), BmobURL.getDefault().getUrl("email_verify"), params, listener);
    }

    public static Disposable requestEmailVerify(String email, UpdateListener listener) {
        return BmobUser.requestEmailVerifyRequest(email, listener).getDisposable();
    }

    public static Observable<BmobException> requestEmailVerifyObservable(String email) {
        return BmobUser.requestEmailVerifyRequest(email, null).getObservable();
    }

    private static RxBmob resetPasswordByEmailRequest(String email, UpdateListener listener) {
        JSONObject params = new JSONObject();
        try {
            params = new JSONObject();
            params.put("data", (Object)new JSONObject().put("email", (Object)email));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createCheckRequest(BmobFactory.rByContext(email, " email  can't be empty"), BmobURL.getDefault().getUrl("reset"), params, listener);
    }

    public static Disposable resetPasswordByEmail(String email, UpdateListener listener) {
        return BmobUser.resetPasswordByEmailRequest(email, listener).getDisposable();
    }

    public static Observable<BmobException> resetPasswordByEmailObservable(String email) {
        return BmobUser.resetPasswordByEmailRequest(email, null).getObservable();
    }

    private static RxBmob resetPasswordBySMSCodeRequest(String smsCode, String newPassword, UpdateListener listener) {
        JSONObject params = new JSONObject();
        try {
            params = new JSONObject();
            JSONObject data = new JSONObject();
            data.put("smsCode", (Object)smsCode);
            data.put("password", (Object)newPassword);
            params.put("data", (Object)data);
            params.put("c", (Object)"_User");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createCheckRequest(BmobFactory.rByEmpty(smsCode, " Verify code can't be empty", newPassword, " newPassword can't be empty"), BmobURL.getDefault().getUrl("phone_reset"), params, listener);
    }

    public static Disposable resetPasswordBySMSCode(String smsCode, String newPassword, UpdateListener listener) {
        return BmobUser.resetPasswordBySMSCodeRequest(smsCode, newPassword, listener).getDisposable();
    }

    public static Observable<BmobException> resetPasswordBySMSCodeObservable(String smsCode, String newPassword) {
        return BmobUser.resetPasswordBySMSCodeRequest(smsCode, newPassword, null).getObservable();
    }

    private static <T> RxBmob loginByAccountRequest(Class<T> clazz, String account, String password, LogInListener<T> listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("username", (Object)account);
            data.put("password", (Object)password);
            params.put("data", (Object)data);
            params.put("c", (Object)"_User");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createLoginRequest(clazz, BmobFactory.rByEmpty(account, " account can't be empty ", password, " password can't be empty "), BmobURL.getDefault().getUrl("login"), params, listener);
    }

    public static <T> Disposable loginByAccount(String account, String password, LogInListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return BmobUser.loginByAccountRequest(clazz, account, password, listener).getDisposable();
    }

    public static <T> Observable<T> loginByAccountObservable(Class<T> clazz, String account, String password) {
        if (clazz == null) {
            throw new IllegalArgumentException(" class must not be null ");
        }
        return BmobUser.loginByAccountRequest(clazz, account, password, null).getObservable();
    }

    public static <T> Disposable loginBySMSCode(String phoneNumber, String smsCode, LogInListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return BmobUser.requestLogin(clazz, BmobURL.getDefault().getUrl("login"), phoneNumber, smsCode, listener).getDisposable();
    }

    public static <T> Disposable signOrLoginByMobilePhone(String phoneNumber, String smsCode, LogInListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
        Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return BmobUser.requestLogin(clazz, BmobURL.getDefault().getUrl("login_or_signup"), phoneNumber, smsCode, listener).getDisposable();
    }

    private static <T> RxBmob requestLogin(Class<T> clazz, String url, String phoneNumber, String smsCode, LogInListener<T> listener) {
        JSONObject params = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            data.put("mobilePhoneNumber", (Object)phoneNumber);
            data.put("smsCode", (Object)smsCode);
            params.put("data", (Object)data);
            params.put("c", (Object)"_User");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createLoginRequest(clazz, BmobFactory.rByEmpty(phoneNumber, " phoneNumber can't be empty ", smsCode, " smsCode can't be empty "), url, params, listener);
    }

    public static Disposable updateCurrentUserPassword(String oldPwd, String newPwd, UpdateListener listener) {
        JSONObject params = new JSONObject();
        try {
            BmobUser user = BmobUser.getCurrentUser();
            if (user == null) {
                // empty if block
            }
            String objectId = user.getObjectId();
            JSONObject data = new JSONObject();
            data.put("oldPassword", (Object)oldPwd);
            data.put("newPassword", (Object)newPwd);
            params.put("data", (Object)data);
            params.put("objectId", (Object)objectId);
            params.put("c", (Object)"_User");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BmobFactory.getInstance().createCheckRequest(BmobFactory.rByNull(oldPwd, " oldPassword can't be empty", newPwd, " newPassword can't be empty", BmobUser.getCurrentUser(), "Cannot update user password until it has been logined. Please call login first."), BmobURL.getDefault().getUrl("update_user_password"), params, listener).getDisposable();
    }

    public static <T> T getCurrentUser(Class<T> clazz) {
        String user = BmobContentProvider.getUser();
        if (TextUtils.isEmpty((CharSequence)user)) {
            return null;
        }
        return (T)GsonUtil.toObject(user, clazz);
    }

    public static BmobUser getCurrentUser() {
        return BmobUser.getCurrentUser(BmobUser.class);
    }

    public static boolean isLogin() {
        BmobUser bmobUser = BmobUser.getCurrentUser();
        return bmobUser != null;
    }

    public static <T> void fetchUserInfo(final FetchUserInfoListener<T> listener) {
        BmobUser.fetchUserJsonInfo(new FetchUserInfoListener<String>(){

            @Override
            public void done(String userJson, BmobException e) {
                if (e == null) {
                    Class clazz = (Class)((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                    Object user = GsonUtil.toObject(userJson, clazz);
                    BmobContentProvider.updateUser(userJson, clazz);
                    listener.done(user, null);
                } else {
                    listener.done(null, e);
                }
            }
        });
    }

    public static void fetchUserJsonInfo(final FetchUserInfoListener<String> listener) {
        if (BmobUser.getCurrentUser() == null) {
            listener.done(null, new BmobException(9024, "please login before call fetchUserInfo()"));
            return;
        }
        String objectId = BmobUser.getCurrentUser().getObjectId();
        BmobQuery query = new BmobQuery("_User");
        query.getObjectByTable(objectId, new QueryListener<JSONObject>(){

            @Override
            public void done(JSONObject object, BmobException e) {
                if (e == null) {
                    listener.done(object.toString(), null);
                } else {
                    listener.done(null, e);
                }
            }
        });
    }

    public static void logOut() {
        BmobContentProvider.removeLocalUser();
        BmobContentProvider.updateSessionToken("");
    }

    public static Object getObjectByKey(String key) {
        String current = BmobContentProvider.getUser();
        if (TextUtils.isEmpty((CharSequence)current)) {
            return null;
        }
        Object object = null;
        try {
            JSONObject obj = new JSONObject(current);
            object = obj.opt(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static class BmobThirdUserAuth {
        String snsType;
        String accessToken;
        String expiresIn;
        String userId;
        public static final String SNS_TYPE_WEIBO = "weibo";
        public static final String SNS_TYPE_QQ = "qq";
        public static final String SNS_TYPE_WEIXIN = "weixin";

        public BmobThirdUserAuth(String snsType, String accessToken, String expiresIn, String userId) {
            this.accessToken = accessToken;
            this.snsType = snsType;
            this.expiresIn = expiresIn;
            this.userId = userId;
        }

        protected static String getPlatformIdByType(String type) {
            if (SNS_TYPE_QQ.equalsIgnoreCase(type) || SNS_TYPE_WEIXIN.equalsIgnoreCase(type)) {
                return "openid";
            }
            return "uid";
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(String expiresIn) {
            this.expiresIn = expiresIn;
        }

        public String getSnsType() {
            return this.snsType;
        }

        public void setSnsType(String snsType) {
            this.snsType = snsType;
        }

        public JSONObject toJSONObject() {
            JSONObject json = new JSONObject();
            try {
                JSONObject obj = new JSONObject();
                if (!TextUtils.isEmpty((CharSequence)this.snsType)) {
                    obj.put(BmobThirdUserAuth.getPlatformIdByType(this.snsType), (Object)this.userId);
                }
                obj.put("access_token", (Object)this.accessToken);
                if (SNS_TYPE_QQ.equalsIgnoreCase(this.snsType)) {
                    obj.put("expires_in", Double.parseDouble(this.expiresIn));
                } else if (SNS_TYPE_WEIBO.equalsIgnoreCase(this.snsType)) {
                    obj.put("expires_in", Long.parseLong(this.expiresIn));
                } else {
                    obj.put("expires_in", Long.parseLong(this.expiresIn));
                }
                json.put(this.snsType, (Object)obj);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return json;
        }
    }
}

