/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3;

import android.content.Context;
import cn.bmob.v3.BmobConfig;
import cn.bmob.v3.BmobConstants;
import cn.bmob.v3.helper.BmobNative;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.Utils;
import java.io.File;

public class BmobWrapper {
    private static byte[] LOCK = new byte[0];
    private static volatile BmobWrapper INSTANCE;
    private final String applicationId;
    private final Context applicationContext;
    private final long connectTimeout;
    private final int uploadBlockSize;
    private final long fileExpiration;
    private File cacheDir;
    private File filesDir;

    static void initialize(BmobConfig config) {
        BmobWrapper.create(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BmobWrapper create(BmobConfig config) {
        if (INSTANCE != null) return INSTANCE;
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new BmobWrapper(config);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private BmobWrapper(BmobConfig config) {
        this.applicationContext = config.context.getApplicationContext();
        this.applicationId = config.applicationId;
        this.connectTimeout = config.connectTimeout;
        this.uploadBlockSize = config.uploadBlockSize;
        this.fileExpiration = config.fileExpiration;
        BmobNative.init(this.applicationContext, this.applicationId);
        BmobContentProvider.initProvider(this.applicationContext);
        Utils.checkBmobContentProvider(this.applicationContext);
        BLog.init();
    }

    private BmobWrapper() {
        this.applicationId = null;
        this.applicationContext = null;
        this.connectTimeout = 0L;
        this.uploadBlockSize = 0;
        this.fileExpiration = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BmobWrapper getInstance() {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCacheDir() {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            if (this.cacheDir == null) {
                this.cacheDir = new File(this.applicationContext.getCacheDir(), "cn.bmob");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BmobWrapper.createFileDir(this.cacheDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFilesDir() {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            if (this.filesDir == null) {
                this.filesDir = new File(this.applicationContext.getFilesDir(), "cn.bmob");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return BmobWrapper.createFileDir(this.filesDir);
        }
    }

    private static File createFileDir(File file) {
        if (!file.exists() && !file.mkdirs()) {
            return file;
        }
        return file;
    }

    public long getConnectTimeout() {
        if (this.connectTimeout == 0L) {
            return BmobConstants.CONNECT_TIMEOUT;
        }
        return this.connectTimeout;
    }

    public int getUploadBlockSize() {
        if (this.uploadBlockSize == 0) {
            return BmobConstants.BLOCK_SIZE;
        }
        return this.uploadBlockSize;
    }

    public long getFileExpiration() {
        if (this.fileExpiration == 0L) {
            return BmobConstants.EXPIRATION;
        }
        return this.fileExpiration;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }
}

