/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.ai;

import cn.bmob.v3.ai.ChatClient;
import cn.bmob.v3.ai.ChatMessageListener;
import cn.bmob.v3.ai.ChatMsg;
import java.util.Random;

public class BmobAI {
    private static ChatClient chat = null;
    static String summary = "";

    public BmobAI() {
        if (chat == null) {
            chat = new ChatClient();
            chat.connect();
        }
    }

    public BmobAI(String url) {
        if (chat == null) {
            if (!(url = url.replace("http", "ws")).endsWith("/")) {
                url = url + "/";
            }
            url = url + "1/ai";
            chat = new ChatClient(url);
            chat.connect();
        }
    }

    public void Connect() {
        if (!this.isConnect().booleanValue()) {
            chat.connect();
        }
    }

    public void Stop() {
        chat.Shutdown();
    }

    public void Clear(String session) {
        chat.Clear(session);
    }

    public void setUserChatMessage(String message, String session) {
        chat.setChatMessage(message, ChatMsg.USER, session);
    }

    public void setAssistantChatMessage(String message, String session) {
        chat.setChatMessage(message, ChatMsg.ASSISTANT, session);
    }

    private String SummaryChat(String session) {
        Integer max_length = 1800;
        String history = chat.getChatHostory(session);
        if (history.length() > max_length) {
            history = history.substring(history.length() - max_length);
        }
        int startUser = -1;
        int startAss = -1;
        startAss = history.indexOf(ChatMsg.ASSISTANT);
        startUser = history.indexOf(ChatMsg.USER);
        if (startAss != 0 && startUser != 0) {
            history = startAss < startUser ? history + ChatMsg.USER : history + history + ChatMsg.ASSISTANT;
            history = history + ":";
        }
        history = "\u8bf7\u5e2e\u6211\u628a\u4e0b\u9762\u7684\u804a\u5929\u5bf9\u8bdd\u751f\u6210\u5185\u5bb9\u6982\u8981\uff0c\u9650\u5236\u5728400\u5b57\u4ee5\u5185\u3002Please summary the following chat message below 400 Chinese words. \u804a\u5929\u5bf9\u8bdd\u5185\u5bb9\u5982\u4e0b\uff1a" + history;
        summary = "";
        this.getGPTSummary(history);
        try {
            Thread.sleep(6000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int tryNum = 30;
        while (tryNum > 0) {
            if (summary.isEmpty()) {
                --tryNum;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                continue;
            }
            return summary;
        }
        return "error";
    }

    private void getGPTSummary(final String history) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                BmobAI ai = new BmobAI();
                ai.Connect();
                Random random = new Random();
                int randNum = random.nextInt();
                ai.Chat(history, "getsummary" + String.valueOf(randNum), new ChatMessageListener(){

                    @Override
                    public void onMessage(String message) {
                    }

                    @Override
                    public void onFinish(String message) {
                        summary = message;
                    }

                    @Override
                    public void onError(String error) {
                    }

                    @Override
                    public void onClose() {
                    }
                });
            }
        });
        thread.start();
    }

    public void setPrompt(String prompt) {
        chat.setPrompt(prompt);
    }

    public Boolean isConnect() {
        return chat.isConnect();
    }

    public void Chat(String msg, String session, ChatMessageListener listener) {
        chat.SendMsg(msg, session, listener);
    }
}

