/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.ai;

import android.util.Base64;
import android.util.Log;
import cn.bmob.v3.ai.ChatMessageListener;
import cn.bmob.v3.ai.ChatMsg;
import cn.bmob.v3.helper.BmobNative;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatClient
extends WebSocketListener {
    private final OkHttpClient client;
    private WebSocket webSocket;
    private String url = "wss://api.codenow.cn/1/ai";
    private List<ChatMsg> msgList;
    private ChatMessageListener onMessageListener;
    private boolean finish = false;
    private String answer = "";
    private String question = "";
    private String session = "";
    private String prompt = "";
    private String secret = "";
    private boolean isConnecting = false;
    private Timer heartBeatTimer;
    private TimerTask heartBeatTask;
    private static final long HEARTBEAT_INTERVAL = 30000L;
    private boolean isConnect = false;

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public ChatClient() {
        Log.d((String)"ai", (String)"");
        this.client = new OkHttpClient().newBuilder().readTimeout(15000L, TimeUnit.MILLISECONDS).build();
        this.msgList = new ArrayList<ChatMsg>();
        this.question = "";
        this.answer = "";
        this.session = "";
    }

    public void Clear(String session) {
        Iterator<ChatMsg> iterator = this.msgList.iterator();
        while (iterator.hasNext()) {
            ChatMsg msg = iterator.next();
            if (!msg.getSession().equals(session)) continue;
            iterator.remove();
        }
    }

    public void Shutdown() {
        try {
            this.webSocket.cancel();
            this.isConnect = false;
        }
        catch (Exception e) {
            Log.d((String)"ai", (String)"\u4e3b\u52a8\u5173\u95ed\u4e86\u8fde\u63a5");
        }
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setListener(ChatMessageListener listener) {
        this.onMessageListener = listener;
    }

    public ChatClient(String url) {
        this.client = new OkHttpClient();
        this.msgList = new ArrayList<ChatMsg>();
        this.question = "";
        this.answer = "";
        this.session = "";
        this.url = url;
    }

    private String createSecret() {
        int length = 16;
        byte[] nonce = new byte[length];
        for (int i = 0; i < length; ++i) {
            nonce[i] = (byte)(Math.random() * 256.0);
        }
        return Base64.encodeToString((byte[])nonce, (int)0).trim();
    }

    private void startHeartBeat() {
        this.stopHeartBeat();
        this.heartBeatTimer = new Timer();
        this.heartBeatTask = new TimerTask(){

            @Override
            public void run() {
                Log.d((String)"ai", (String)"\u53d1\u9001\u5fc3\u8df3\u5230\u670d\u52a1\u5668");
                ChatClient.this.webSocket.send("ping");
            }
        };
        this.heartBeatTimer.schedule(this.heartBeatTask, 30000L, 30000L);
    }

    private void stopHeartBeat() {
        if (this.heartBeatTimer != null) {
            this.heartBeatTimer.cancel();
            this.heartBeatTimer = null;
        }
        if (this.heartBeatTask != null) {
            this.heartBeatTask.cancel();
            this.heartBeatTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            Log.d((String)"ai", (String)"\u5f00\u59cb\u8fde\u63a5");
            String appid = BmobNative.getAppId();
            String key = this.createSecret();
            String newurl = this.url.replace("http", "ws");
            Request request = new Request.Builder().url(newurl).addHeader("X-Bmob-Application-Id", appid).addHeader("Content-Type", "application/json").build();
            this.webSocket = this.client.newWebSocket(request, (WebSocketListener)this);
            Log.d((String)"ai", (String)"\u521b\u5efawebsocket");
        }
        finally {
            lock.unlock();
        }
    }

    public void SendMsg(String msg, String se, ChatMessageListener listener) {
        this.finish = false;
        this.answer = "";
        this.question = msg;
        this.session = se;
        this.onMessageListener = listener;
        this.msgList.add(new ChatMsg(msg, ChatMsg.USER, this.session));
        String sendMsg = "";
        try {
            sendMsg = this.getChatMsg(this.session);
            Log.d((String)"ai", (String)("\u53d1\u9001\u7684\u5185\u5bb9\u5982\u4e0b\uff1a" + sendMsg));
            if (!this.webSocket.send(sendMsg)) {
                Log.d((String)"ai", (String)"\u53d1\u9001\u6d88\u606f\u5230GPT\u5931\u8d25");
                this.isConnect = false;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public String getChatHostory(String session) {
        String ret = "";
        for (int i = 0; i < this.msgList.size(); ++i) {
            ChatMsg msg = this.msgList.get(i);
            if (msg.getSession() != session) continue;
            ret = ret + msg.getRole() + ":" + msg.getContent() + " ";
        }
        return ret;
    }

    public void setChatMessage(String message, String role, String session) {
        this.msgList.add(new ChatMsg(message, role, session));
    }

    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        Log.d((String)"ai", (String)"\u6253\u5f00\u8fde\u63a5");
        this.isConnect = true;
        this.startHeartBeat();
    }

    private String dealWithData(String message) {
        try {
            JSONObject jsonObject = new JSONObject(message);
            JSONObject choiceObject = jsonObject.getJSONArray("choices").getJSONObject(0);
            JSONObject deltaObject = choiceObject.getJSONObject("delta");
            message = deltaObject.getString("content");
            String finishReason = choiceObject.getString("finish_reason");
            if (finishReason.length() > 0) {
                this.finish = true;
            }
        }
        catch (JSONException e) {
            message = "";
        }
        return message;
    }

    private String getChatMsg(String se) throws JSONException {
        int num = 16;
        if (this.msgList == null || this.msgList.isEmpty()) {
            return "";
        }
        List<ChatMsg> retMsgList = new ArrayList();
        for (ChatMsg msg : this.msgList) {
            String sess = msg.getSession();
            if (sess == null || sess.isEmpty() || sess != se) continue;
            retMsgList.add(msg);
        }
        int size = retMsgList.size();
        if (size > num) {
            retMsgList = retMsgList.subList(size - num, size);
        }
        if (retMsgList.size() > 0 && ((ChatMsg)retMsgList.get(0)).getRole() != ChatMsg.USER) {
            retMsgList.remove(0);
        }
        if (this.prompt != "") {
            retMsgList.add(0, new ChatMsg(this.prompt, ChatMsg.SYSTEM, this.session));
        }
        JSONObject jsonSession = new JSONObject();
        JSONArray jsonSessionMsgArray = new JSONArray();
        for (ChatMsg msg : retMsgList) {
            JSONObject jsonMsg = new JSONObject();
            jsonMsg.put("content", (Object)msg.getContent());
            jsonMsg.put("role", (Object)msg.getRole());
            jsonSessionMsgArray.put((Object)jsonMsg);
        }
        jsonSession.put("messages", (Object)jsonSessionMsgArray);
        jsonSession.put("session", (Object)this.session);
        return jsonSession.toString();
    }

    public boolean isFinish() {
        return this.finish;
    }

    private boolean isPong(String msg) {
        try {
            JSONObject jsonObject = new JSONObject(msg);
            String success = jsonObject.getString("success");
            Log.d((String)"ai", (String)msg);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    public void onMessage(WebSocket webSocket, String t) {
        Log.d((String)"ai", (String)t);
        if (this.isPong(t)) {
            Log.d((String)"ai", (String)("\u63a5\u6536\u5230\u670d\u52a1\u5668\u7684\u5fc3\u8df3\u8fde\u63a5" + t));
            return;
        }
        Log.d((String)"ai", (String)"\u5f00\u59cb\u63a5\u53d7\u6d88\u606f");
        super.onMessage(webSocket, t);
        String text = this.dealWithData(t);
        this.answer = this.answer + text;
        if (this.finish) {
            if (text.isEmpty()) {
                this.msgList.add(new ChatMsg(this.answer, ChatMsg.ASSISTANT, this.session));
                this.finish = false;
                this.onMessageListener.onFinish(this.answer);
            } else if (this.msgList.size() > 0) {
                try {
                    ChatMsg lastMsg = this.msgList.get(this.msgList.size() - 1);
                    if (lastMsg.getRole() == "user" && lastMsg.getContent() == this.question) {
                        this.msgList.remove(-1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.finish = false;
                if (text.contains("Incorrect")) {
                    this.isConnect = false;
                }
                this.onMessageListener.onError(text);
            }
        }
        if (text != null && !this.finish) {
            this.onMessageListener.onMessage(text);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        super.onMessage(webSocket, bytes);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        this.stopHeartBeat();
        if (this.onMessageListener != null) {
            this.onMessageListener.onClose();
        }
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.isConnect = false;
    }

    public Boolean isConnect() {
        return this.isConnect;
    }
}

