/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype;

import android.content.Context;
import android.text.TextUtils;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.datatype.BmobReturn;
import cn.bmob.v3.datatype.up.BmobUploader;
import cn.bmob.v3.datatype.up.UpYunUploader;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.BmobFileDownloader;
import cn.bmob.v3.http.RequestUtils;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.http.bean.Upyun;
import cn.bmob.v3.listener.BmobErrorCallback;
import cn.bmob.v3.listener.DeleteBatchListener;
import cn.bmob.v3.listener.DownloadFileListener;
import cn.bmob.v3.listener.ProgressCallback;
import cn.bmob.v3.listener.UpdateListener;
import cn.bmob.v3.listener.UploadBatchListener;
import cn.bmob.v3.listener.UploadFileListener;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.ManifestUtils;
import cn.bmob.v3.util.Utils;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BmobFile
implements Serializable {
    private static final long serialVersionUID = -9145726747813570773L;
    private transient BmobUploader uploader;
    private transient BmobFileDownloader downloader;
    private transient File localFile;
    private transient Context context = Bmob.getApplicationContext();
    private String filename = null;
    private String group = null;
    protected String url = null;
    private String __type = "File";

    private String get__type() {
        return this.__type;
    }

    public BmobFile() {
    }

    public BmobFile(File file) {
        this.localFile = file;
    }

    public BmobFile(String fileName, String group, String url) {
        this.filename = fileName;
        this.group = group;
        this.url = url;
    }

    public void obtain(String fileName, String group, String url) {
        this.context = Bmob.getApplicationContext();
        this.filename = fileName;
        this.group = group;
        this.url = url;
    }

    public static BmobFile createEmptyFile() {
        BmobFile file = new BmobFile(new File(""));
        file.setFilename("test.apk");
        return file;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getGroup() {
        return this.group;
    }

    protected void setGroup(String group) {
        this.group = group;
    }

    public String getFilename() {
        return this.filename;
    }

    protected void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFileUrl() {
        String fileUrl;
        if (this.url.startsWith("http")) {
            fileUrl = this.url;
        } else {
            String fileSuffix = BmobContentProvider.getFile();
            fileUrl = fileSuffix + "/" + this.url;
        }
        return fileUrl;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public Disposable upload(UploadFileListener listener) {
        Disposable disposable = this.uploadblock(listener);
        return disposable;
    }

    public Disposable uploadblock(UploadFileListener listener) {
        Disposable disposable = this.cdnUpload(listener);
        return disposable;
    }

    private Disposable cdnUpload(UploadFileListener listener) {
        if (!this.checkContext(listener) || !this.checkFile(this.localFile, listener)) {
            return null;
        }
        if (listener != null) {
            listener.internalStart();
        }
        RxBmob rxBmob = this.uploadRequest(listener);
        Disposable disposable = rxBmob.getDisposable();
        return disposable;
    }

    private RxBmob uploadRequest(final UploadFileListener listener) {
        Observable<BmobException> exceptionObservable = this.uploadObservable(new ProgressCallback(){

            @Override
            public void onProgress(Integer value, long total) {
                if (listener != null) {
                    listener.onProgress(value);
                }
            }
        });
        RxBmob rxBmob = new RxBmob.Builder().create(exceptionObservable).subscribe(listener).build();
        return rxBmob;
    }

    public Observable<BmobException> uploadObservable(final ProgressCallback listener) {
        if (!this.checkContext(null) || !this.checkFile(this.localFile, null)) {
            return null;
        }
        Observable upload = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                int version = BmobContentProvider.getUpyunVersion();
                String json = BmobContentProvider.getUpyun();
                if (version == -1 || version < BmobClient.curCDNVersion || TextUtils.isEmpty((CharSequence)json)) {
                    emitter.onNext((Object)json);
                } else {
                    emitter.onNext((Object)json);
                }
            }
        }).concatMap((Function)new Function<String, Observable<? extends BmobException>>(){

            public Observable<? extends BmobException> apply(String json) {
                BLog.e(json);
                if (TextUtils.isEmpty((CharSequence)json)) {
                    Observable<Upyun> upyunObservable = BmobFactory.getInstance().createCDNObservable();
                    return upyunObservable.concatMap((Function)new Function<Upyun, Observable<? extends BmobException>>(){

                        public Observable<? extends BmobException> apply(Upyun result) {
                            Observable observable = BmobFile.this.rxUploadObservable(result, listener);
                            return observable;
                        }
                    });
                }
                Upyun result = (Upyun)GsonUtil.toObject(json, Upyun.class);
                Observable observable = BmobFile.this.rxUploadObservable(result, listener);
                return observable;
            }
        });
        return upload;
    }

    private Observable<BmobException> rxUploadObservable(final Upyun result, final ProgressCallback callback) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<BmobException>(){

            public void subscribe(final ObservableEmitter<BmobException> emitter) throws Exception {
                if (emitter.isDisposed()) {
                    BLog.i("uploadObservable:subscriber is cancel");
                    return;
                }
                BmobFile.this.doUpload(result, new UploadFileListener(){

                    @Override
                    public void done(BmobException e) {
                        if (e == null) {
                            BmobException bmobException = new BmobException();
                            emitter.onNext((Object)bmobException);
                        } else {
                            emitter.onError((Throwable)e);
                        }
                    }

                    @Override
                    public void onProgress(Integer value) {
                        super.onProgress(value);
                        if (callback != null) {
                            callback.onProgress(value, BmobFile.this.getLocalFile().length());
                        }
                    }
                });
            }
        }).concatMap((Function)new Function<BmobException, Observable<? extends BmobException>>(){

            public Observable<? extends BmobException> apply(BmobException aVoid) {
                return BmobFactory.getInstance().saveCDN(BmobFile.this.getFileUrl(), BmobFile.this.getFilename(), BmobFile.this.getLocalFile().length());
            }
        });
    }

    private void doUpload(Upyun result, UploadFileListener listener) {
        this.cancelUpload();
        this.uploader = this.getUploader(this.context, result, listener);
        this.uploader.execute();
    }

    private BmobUploader getUploader(Context context, Upyun result, UploadFileListener listener) {
        return new UpYunUploader(context, result, this, listener);
    }

    public void cancel() {
        this.cancelUpload();
        this.cancelDownload();
    }

    private void cancelUpload() {
        if (this.uploader != null) {
            this.uploader.cancel(true);
        }
    }

    private void cancelDownload() {
        if (this.downloader != null) {
            this.downloader.cancel(true);
        }
    }

    public Disposable delete() {
        return this.delete(null);
    }

    public Disposable delete(UpdateListener listener) {
        String url = this.getUrl();
        return BmobFactory.getInstance().createDeleteCDNRequest(BmobFactory.rByNull(url, "url can't be empty"), url, listener).getDisposable();
    }

    public Observable<Void> deleteObservable() {
        String url = this.getUrl();
        return BmobFactory.getInstance().createDeleteCDNRequest(BmobFactory.rByNull(url, "url can't be empty"), url, null).getObservable();
    }

    public static Observable<BmobReturn<String[]>> deleteBatchObservable(String[] urls) {
        return BmobFactory.getInstance().createDeleteBatchCDNRequest(urls, null).getObservable();
    }

    public static Disposable deleteBatch(String[] urls, DeleteBatchListener listener) {
        return BmobFactory.getInstance().createDeleteBatchCDNRequest(urls, listener).getDisposable();
    }

    private boolean checkContext(BmobErrorCallback listener) {
        if (this.context == null && listener != null) {
            listener.doneError(9012, "context is null(9012).");
            return false;
        }
        String appkey = RequestUtils.getAppKey();
        if (TextUtils.isEmpty((CharSequence)appkey)) {
            if (listener != null) {
                listener.doneError(9001, "AppKey is Null, Please initialize BmobSDK(9001).");
            } else {
                BLog.e("bmob", "AppKey is Null, Please initialize BmobSDK(9001).");
            }
            return false;
        }
        if (!ManifestUtils.detectNetWork(this.context)) {
            if (listener != null) {
                listener.doneError(9016, "The network is not available,please check your network!(9016)");
            } else {
                BLog.e("bmob", "The network is not available,please check your network!(9016)");
            }
            return false;
        }
        if (!Utils.checkPermission(this.context, "android.permission.WAKE_LOCK")) {
            if (listener != null) {
                listener.doneError(9021, "permission not defined. You must write android.permission.WAKE_LOCK in AndroidManifest.xml.\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />(9021)");
            } else {
                BLog.e("bmob", "permission not defined. You must write android.permission.WAKE_LOCK in AndroidManifest.xml.\n<uses-permission android:name=\"android.permission.WAKE_LOCK\" />(9021)");
            }
            return false;
        }
        return true;
    }

    private boolean checkFile(File localFile, BmobErrorCallback listener) {
        if (localFile == null || !localFile.exists()) {
            if (listener != null) {
                listener.doneError(9008, "the file does not exist.");
            } else {
                BLog.e("bmob", "the file does not exist(9008)");
            }
            return false;
        }
        if (localFile.length() == 0L) {
            if (listener != null) {
                listener.doneError(9007, "the file length must be greater than zero.");
            } else {
                BLog.e("bmob", "the file length must be greater than zero(9007)");
            }
            return false;
        }
        return true;
    }

    public void download(DownloadFileListener listener) {
        if (this.context == null) {
            if (listener != null) {
                listener.doneError(9012, "context is null.");
            }
            return;
        }
        File savePath = new File(this.context.getApplicationContext().getCacheDir() + "/bmob/", this.getFilename());
        this.download(savePath, listener);
    }

    public void download(File savePath, DownloadFileListener listener) {
        if (!this.checkContext(listener)) {
            return;
        }
        String fileUrl = this.getFileUrl();
        if (TextUtils.isEmpty((CharSequence)fileUrl)) {
            if (listener != null) {
                listener.doneError(9018, "fileUrl can't be empty");
            }
            return;
        }
        if (savePath == null) {
            if (listener != null) {
                listener.doneError(9018, "savePath must not be null");
            }
            return;
        }
        this.cancelDownload();
        this.downloader = new BmobFileDownloader(this.context, fileUrl, savePath, listener);
        this.downloader.execute(new Void[0]);
    }

    public Observable<String> downloadObservable(ProgressCallback listener) {
        File savePath = new File(this.context.getApplicationContext().getCacheDir() + "/bmob/", this.getFilename());
        return this.downloadObservable(savePath, listener);
    }

    public Observable<String> downloadObservable(final File savePath, final ProgressCallback listener) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> emitter) throws Exception {
                if (emitter.isDisposed()) {
                    BLog.i("downloadObservable:subscriber is cancel");
                    return;
                }
                BmobFile.this.download(savePath, new DownloadFileListener(){

                    @Override
                    public void done(String s, BmobException e) {
                        if (e == null) {
                            emitter.onNext((Object)s);
                        } else {
                            emitter.onError((Throwable)e);
                        }
                        emitter.onComplete();
                    }

                    @Override
                    public void onProgress(Integer value, long total) {
                        if (listener != null) {
                            listener.onProgress(value, total);
                        }
                    }
                });
            }
        });
    }

    public static void uploadBatch(String[] filePaths, UploadBatchListener listener) {
        if (filePaths == null || filePaths.length == 0) {
            if (listener != null) {
                listener.onError(9008, "the files does not exist.");
            }
            return;
        }
        ArrayList<BmobFile> files = new ArrayList<BmobFile>();
        ArrayList<String> urls = new ArrayList<String>();
        BmobFile.uploadFile(0, filePaths, files, urls, listener);
    }

    private static void uploadFile(int index, String[] filePaths, List<BmobFile> files, List<String> urls, UploadBatchListener listener) {
        int len = filePaths.length;
        if (index + 1 < len) {
            BmobFile.uploadIndex(false, len, index, filePaths, files, urls, listener);
        } else {
            BmobFile.uploadIndex(true, len, index, filePaths, files, urls, listener);
        }
    }

    private static void uploadIndex(final boolean isFinish, final int len, final int index, final String[] filePaths, final List<BmobFile> fileNames, final List<String> urls, final UploadBatchListener listener) {
        File file = new File(filePaths[index]);
        final BmobFile bmobFile = new BmobFile(file);
        bmobFile.uploadblock(new UploadFileListener(){

            @Override
            public void done(BmobException e) {
                if (e == null) {
                    String url = bmobFile.getFileUrl();
                    fileNames.add(bmobFile);
                    urls.add(url);
                    listener.onSuccess(fileNames, urls);
                    if (!isFinish) {
                        BmobFile.uploadFile(index + 1, filePaths, fileNames, urls, listener);
                    }
                } else {
                    listener.onError(e.getErrorCode(), e.getMessage());
                }
            }

            @Override
            public void onProgress(Integer percent) {
                listener.onProgress(index + 1, percent, len, Utils.calculatePercent(index + 1, len));
            }
        });
    }
}

