/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype;

import java.io.Serializable;

public class BmobGeoPoint
implements Serializable {
    private static final long serialVersionUID = -2527515194340586771L;
    public static double EARTH_MEAN_RADIUS_KM = 6371.0;
    public static double EARTH_MEAN_RADIUS_MILE = 3958.8;
    private Double latitude = 0.0;
    private Double longitude = 0.0;
    private String __type = "GeoPoint";

    private String get__type() {
        return this.__type;
    }

    public BmobGeoPoint() {
    }

    public BmobGeoPoint(double longitude, double latitude) {
        this.setLongitude(longitude);
        this.setLatitude(latitude);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public void setLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("Latitude must be within the range (-90.0, 90.0).");
        }
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("Longitude must be within the range (-180.0, 180.0).");
        }
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double distanceInRadiansTo(BmobGeoPoint point) {
        double d2r = 0.0174532925199433;
        double lat1rad = this.latitude * d2r;
        double long1rad = this.longitude * d2r;
        double lat2rad = point.getLatitude() * d2r;
        double long2rad = point.getLongitude() * d2r;
        double deltaLat = lat1rad - lat2rad;
        double deltaLong = long1rad - long2rad;
        double sinDeltaLatDiv2 = Math.sin(deltaLat / 2.0);
        double sinDeltaLongDiv2 = Math.sin(deltaLong / 2.0);
        double a = sinDeltaLatDiv2 * sinDeltaLatDiv2 + Math.cos(lat1rad) * Math.cos(lat2rad) * sinDeltaLongDiv2 * sinDeltaLongDiv2;
        a = Math.min(1.0, a);
        return 2.0 * Math.asin(Math.sqrt(a));
    }

    public double distanceInKilometersTo(BmobGeoPoint point) {
        return this.distanceInRadiansTo(point) * EARTH_MEAN_RADIUS_KM;
    }

    public double distanceInMilesTo(BmobGeoPoint point) {
        return this.distanceInRadiansTo(point) * EARTH_MEAN_RADIUS_MILE;
    }
}

