/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype.up;

import cn.bmob.v3.Bmob;
import cn.bmob.v3.datatype.up.PostData;
import cn.bmob.v3.datatype.up.SignatureListener;
import cn.bmob.v3.datatype.up.UpCompleteListener;
import cn.bmob.v3.datatype.up.UpProgressListener;
import cn.bmob.v3.datatype.up.UpYunUtils;
import cn.bmob.v3.datatype.up.UploadClient;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.util.BLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BlockUploader
implements Runnable {
    private String bucket;
    private String url;
    private long expiration;
    private UpProgressListener progressListener;
    private UpCompleteListener completeListener;
    private File file;
    private UploadClient client;
    private String userPolicy;
    private String userSignature;
    private int totalBlockNum;
    private String saveToken;
    private String tokenSecret;
    private RandomAccessFile randomAccessFile = null;
    private int[] blockIndex;
    private PostData postData;
    private Map<String, Object> params;
    private String apiKey;
    private SignatureListener signatureListener;
    private int retryTime;
    private int blockSize;

    public BlockUploader(UploadClient upLoaderClient, File file, Map<String, Object> localParams, String apiKey, SignatureListener signatureListener, UpCompleteListener uiCompleteListener, UpProgressListener uiProgressListener) {
        this.client = upLoaderClient;
        this.file = file;
        this.params = localParams;
        this.progressListener = uiProgressListener;
        this.completeListener = uiCompleteListener;
        this.apiKey = apiKey;
        this.signatureListener = signatureListener;
        this.blockSize = Bmob.getFileBlockSize();
    }

    @Override
    public void run() {
        try {
            this.bucket = (String)this.params.remove("bucket");
            this.url = "http://m0.api.upyun.com/" + this.bucket;
            this.expiration = (Long)this.params.get("expiration");
            this.params.put("file_blocks", UpYunUtils.getBlockNum(this.file, this.blockSize));
            this.params.put("file_size", this.file.length());
            this.params.put("file_hash", UpYunUtils.md5Hex(this.file));
            String save_path = (String)this.params.remove("save-key");
            String path = (String)this.params.get("path");
            if (save_path != null && path == null) {
                this.params.put("path", save_path);
            }
            this.userPolicy = UpYunUtils.getPolicy(this.params);
            if (this.apiKey != null) {
                this.userSignature = UpYunUtils.getSignature(this.params, this.apiKey);
            } else if (this.signatureListener != null) {
                this.userSignature = this.signatureListener.getSignature(this.getParamsString(this.params));
            } else {
                throw new RuntimeException("apikey \u548c signatureListener \u4e0d\u53ef\u90fd\u4e3anull");
            }
            this.randomAccessFile = new RandomAccessFile(this.file, "r");
            this.totalBlockNum = UpYunUtils.getBlockNum(this.file, this.blockSize);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        this.initRequest();
    }

    private void initRequest() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("policy", this.userPolicy);
        paramMap.put("signature", this.userSignature);
        try {
            String response = this.client.post(this.url, paramMap);
            JSONObject initialResult = new JSONObject(response);
            this.saveToken = initialResult.optString("save_token");
            this.tokenSecret = initialResult.optString("token_secret");
            JSONArray array = initialResult.getJSONArray("status");
            this.blockIndex = this.getBlockIndex(array);
            if (this.blockIndex.length == 0) {
                this.mergeRequest();
            } else {
                this.blockUpload(0);
            }
        }
        catch (BmobException | IOException e) {
            boolean errCode;
            boolean isRetry = ++this.retryTime > 2;
            boolean bl = errCode = e instanceof BmobException && ((BmobException)e).getErrorCode() / 100 != 5;
            if (isRetry || errCode) {
                this.completeListener.onComplete(false, e.getMessage());
            } else {
                this.initRequest();
            }
        }
        catch (JSONException e) {
            this.completeListener.onComplete(false, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockUpload(int index) {
        while (true) {
            if (this.postData == null) {
                this.postData = new PostData();
            }
            try {
                this.postData.data = this.readBlockByIndex(index);
            }
            catch (BmobException e) {
                this.completeListener.onComplete(false, e.toString());
            }
            HashMap<String, Object> policyMap = new HashMap<String, Object>();
            policyMap.put("save_token", this.saveToken);
            policyMap.put("expiration", this.expiration);
            policyMap.put("block_index", this.blockIndex[index]);
            policyMap.put("block_hash", UpYunUtils.md5(this.postData.data));
            String policy = UpYunUtils.getPolicy(policyMap);
            String signature = UpYunUtils.getSignature(policyMap, this.tokenSecret);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("policy", policy);
            map.put("signature", signature);
            this.postData.fileName = this.file.getName();
            this.postData.params = map;
            try {
                this.client.blockMultipartPost(this.url, this.postData);
                if (this.progressListener != null) {
                    this.progressListener.onRequestProgress(index, this.blockIndex.length);
                }
                if (index++ != this.blockIndex.length - 1) continue;
                this.mergeRequest();
            }
            catch (BmobException | IOException e) {
                boolean errCode;
                boolean isRetry = ++this.retryTime > 2;
                boolean bl = errCode = e instanceof BmobException && ((BmobException)e).getErrorCode() / 100 != 5;
                if (!isRetry && !errCode) continue;
                this.completeListener.onComplete(false, e.getMessage());
            }
            finally {
                this.postData = null;
                continue;
            }
            break;
        }
    }

    private void mergeRequest() {
        HashMap<String, Object> paramsMapFinish = new HashMap<String, Object>();
        paramsMapFinish.put("expiration", this.expiration);
        paramsMapFinish.put("save_token", this.saveToken);
        String policyForMerge = UpYunUtils.getPolicy(paramsMapFinish);
        String signatureForMerge = UpYunUtils.getSignature(paramsMapFinish, this.tokenSecret);
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("policy", policyForMerge);
        paramMap.put("signature", signatureForMerge);
        try {
            String response = this.client.post(this.url, paramMap);
            this.progressListener.onRequestProgress(this.blockIndex.length, this.blockIndex.length);
            this.randomAccessFile.close();
            BLog.e(response);
            this.completeListener.onComplete(true, response);
        }
        catch (BmobException | IOException e) {
            boolean errCode;
            boolean isRetry = ++this.retryTime > 2;
            boolean bl = errCode = e instanceof BmobException && ((BmobException)e).getErrorCode() / 100 != 5;
            if (isRetry || errCode) {
                this.completeListener.onComplete(false, e.getMessage());
            }
            this.mergeRequest();
        }
    }

    private byte[] readBlockByIndex(int index) throws BmobException {
        if (index > this.totalBlockNum) {
            BLog.e("Block index error", "the index is bigger than totalBlockNum.");
            throw new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957");
        }
        byte[] block = new byte[this.blockSize];
        int readedSize = 0;
        try {
            int offset = this.blockIndex[index] * this.blockSize;
            this.randomAccessFile.seek(offset);
            readedSize = this.randomAccessFile.read(block, 0, this.blockSize);
        }
        catch (IOException e) {
            throw new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957");
        }
        if (readedSize < this.blockSize) {
            byte[] notFullBlock = new byte[readedSize];
            System.arraycopy(block, 0, notFullBlock, 0, readedSize);
            return notFullBlock;
        }
        return block;
    }

    private int[] getBlockIndex(JSONArray array) throws JSONException {
        int size = 0;
        for (int i = 0; i < array.length(); ++i) {
            if (array.getInt(i) != 0) continue;
            ++size;
        }
        int[] blockIndex = new int[size];
        int index = 0;
        for (int i = 0; i < array.length(); ++i) {
            if (array.getInt(i) != 0) continue;
            blockIndex[index] = i;
            ++index;
        }
        return blockIndex;
    }

    private String getParamsString(Map<String, Object> params) {
        Object[] keys = params.keySet().toArray();
        Arrays.sort(keys);
        StringBuffer tmp = new StringBuffer();
        for (Object key : keys) {
            tmp.append(key).append(params.get(key));
        }
        return tmp.toString();
    }
}

