/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype.up;

import android.annotation.SuppressLint;
import android.os.Build;
import cn.bmob.v3.datatype.BmobFile;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.listener.UploadFileListener;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@SuppressLint(value={"NewApi"})
public abstract class BmobUploader {
    protected final BmobFile bmobFile;
    protected UploadFileListener listener;
    private volatile boolean cancelled;
    private volatile Future future;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAX_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    protected BmobUploader(BmobFile bmobFile, UploadFileListener listener) {
        this.bmobFile = bmobFile;
        this.listener = listener;
        this.cancelled = false;
    }

    abstract void doUpload();

    public void execute() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                BmobUploader.this.doUpload();
            }
        };
        this.future = executor.submit(task);
    }

    protected void onCancelled() {
        if (this.listener != null) {
            this.listener.done(new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
        }
    }

    public boolean cancel(boolean interrupt) {
        if (!this.cancelled) {
            this.cancelled = true;
            if (interrupt) {
                this.interruptImmediately();
            } else if (this.future != null) {
                this.future.cancel(false);
            }
            this.onCancelled();
            return true;
        }
        return false;
    }

    public void interruptImmediately() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    static {
        if (Build.VERSION.SDK_INT >= 9) {
            executor.allowCoreThreadTimeOut(true);
        }
    }
}

