/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype.up;

import cn.bmob.v3.datatype.up.SignatureListener;
import cn.bmob.v3.datatype.up.UpCompleteListener;
import cn.bmob.v3.datatype.up.UpProgressListener;
import cn.bmob.v3.datatype.up.UpYunUtils;
import cn.bmob.v3.datatype.up.UploadClient;
import cn.bmob.v3.exception.BmobException;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class FormUploader
implements Runnable {
    private UploadClient client;
    private File file;
    private String bucket;
    private String policy;
    private String signature;
    private UpProgressListener progressListener;
    private UpCompleteListener completeListener;
    private int retryTime;
    private Map<String, Object> params;
    private String apiKey;
    private SignatureListener signatureListener;

    public FormUploader(UploadClient upLoaderClient, File file, Map<String, Object> localParams, String apiKey, SignatureListener signatureListener, UpCompleteListener uiCompleteListener, UpProgressListener uiProgressListener) {
        this.client = upLoaderClient;
        this.file = file;
        this.bucket = (String)localParams.get("bucket");
        this.params = localParams;
        this.apiKey = apiKey;
        this.signatureListener = signatureListener;
        this.completeListener = uiCompleteListener;
        this.progressListener = uiProgressListener;
    }

    @Override
    public void run() {
        String save_path = (String)this.params.get("save-key");
        String path = (String)this.params.remove("path");
        if (save_path == null && path != null) {
            this.params.put("save-key", path);
        }
        this.policy = UpYunUtils.getPolicy(this.params);
        if (this.apiKey != null) {
            this.signature = UpYunUtils.getSignature(this.policy, this.apiKey);
        } else if (this.signatureListener != null) {
            this.signature = this.signatureListener.getSignature(this.policy + "&");
        } else {
            throw new RuntimeException("apiKey \u548c signatureListener \u4e0d\u80fd\u540c\u65f6\u4e3anull");
        }
        String url = "http://v0.api.upyun.com/" + this.bucket;
        try {
            String response = this.client.fromUpLoad(this.file, url, this.policy, this.signature, this.progressListener);
            this.completeListener.onComplete(true, response);
        }
        catch (BmobException | IOException e) {
            boolean errCode;
            boolean isRetry = ++this.retryTime > 2;
            boolean bl = errCode = e instanceof BmobException && ((BmobException)e).getErrorCode() / 100 != 5;
            if (isRetry || errCode) {
                this.completeListener.onComplete(false, e.toString());
            }
            this.run();
        }
    }
}

