/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype.up;

import cn.bmob.v3.datatype.up.AsyncRun;
import cn.bmob.v3.datatype.up.UpCompleteListener;
import cn.bmob.v3.datatype.up.UpProgressListener;
import cn.bmob.v3.datatype.up.UpYunUtils;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.Base64Coder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ParallelUploader {
    private static final String AUTHORIZATION = "Authorization";
    private static final int BLOCK_SIZE = 0x100000;
    private static final String BACKSLASH = "/";
    private final String DATE = "Date";
    private static final String CONTENT_MD5 = "Content-MD5";
    private static final String CONTENT_TYPE = "CContent-Type";
    private static final String CONTENT_SECRET = "Content-Secret";
    private static final String X_Upyun_Meta_X = "X-Upyun-Meta-X";
    private static final String X_UPYUN_MULTI_DISORDER = "X-Upyun-Multi-Disorder";
    private static final String X_UPYUN_MULTI_STAGE = "X-Upyun-Multi-Stage";
    private static final String X_UPYUN_MULTI_TYPE = "X-Upyun-Multi-Type";
    private static final String X_UPYUN_MULTI_LENGTH = "X-Upyun-Multi-Length";
    private static final String X_UPYUN_MULTI_UUID = "X-Upyun-Multi-UUID";
    private static final String X_UPYUN_PART_ID = "X-Upyun-Part-ID";
    private static final String HOST = "https://v0.api.upyun.com";
    private String uuid;
    private OkHttpClient mClient;
    private File mFile;
    private RandomAccessFile randomAccessFile;
    private boolean checkMD5;
    protected String bucketName = null;
    protected String userName = null;
    protected String password = null;
    private String uri = null;
    private String date = null;
    private String signature = null;
    private boolean signed;
    private int timeout = 20;
    private String url;
    private UpProgressListener onProgressListener;
    private int totalBlock;
    private volatile int blockProgress;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private int paralle = 4;
    private int[] status;

    public void setParalle(int paralle) {
        this.paralle = paralle;
    }

    public ParallelUploader(String bucketName, String userName, String password) {
        this.bucketName = bucketName;
        this.userName = userName;
        this.password = password;
    }

    public ParallelUploader() {
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean upload(File file, String path, Map<String, String> params) throws IOException, BmobException, ExecutionException, InterruptedException {
        this.mFile = file;
        this.signed = false;
        this.totalBlock = (int)Math.ceil((double)this.mFile.length() / 1048576.0 + 2.0);
        this.randomAccessFile = new RandomAccessFile(this.mFile, "r");
        this.uri = path.startsWith(BACKSLASH) ? BACKSLASH + this.bucketName + BACKSLASH + URLEncoder.encode(path.substring(1)) : BACKSLASH + this.bucketName + BACKSLASH + URLEncoder.encode(path);
        this.url = HOST + this.uri;
        this.mClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
        if (this.status == null || this.status.length != this.totalBlock - 2 || this.uuid == null) {
            this.status = new int[this.totalBlock - 2];
        }
        return this.startUpload(params);
    }

    public boolean upload(File file, String uri, String date, String signature, Map<String, String> params) throws IOException, BmobException, ExecutionException, InterruptedException {
        this.signed = true;
        this.mFile = file;
        this.uri = uri;
        this.date = date;
        this.signature = signature;
        this.totalBlock = (int)Math.ceil((double)this.mFile.length() / 1048576.0 + 2.0);
        this.randomAccessFile = new RandomAccessFile(this.mFile, "r");
        this.url = HOST + uri;
        this.mClient = new OkHttpClient.Builder().connectTimeout((long)this.timeout, TimeUnit.SECONDS).readTimeout((long)this.timeout, TimeUnit.SECONDS).writeTimeout((long)this.timeout, TimeUnit.SECONDS).build();
        if (this.status == null || this.status.length != this.totalBlock - 2 || this.uuid == null) {
            this.status = new int[this.totalBlock - 2];
        }
        return this.startUpload(params);
    }

    public void upload(final File file, final String uploadPath, final Map<String, String> restParams, final Map<String, Object> processParam, final UpCompleteListener completeListener) throws BmobException {
        if (processParam == null) {
            this.upload(file, uploadPath, restParams, completeListener);
            return;
        }
        final UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (completeListener != null) {
                            completeListener.onComplete(isSuccess, result);
                        }
                    }
                });
            }
        };
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ParallelUploader.this.upload(file, uploadPath, restParams);
                    String date = ParallelUploader.this.getGMTDate();
                    String sign = ParallelUploader.this.sign("POST", date, "/pretreatment/", ParallelUploader.this.userName, ParallelUploader.this.password, null);
                    processParam.put("tasks", Base64Coder.encodeString(processParam.get("tasks").toString()));
                    FormBody.Builder builder = new FormBody.Builder();
                    for (Map.Entry mapping : processParam.entrySet()) {
                        builder.addEncoded((String)mapping.getKey(), mapping.getValue().toString());
                    }
                    String processURL = "http://p0.api.upyun.com/pretreatment/";
                    Request request = new Request.Builder().url(processURL).post((RequestBody)builder.build()).header("Date", date).header(ParallelUploader.AUTHORIZATION, sign).header("User-Agent", "upyun-android-sdk 2.0.6").build();
                    Response response = ParallelUploader.this.mClient.newCall(request).execute();
                    if (!response.isSuccessful()) {
                        uiCompleteListener.onComplete(false, response.body().string());
                    } else {
                        uiCompleteListener.onComplete(true, response.body().string());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (BmobException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
            }
        });
    }

    public void upload(final File file, final String uri, final String date, final String signature, final Map<String, String> restParams, final UpCompleteListener completeListener) {
        final UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                System.out.println("\u4e0a\u4f20\u6210\u529f\u540e\u8fd4\u56de\u5185\u5bb9\uff1a" + result);
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (completeListener != null) {
                            completeListener.onComplete(isSuccess, result);
                        }
                    }
                });
            }
        };
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ParallelUploader.this.upload(file, uri, date, signature, restParams);
                    uiCompleteListener.onComplete(true, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (BmobException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
            }
        });
    }

    public void upload(final File file, final String uploadPath, final Map<String, String> restParams, final UpCompleteListener completeListener) {
        final UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (completeListener != null) {
                            completeListener.onComplete(isSuccess, result);
                        }
                    }
                });
            }
        };
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ParallelUploader.this.upload(file, uploadPath, restParams);
                    uiCompleteListener.onComplete(true, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (BmobException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    uiCompleteListener.onComplete(false, e.toString());
                }
            }
        });
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public int[] getStatus() {
        return this.status;
    }

    public void setStatus(int[] status) {
        this.status = status;
    }

    public void setCheckMD5(boolean checkMD5) {
        this.checkMD5 = checkMD5;
    }

    public void setOnProgressListener(UpProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    private boolean startUpload(Map<String, String> params) throws IOException, BmobException, ExecutionException, InterruptedException {
        if (this.uuid != null) {
            return this.processUpload();
        }
        RequestBody requestBody = RequestBody.create(null, (String)"");
        String md5 = null;
        if (this.checkMD5) {
            md5 = UpYunUtils.md5("");
        }
        if (!this.signed) {
            this.date = this.getGMTDate();
            this.signature = this.sign("PUT", this.date, this.uri, this.userName, this.password, md5).trim();
        }
        Request.Builder builder = new Request.Builder().url(this.url).header("Date", this.date).header(AUTHORIZATION, this.signature).header(X_UPYUN_MULTI_DISORDER, "true").header(X_UPYUN_MULTI_STAGE, "initiate").header(X_UPYUN_MULTI_TYPE, this.getMimeType(this.mFile.getPath())).header(X_UPYUN_MULTI_LENGTH, this.mFile.length() + "").header("User-Agent", "upyun-android-sdk 2.0.6").put(requestBody);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
        }
        if (md5 != null) {
            builder.header(CONTENT_MD5, md5);
        }
        this.callRequest(builder.build(), 1);
        return this.processUpload();
    }

    private String getMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = fileNameMap.getContentTypeFor(path);
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        BLog.e("getMimeType\uff1a" + contentTypeFor);
        return contentTypeFor;
    }

    private boolean processUpload() throws IOException, BmobException, InterruptedException, ExecutionException {
        this.blockProgress = 0;
        ExecutorService uploadExecutor = Executors.newFixedThreadPool(this.paralle);
        for (int i = 0; i < this.totalBlock - 2; ++i) {
            Future<?> future = uploadExecutor.submit(this.uploadBlock(i));
            try {
                future.get();
                continue;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (ExecutionException e) {
                throw e;
            }
        }
        uploadExecutor.shutdown();
        try {
            uploadExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        return this.completeUpload();
    }

    private Runnable uploadBlock(final int index) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (ParallelUploader.this.status[index] == 1) {
                        if (ParallelUploader.this.onProgressListener != null) {
                            ParallelUploader.this.onProgressListener.onRequestProgress(ParallelUploader.this.blockProgress + 2, ParallelUploader.this.totalBlock);
                        }
                        ParallelUploader.this.blockProgress++;
                        return;
                    }
                    if (ParallelUploader.this.status[index] == 2) {
                        return;
                    }
                    ((ParallelUploader)ParallelUploader.this).status[index] = 2;
                    byte[] data = ParallelUploader.this.readBlockByIndex(index);
                    RequestBody requestBody = RequestBody.create(null, (byte[])data);
                    String md5 = null;
                    if (ParallelUploader.this.checkMD5) {
                        md5 = UpYunUtils.md5(data);
                    }
                    if (!ParallelUploader.this.signed) {
                        ParallelUploader.this.date = ParallelUploader.this.getGMTDate();
                        ParallelUploader.this.signature = ParallelUploader.this.sign("PUT", ParallelUploader.this.date, ParallelUploader.this.uri, ParallelUploader.this.userName, ParallelUploader.this.password, md5).trim();
                    }
                    Request.Builder builder = new Request.Builder().url(ParallelUploader.this.url).header("Date", ParallelUploader.this.date).header(ParallelUploader.AUTHORIZATION, ParallelUploader.this.signature).header(ParallelUploader.X_UPYUN_MULTI_STAGE, "upload").header(ParallelUploader.X_UPYUN_MULTI_UUID, ParallelUploader.this.uuid).header(ParallelUploader.X_UPYUN_PART_ID, index + "").header("User-Agent", "upyun-android-sdk 2.0.6").put(requestBody);
                    if (md5 != null) {
                        builder.header(ParallelUploader.CONTENT_MD5, md5);
                    }
                    ParallelUploader.this.uploadRequest(builder);
                    ((ParallelUploader)ParallelUploader.this).status[index] = 1;
                }
                catch (Exception e) {
                    ((ParallelUploader)ParallelUploader.this).status[index] = 3;
                    throw new RuntimeException(e.getMessage());
                }
            }
        };
    }

    private Response uploadRequest(Request.Builder builder) {
        try {
            Response response = this.mClient.newCall(builder.build()).execute();
            if (!response.isSuccessful()) {
                int x_error_code = Integer.parseInt(response.header("X-Error-Code", "-1"));
                if (x_error_code == 40011061 || x_error_code == 40011059) {
                    this.uuid = null;
                }
                throw new RuntimeException(response.body().string());
            }
            if (this.onProgressListener != null) {
                this.onProgressListener.onRequestProgress(this.blockProgress + 2, this.totalBlock);
            }
            ++this.blockProgress;
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private boolean completeUpload() throws IOException, BmobException {
        RequestBody requestBody = RequestBody.create(null, (String)"");
        String md5 = null;
        if (this.checkMD5) {
            md5 = UpYunUtils.md5("");
        }
        if (!this.signed) {
            this.date = this.getGMTDate();
            this.signature = this.sign("PUT", this.date, this.uri, this.userName, this.password, md5).trim();
        }
        Request.Builder builder = new Request.Builder().url(this.url).header("Date", this.date).header(AUTHORIZATION, this.signature).header(X_UPYUN_MULTI_STAGE, "complete").header(X_UPYUN_MULTI_UUID, this.uuid).header("User-Agent", "upyun-android-sdk 2.0.6").put(requestBody);
        if (md5 != null) {
            builder.header(CONTENT_MD5, md5);
        }
        this.callRequest(builder.build(), this.totalBlock);
        this.uuid = null;
        this.status = null;
        return true;
    }

    private void callRequest(Request request, int index) throws IOException, BmobException {
        System.out.println("\u4e0a\u4f20\u63a5\u53e3\uff1a" + request.toString());
        Response response = this.mClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new BmobException(response.code(), response.body().string());
        }
        if (this.onProgressListener != null) {
            this.onProgressListener.onRequestProgress(index, this.totalBlock);
        }
        this.uuid = response.header(X_UPYUN_MULTI_UUID, "");
    }

    private String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }

    private String sign(String method, String date, String path, String userName, String password, String md5) throws BmobException {
        StringBuilder sb = new StringBuilder();
        String sp = "&";
        sb.append(method);
        sb.append(sp);
        sb.append(path);
        sb.append(sp);
        sb.append(date);
        if (md5 != null) {
            sb.append(sp);
            sb.append(md5);
        }
        String raw = sb.toString().trim();
        byte[] hmac = null;
        try {
            hmac = UpYunUtils.calculateRFC2104HMACRaw(password, raw);
        }
        catch (Exception e) {
            throw new BmobException(9015, "\u8ba1\u7b97SHA1\u9519\u8bef.");
        }
        if (hmac != null) {
            return "UPYUN " + userName + ":" + Base64Coder.encodeLines(hmac);
        }
        return null;
    }

    private byte[] readBlockByIndex(int index) throws IOException {
        byte[] block = new byte[0x100000];
        int readedSize = 0;
        int offset = index * 0x100000;
        this.randomAccessFile.seek(offset);
        readedSize = this.randomAccessFile.read(block, 0, 0x100000);
        if (readedSize < 0x100000) {
            byte[] notFullBlock = new byte[readedSize];
            System.arraycopy(block, 0, notFullBlock, 0, readedSize);
            return notFullBlock;
        }
        return block;
    }

    public class Params {
        public static final String BUCKET_NAME = "bucket_name";
        public static final String NOTIFY_URL = "notify_url";
        public static final String SOURCE = "source";
        public static final String TASKS = "tasks";
        public static final String ACCEPT = "accept";
        public static final String STATUS_CODE = "status_code";
        public static final String PATH = "path";
        public static final String DESCRIPTION = "description";
        public static final String TASK_ID = "task_id";
        public static final String INFO = "info";
        public static final String SIGNATURE = "signature";
        public static final String TIMESTAMP = "timestamp";
        public static final String TASK_IDS = "task_ids";
        public static final String TYPE = "type";
        public static final String SAVE_AS = "save_as";
        public static final String RETURN_INFO = "return_info";
        public static final String AVOPTS = "avopts";
    }
}

