/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype.up;

import android.content.Context;
import android.os.PowerManager;
import cn.bmob.v3.datatype.BmobFile;
import cn.bmob.v3.datatype.up.BmobUploader;
import cn.bmob.v3.datatype.up.SignatureListener;
import cn.bmob.v3.datatype.up.UpCompleteListener;
import cn.bmob.v3.datatype.up.UpProgressListener;
import cn.bmob.v3.datatype.up.UpYunUtils;
import cn.bmob.v3.datatype.up.UploadManager;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.http.bean.Upyun;
import cn.bmob.v3.listener.UploadFileListener;
import cn.bmob.v3.util.BLog;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class UpYunUploader
extends BmobUploader {
    private PowerManager.WakeLock mWakeLock;
    private Upyun result;
    private Context context;
    private File file;

    public UpYunUploader(Context context, Upyun result, BmobFile bmobFile, UploadFileListener listener) {
        super(bmobFile, listener);
        this.result = result;
        this.context = context;
        this.file = bmobFile.getLocalFile();
    }

    @Override
    public void doUpload() {
        if (this.file.isDirectory()) {
            this.listener.doneError(9025, "Local file is a directory.");
            return;
        }
        PowerManager power = (PowerManager)this.context.getSystemService("power");
        this.mWakeLock = power.newWakeLock(1, this.getClass().getName());
        this.mWakeLock.acquire();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("bucket", this.result.getName());
        BLog.e("bucket:" + this.result.getName());
        StringBuilder sb = new StringBuilder();
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        int m = now.get(2) + 1;
        int d = now.get(5);
        String month = m < 10 ? "0" + m : String.valueOf(m);
        String day = d < 10 ? "0" + d : String.valueOf(d);
        String path = this.file.getPath();
        String fileName = this.file.getName();
        String suffix = fileName.contains(".") ? path.substring(path.lastIndexOf(".")) : "";
        String uuid = UUID.randomUUID().toString().replace("-", "");
        sb.append("/").append(year).append("/").append(month).append("/").append(day).append("/").append(uuid).append(suffix);
        paramsMap.put("save-key", sb.toString());
        BLog.e("save-key:" + sb.toString());
        UpProgressListener progressListener = new UpProgressListener(){

            @Override
            public void onRequestProgress(long bytesWrite, long contentLength) {
                int progress = (int)(100L * bytesWrite / contentLength);
                if (UpYunUploader.this.listener != null) {
                    UpYunUploader.this.listener.onProgress(progress);
                }
            }
        };
        UpCompleteListener completeListener = new UpCompleteListener(){

            @Override
            public void onComplete(boolean isSuccess, String content) {
                BLog.e(content);
                UpYunUploader.this.doComplement(isSuccess, content);
                if (UpYunUploader.this.mWakeLock != null) {
                    UpYunUploader.this.mWakeLock.release();
                }
                if (UpYunUploader.this.listener != null) {
                    UpYunUploader.this.listener.onFinish();
                }
            }
        };
        SignatureListener signatureListener = new SignatureListener(){

            @Override
            public String getSignature(String raw) {
                return UpYunUtils.md5(raw + UpYunUploader.this.result.getSecret());
            }
        };
        UploadManager.getInstance().parallelUpload(this.file, paramsMap, signatureListener, completeListener, progressListener);
    }

    private void doComplement(boolean isSuccess, String content) {
        block8: {
            if (isSuccess) {
                try {
                    String url;
                    try {
                        Map infoMap = (Map)new Gson().fromJson(content, new TypeToken<Map<String, String>>(){}.getType());
                        String path = (String)infoMap.get("url");
                        url = "http://" + this.result.getDomain() + path;
                    }
                    catch (Exception e) {
                        url = "http://" + this.result.getDomain() + content;
                    }
                    String filename = this.file.getName();
                    String group = "";
                    this.bmobFile.obtain(filename, group, url);
                    if (this.listener != null) {
                        this.listener.done(null);
                    }
                    break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.listener != null) {
                        this.listener.done(new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                    }
                    break block8;
                }
            }
            if (this.listener != null) {
                this.listener.done(new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
            }
        }
    }
}

