/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype.up;

import cn.bmob.v3.Bmob;
import cn.bmob.v3.datatype.up.PostData;
import cn.bmob.v3.datatype.up.ProgressHelper;
import cn.bmob.v3.datatype.up.UpConfig;
import cn.bmob.v3.datatype.up.UpProgressListener;
import cn.bmob.v3.exception.BmobException;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UploadClient {
    private OkHttpClient client;

    public UploadClient() {
        long timeout = Bmob.getConnectTimeout();
        this.client = new OkHttpClient.Builder().connectTimeout(timeout, TimeUnit.SECONDS).readTimeout((long)UpConfig.READ_TIMEOUT, TimeUnit.SECONDS).writeTimeout((long)UpConfig.WRITE_TIMEOUT, TimeUnit.SECONDS).followRedirects(true).build();
    }

    public String fromUpLoad(File file, String url, String policy, String signature, UpProgressListener listener) throws IOException, BmobException {
        Request request;
        Response response;
        Object requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", URLEncoder.encode(file.getName()), RequestBody.create(null, (File)file)).addFormDataPart("policy", policy).addFormDataPart("signature", signature).build();
        if (listener != null) {
            requestBody = ProgressHelper.addProgressListener((RequestBody)requestBody, listener);
        }
        if (!(response = this.client.newCall(request = new Request.Builder().addHeader("x-upyun-api-version", "2").url(url).post((RequestBody)requestBody).build()).execute()).isSuccessful()) {
            throw new BmobException(response.code(), response.body().string());
        }
        return response.body().string();
    }

    public String post(String url, Map<String, String> requestParams) throws IOException, BmobException {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        Request request = new Request.Builder().addHeader("x-upyun-api-version", "2").url(url).post((RequestBody)builder.build()).build();
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new BmobException(response.code(), response.body().string());
        }
        return response.body().string();
    }

    public String blockMultipartPost(String url, PostData postData) throws IOException, BmobException {
        Map<String, String> requestParams = postData.params;
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            builder.addFormDataPart(entry.getKey(), entry.getValue());
        }
        builder.addFormDataPart("file", URLEncoder.encode(postData.fileName), RequestBody.create(null, (byte[])postData.data));
        Request request = new Request.Builder().addHeader("x-upyun-api-version", "2").url(url).post((RequestBody)builder.build()).build();
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new BmobException(response.code(), response.body().string());
        }
        return response.body().string();
    }

    public Response download(String url) throws IOException, BmobException {
        Request request = new Request.Builder().url(url).build();
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new BmobException(response.code(), response.body().string());
        }
        return response;
    }
}

