/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.datatype.up;

import cn.bmob.v3.Bmob;
import cn.bmob.v3.datatype.up.AsyncRun;
import cn.bmob.v3.datatype.up.BlockUploader;
import cn.bmob.v3.datatype.up.FormUploader;
import cn.bmob.v3.datatype.up.ParallelUploader;
import cn.bmob.v3.datatype.up.SignatureListener;
import cn.bmob.v3.datatype.up.UpCompleteListener;
import cn.bmob.v3.datatype.up.UpConfig;
import cn.bmob.v3.datatype.up.UpProgressListener;
import cn.bmob.v3.datatype.up.UpYunUtils;
import cn.bmob.v3.datatype.up.UploadClient;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.http.RequestUtils;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.Base64Coder;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class UploadManager {
    private static volatile UploadManager instance;
    private ExecutorService executor = Executors.newFixedThreadPool(UpConfig.CONCURRENCY);
    private UploadClient upLoaderClient = new UploadClient();
    public static final int UPLOAD_TYPE_BLOCK = 0;
    public static final int UPLOAD_TYPE_FORM = 1;
    public static final int UPLOAD_TYPE_PARALLEL = 2;

    private UploadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UploadManager getInstance() {
        if (instance != null) return instance;
        Class<UploadManager> clazz = UploadManager.class;
        synchronized (UploadManager.class) {
            if (instance != null) return instance;
            instance = new UploadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void upload(File file, Map<String, Object> params, String apiKey, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(file, params, apiKey, null, completeListener, progressListener);
    }

    protected void upload(File file, Map<String, Object> params, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(file, params, null, signatureListener, completeListener, progressListener);
    }

    public void formUpload(File file, Map<String, Object> params, String apiKey, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(1, file, params, apiKey, null, completeListener, progressListener);
    }

    public void formUpload(File file, Map<String, Object> params, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(1, file, params, null, signatureListener, completeListener, progressListener);
    }

    public void blockUpload(File file, Map<String, Object> params, String apiKey, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(0, file, params, apiKey, null, completeListener, progressListener);
    }

    public void blockUpload(File file, Map<String, Object> params, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(0, file, params, null, signatureListener, completeListener, progressListener);
    }

    public void parallelUpload(File file, Map<String, Object> params, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        this.upload(2, file, params, null, signatureListener, completeListener, progressListener);
    }

    protected void upload(File file, Map<String, Object> params, String apiKey, SignatureListener signatureListener, UpCompleteListener completeListener, UpProgressListener progressListener) {
        if (file.length() < UpConfig.FILE_BOUND) {
            this.upload(1, file, params, apiKey, signatureListener, completeListener, progressListener);
        } else {
            this.upload(0, file, params, apiKey, signatureListener, completeListener, progressListener);
        }
    }

    protected void upload(int type, File file, Map<String, Object> params, String apiKey, SignatureListener signatureListener, final UpCompleteListener completeListener, final UpProgressListener progressListener) {
        if (file == null) {
            completeListener.onComplete(false, "\u6587\u4ef6\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            return;
        }
        if (params == null) {
            completeListener.onComplete(false, "\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            return;
        }
        if (apiKey == null && signatureListener == null) {
            completeListener.onComplete(false, "APIkey\u548csignatureListener\u4e0d\u53ef\u540c\u65f6\u4e3anull");
            return;
        }
        if (completeListener == null) {
            throw new RuntimeException("completeListener \u4e0d\u53ef\u4e3anull");
        }
        if (params.get("bucket") == null) {
            params.put("bucket", UpConfig.BUCKET);
        }
        if (params.get("expiration") == null) {
            long expiration = Bmob.getFileExpiration();
            params.put("expiration", RequestUtils.getTimeStamp() + expiration);
        }
        UpProgressListener uiProgressListener = new UpProgressListener(){

            @Override
            public void onRequestProgress(final long bytesWrite, final long contentLength) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        if (progressListener != null) {
                            progressListener.onRequestProgress(bytesWrite, contentLength);
                        }
                    }
                });
            }
        };
        UpCompleteListener uiCompleteListener = new UpCompleteListener(){

            @Override
            public void onComplete(final boolean isSuccess, final String result) {
                AsyncRun.run(new Runnable(){

                    @Override
                    public void run() {
                        completeListener.onComplete(isSuccess, result);
                    }
                });
            }
        };
        HashMap<String, Object> localParams = new HashMap<String, Object>();
        localParams.putAll(params);
        Runnable uploadRunnable = null;
        switch (type) {
            case 1: {
                uploadRunnable = new FormUploader(this.upLoaderClient, file, localParams, apiKey, signatureListener, uiCompleteListener, uiProgressListener);
                this.executor.execute(uploadRunnable);
                break;
            }
            case 0: {
                uploadRunnable = new BlockUploader(this.upLoaderClient, file, localParams, apiKey, signatureListener, uiCompleteListener, uiProgressListener);
                this.executor.execute(uploadRunnable);
                break;
            }
            case 2: {
                this.parallelUpload(file, localParams, uiCompleteListener, uiProgressListener);
                break;
            }
        }
    }

    public void parallelUpload(File file, Map<String, Object> localParams, final UpCompleteListener uiCompleteListener, final UpProgressListener uiProgressListener) {
        ParallelUploader parallelUploader = new ParallelUploader();
        String UPYUN_SPACE = (String)localParams.remove("bucket");
        BLog.e("\u7a7a\u95f4\u540d:" + UPYUN_SPACE);
        String save_path = (String)localParams.remove("save-key");
        BLog.e("\u4fdd\u5b58\u8def\u5f84:" + save_path);
        String path = (String)localParams.get("path");
        if (save_path != null && path == null) {
            localParams.put("path", save_path);
        }
        path = (String)localParams.get("path");
        BLog.e("\u8def\u5f84:" + path);
        String uri = "/" + UPYUN_SPACE + save_path;
        BLog.e("uri\uff1a" + uri);
        String date = this.getGMTDate();
        BLog.e("date\uff1a" + date);
        String sign = null;
        try {
            sign = this.sign("PUT", date, uri, "bmob", "a5a15e08f251d517524383ba61f489d3", null);
        }
        catch (BmobException e) {
            e.printStackTrace();
        }
        BLog.e("sign\uff1a" + sign);
        parallelUploader.setOnProgressListener(new UpProgressListener(){

            @Override
            public void onRequestProgress(long bytesWrite, long contentLength) {
                uiProgressListener.onRequestProgress(bytesWrite, contentLength);
            }
        });
        final String finalPath = path;
        parallelUploader.upload(file, uri, date, sign, null, new UpCompleteListener(){

            @Override
            public void onComplete(boolean isSuccess, String result) {
                if (isSuccess) {
                    uiCompleteListener.onComplete(isSuccess, finalPath);
                } else {
                    uiCompleteListener.onComplete(isSuccess, result);
                }
                BLog.e("onComplete", "isSuccess:" + isSuccess + "  result:" + result);
            }
        });
    }

    private String sign(String method, String date, String path, String userName, String password, String md5) throws BmobException {
        StringBuilder sb = new StringBuilder();
        String sp = "&";
        sb.append(method);
        sb.append(sp);
        sb.append(path);
        sb.append(sp);
        sb.append(date);
        if (md5 != null) {
            sb.append(sp);
            sb.append(md5);
        }
        String raw = sb.toString().trim();
        byte[] hmac = null;
        try {
            hmac = UpYunUtils.calculateRFC2104HMACRaw(password, raw);
        }
        catch (Exception e) {
            throw new BmobException(9016, "calculate SHA1 wrong.");
        }
        if (hmac != null) {
            return "UPYUN " + userName + ":" + Base64Coder.encodeLines(hmac).replace("\n", "").replace("\r", "").replace("\t", "");
        }
        return null;
    }

    private String getGMTDate() {
        SimpleDateFormat formater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        formater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formater.format(new Date());
    }
}

