/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http;

import android.content.Context;
import android.os.Build;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.BmobObject;
import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.datatype.up.UpConfig;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.BmobNative;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.helper.RequestHelper;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RequestUtils;
import cn.bmob.v3.http.bean.Api;
import cn.bmob.v3.http.bean.Collect;
import cn.bmob.v3.http.bean.Init;
import cn.bmob.v3.http.bean.Result;
import cn.bmob.v3.http.bean.Sk;
import cn.bmob.v3.http.interceptor.GzipRequestInterceptor;
import cn.bmob.v3.http.interceptor.HttpLoggingInterceptor;
import cn.bmob.v3.http.interceptor.ResponseInterceptor;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.EncryptUtils;
import cn.bmob.v3.util.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class BmobClient<T> {
    public static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private static boolean isNewDomain = false;
    private static boolean hasInit = false;
    public static int curCDNVersion = 0;
    private static String CREATE = "create";
    private static String UPDATE = "update";
    private static String FIND = "find";
    private static volatile BmobClient mClient;
    private static byte[] lock;
    private OkHttpClient client;
    private static ObservableTransformer schedulersTransformer;

    public static void setHasInit(boolean hasInit) {
        BmobClient.hasInit = hasInit;
    }

    public static boolean isIsNewDomain() {
        return isNewDomain;
    }

    public static void setIsNewDomain(boolean isNewDomain) {
        BmobClient.isNewDomain = isNewDomain;
    }

    public static boolean hasInit() {
        return hasInit;
    }

    private BmobClient() {
        long timeout = Bmob.getConnectTimeout();
        this.client = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(timeout, TimeUnit.SECONDS).readTimeout((long)UpConfig.READ_TIMEOUT, TimeUnit.SECONDS).writeTimeout((long)UpConfig.WRITE_TIMEOUT, TimeUnit.SECONDS).addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.NONE)).addInterceptor((Interceptor)new GzipRequestInterceptor()).addNetworkInterceptor((Interceptor)new ResponseInterceptor()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BmobClient getInstance() {
        if (mClient != null) return mClient;
        byte[] byArray = lock;
        synchronized (lock) {
            if (mClient != null) return mClient;
            mClient = new BmobClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mClient;
        }
    }

    private synchronized Observable<Sk> getSk() {
        return this.createObservable(Sk.class, BmobURL.getDefault().getSecretUrl(), null);
    }

    private synchronized Observable<Init> init() {
        return this.createObservable(Init.class, BmobURL.getDefault().getInitUrl(), null);
    }

    private Observable<Long> getTime() {
        return BmobFactory.getInstance().createTimeRequest(null).getObservable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Observable<JsonElement> request(final String url, final JSONObject params) {
        BLog.e(url);
        byte[] byArray = lock;
        synchronized (lock) {
            boolean hasKey = BmobNative.hasKey();
            if (hasKey && hasInit) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.createObservable(url, params).compose(BmobClient.applySchedulers());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.getSk().concatMap((Function)new Function<Sk, Observable<Init>>(){

                public Observable<Init> apply(Sk sk) {
                    BmobNative.SECRET_KEY = sk.getSecretKey();
                    BmobNative.saveKey(sk.getSecretKey());
                    return BmobClient.this.init();
                }
            }).concatMap((Function)new Function<Init, Observable<JsonElement>>(){

                public Observable<JsonElement> apply(Init init) {
                    hasInit = true;
                    BmobClient.this.saveInit(init);
                    return BmobClient.this.createObservable(url, params);
                }
            }).compose(BmobClient.applySchedulers());
        }
    }

    public void syncInitSDK() {
        Sk sk = (Sk)this.getSk().blockingFirst();
        BmobNative.SECRET_KEY = sk.getSecretKey();
        BmobNative.saveKey(sk.getSecretKey());
        Init init = (Init)this.init().blockingFirst();
        hasInit = true;
        this.saveInit(init);
    }

    private static void initCollect(Context context) {
        JSONObject collectJson = new JSONObject();
        String collectUrl = BmobURL.getDefault().getCollectUrl();
        JSONObject collectDataJson = new JSONObject();
        try {
            collectJson.put("c", (Object)"collect");
            collectJson.put("data", (Object)collectDataJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        BmobClient.getInstance().request(collectUrl, collectJson).subscribe((Observer)new Observer<JsonElement>(){

            public void onSubscribe(Disposable d) {
            }

            public void onComplete() {
                BLog.i("onComplete()");
            }

            public void onError(Throwable e) {
                BLog.e(e.toString());
            }

            public void onNext(JsonElement element) {
                BLog.i(element.toString());
                JsonObject collectJson = element.getAsJsonObject();
                Gson gson = new Gson();
                Collect collect = (Collect)gson.fromJson((JsonElement)collectJson, Collect.class);
                if (collect.getIsOpen() == 1) {
                    BLog.e("collect", collect.getIsOpen() + "-" + collect.getId());
                }
            }
        });
    }

    private static ObservableTransformer createSchedulers() {
        ObservableTransformer observableTransformer = new ObservableTransformer(){

            public ObservableSource apply(Observable upstream) {
                return upstream.subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.computation()).observeOn(AndroidSchedulers.mainThread());
            }
        };
        return observableTransformer;
    }

    public static <T> ObservableTransformer<T, T> applySchedulers() {
        return schedulersTransformer;
    }

    private void saveInit(Init init) {
        BmobContentProvider.updateInit(init);
        BmobURL.getDefault().setUrls(init);
        curCDNVersion = init.getUpyunVer();
        BmobContentProvider.updateUpyun("", curCDNVersion);
        long localTime = System.currentTimeMillis() / 1000L;
        int interval = (int)(localTime - init.getTimestamp());
        BmobNative.saveInterval(String.valueOf(interval));
    }

    public String saveSync(JSONObject params) throws BmobException {
        return this.sync(BmobURL.getDefault().getUrl(CREATE), params, CREATE).getObjectId();
    }

    public String updateSync(JSONObject params) throws BmobException {
        return this.sync(BmobURL.getDefault().getUrl(UPDATE), params, UPDATE).getUpdatedAt();
    }

    public List<T> findObjectsSync(Class<T> clazz, JSONObject params, BmobQuery.CachePolicy cachePolicy) throws BmobException {
        return this.syncFind(clazz, BmobURL.getDefault().getUrl("find"), params);
    }

    private List<T> syncFind(Class<T> clazz, String url, JSONObject params) throws BmobException {
        JsonElement element = this.doReq(url, params);
        try {
            String data = element.getAsJsonObject().getAsJsonArray("results").toString();
            return this.string2List(clazz, data);
        }
        catch (Exception e) {
            throw new BmobException(9002, "string to list error");
        }
    }

    public List<T> string2List(Class<T> clazz, String data) {
        Gson gson = new GsonBuilder().create();
        ArrayList<Object> list = new ArrayList<Object>();
        List old = (List)gson.fromJson(data, List.class);
        if (old != null) {
            for (int i = 0; i < old.size(); ++i) {
                String json = gson.toJson(old.get(i));
                Object t = gson.fromJson(json, clazz);
                list.add(t);
            }
        }
        return list;
    }

    private BmobObject sync(String url, JSONObject params, String option) throws BmobException {
        BmobObject object = null;
        JsonElement element = this.doReq(url, params);
        object = new BmobObject();
        if ("create".equals(option)) {
            String objectId = JsonUtil.getString(element, "objectId");
            object.setObjectId(objectId);
        } else if ("update".equals(option)) {
            String updatedAt = JsonUtil.getString(element, "updatedAt");
            object.setUpdatedAt(updatedAt);
        }
        return object;
    }

    private JsonElement doReq(String url, JSONObject params) throws BmobException {
        JsonElement element;
        block4: {
            Request request = BmobClient.createRequest(url, params);
            element = null;
            try {
                Response response = this.client.newCall(request).execute();
                int code = response.code();
                String content = response.body().string();
                if (200 != code) break block4;
                Api data = (Api)GsonUtil.toObject(content, Api.class);
                Result result = data.getResult();
                if (result != null) {
                    int resultCode = result.getCode();
                    if (200 != resultCode) {
                        throw new BmobException(resultCode, result.getMessage());
                    }
                    element = data.getData();
                    break block4;
                }
                throw new BmobException(9002, "data result is null");
            }
            catch (IOException e) {
                throw new BmobException(9002, e.getMessage());
            }
        }
        return element;
    }

    private Observable<JsonElement> createObservable(final String url, final JSONObject params) {
        Observable jsonElementObservable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<JsonElement>(){

            public void subscribe(ObservableEmitter<JsonElement> emitter) throws Exception {
                block11: {
                    if (emitter.isDisposed()) {
                        BLog.e("bmob", "createObservable:subscriber is cancel");
                        return;
                    }
                    try {
                        BLog.e(url);
                        Request newRequest = BmobClient.createRequest(url, params);
                        Response response = BmobClient.this.client.newCall(newRequest).execute();
                        int code = response.code();
                        String content = response.body().string();
                        if (200 == code) {
                            if (url.equals(BmobURL.getDefault().getUrl("delcdnbatch"))) {
                                JsonParser jsonParser = new JsonParser();
                                JsonElement element = jsonParser.parse(content);
                                emitter.onNext((Object)element);
                                emitter.onComplete();
                                break block11;
                            }
                            Api data = (Api)GsonUtil.toObject(content, Api.class);
                            Result result = data.getResult();
                            if (result != null) {
                                int resultCode = result.getCode();
                                if (200 != resultCode) {
                                    boolean dis = emitter.isDisposed();
                                    try {
                                        emitter.onError((Throwable)new BmobException(resultCode, result.getMessage()));
                                    }
                                    catch (Exception e) {
                                        System.out.println(e.toString());
                                    }
                                    System.out.println(dis);
                                    break block11;
                                }
                                emitter.onNext((Object)data.getData());
                                break block11;
                            }
                            emitter.onError((Throwable)new BmobException(9002, content));
                            break block11;
                        }
                        try {
                            emitter.onError((Throwable)new BmobException(code, content));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        BLog.e(code + "\n" + content);
                    }
                    catch (Exception e) {
                        emitter.onError((Throwable)new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                    }
                }
            }
        });
        return jsonElementObservable;
    }

    private <T> Observable<T> createObservable(final Class<T> cls, final String url, final JSONObject params) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(ObservableEmitter<T> emitter) throws Exception {
                if (emitter.isDisposed()) {
                    BLog.e("bmob", "createObservable:subcriber is cancel");
                    return;
                }
                Request newRequest = BmobClient.createRequest(url, params);
                try {
                    Response response = BmobClient.this.client.newCall(newRequest).execute();
                    int code = response.code();
                    String content = response.body().string();
                    if (200 == code) {
                        Api data = (Api)GsonUtil.toObject(content, Api.class);
                        if (data == null) {
                            emitter.onError((Throwable)new BmobException(9002, "\u89e3\u6790Api\u51fa\u9519\uff0c\u8bf7\u4e0d\u8981\u6df7\u6dc6bmobsdk\uff01\u6216\u8005\u662f\u7f51\u7edc\u88ab\u52ab\u6301\uff0c\u8bf7\u5207\u6362\u7f51\u7edc\u91cd\u65b0\u5c1d\u8bd5\uff01" + content));
                            BLog.e("\u89e3\u6790Api\u51fa\u9519,\u8bf7\u4e0d\u8981\u6df7\u6dc6bmobsdk.");
                        } else {
                            Result result = data.getResult();
                            if (result != null) {
                                int resultCode = result.getCode();
                                if (200 == resultCode) {
                                    emitter.onNext(new Gson().fromJson(data.getData().toString(), cls));
                                } else {
                                    emitter.onError((Throwable)new BmobException(resultCode, result.getMessage()));
                                }
                            } else {
                                emitter.onError((Throwable)new BmobException(9002, "\u89e3\u6790Api\u5e76\u83b7\u53d6\u7ed3\u679c\u51fa\u9519,\u8bf7\u4e0d\u8981\u6df7\u6dc6bmobsdk."));
                                BLog.e("\u89e3\u6790Api\u5e76\u83b7\u53d6\u7ed3\u679c\u51fa\u9519,\u8bf7\u4e0d\u8981\u6df7\u6dc6bmobsdk.");
                            }
                        }
                    } else if (!content.equals("")) {
                        Api data = (Api)GsonUtil.toObject(content, Api.class);
                        if (data != null) {
                            Result result = data.getResult();
                            emitter.onError((Throwable)new BmobException(result.getCode(), result.getMessage()));
                        } else {
                            emitter.onError((Throwable)new BmobException(code, content));
                        }
                    } else {
                        emitter.onError((Throwable)new BmobException(code, content));
                    }
                }
                catch (Exception e) {
                    emitter.onError((Throwable)new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                }
            }
        });
    }

    public static Request createRequest(String url, JSONObject params) {
        String agent = RequestHelper.getUserAgent(Bmob.getApplicationContext());
        params = BmobClient.createParams(Bmob.getApplicationContext(), params == null ? new JSONObject() : params, url);
        BLog.e("params:" + (params == null ? "" : params.toString()));
        String encryData = null;
        encryData = url.equals(BmobURL.getDefault().getSecretUrl()) ? EncryptUtils.encryptAgent(agent, params.toString()) : EncryptUtils.encrypt(BmobNative.SECRET_KEY, BmobNative.SECRET_KEY, params.toString());
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE, (String)encryData);
        Request.Builder newBuilder = new Request.Builder().header("Content-Type", "text/plain; charset=utf-8").header("Accept-Encoding", "gzip,deflate,sdch").header("User-Agent", agent).url(url).post(body);
        if (!url.equals(BmobURL.getDefault().getSecretUrl())) {
            newBuilder.addHeader("Accept-Id", RequestUtils.getAcceptId());
        }
        Request newRequest = newBuilder.build();
        return newRequest;
    }

    public static JSONObject createParams(Context context, JSONObject params, String url) {
        try {
            if (url.equals(BmobURL.getDefault().getSecretUrl())) {
                params.put("appKey", (Object)RequestUtils.getAppKey());
                BLog.e("appKey" + RequestUtils.getAppKey());
            }
            String sessionToken = BmobContentProvider.getSessionToken();
            BLog.e("sessionToken:" + sessionToken);
            params.put("sessionToken", (Object)sessionToken);
            params.put("appSign", (Object)RequestUtils.getAppSign(context));
            JSONObject client = new JSONObject();
            client.put("caller", (Object)"Android");
            JSONObject ex = new JSONObject();
            ex.put("version", (Object)Build.VERSION.RELEASE);
            ex.put("package", (Object)context.getPackageName());
            ex.put("uuid", (Object)RequestUtils.getCombinedDeviceID(context));
            client.put("ex", (Object)ex);
            params.put("client", (Object)client);
            params.put("v", (Object)"v4.0.1");
            if (!url.equals(BmobURL.getDefault().getSecretUrl()) && !url.equals(BmobURL.getDefault().getInitUrl())) {
                long time = RequestUtils.getTimeStamp();
                params.put("timestamp", time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static JSONObject generateCacheKey(Context context, JSONObject params) {
        JSONObject obj = params;
        try {
            obj.put("sessionToken", (Object)BmobContentProvider.getSessionToken());
            obj.put("appSign", (Object)RequestUtils.getAppSign(context));
            JSONObject client = new JSONObject();
            client.put("caller", (Object)"Android");
            JSONObject ex = new JSONObject();
            ex.put("version", (Object)Build.VERSION.RELEASE);
            ex.put("package", (Object)context.getPackageName());
            ex.put("uuid", (Object)RequestUtils.getCombinedDeviceID(context));
            client.put("ex", (Object)ex);
            obj.put("client", (Object)client);
            obj.put("v", (Object)"v4.0.1");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    static {
        lock = new byte[0];
        schedulersTransformer = BmobClient.createSchedulers();
    }
}

