/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http;

import android.text.TextUtils;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.datatype.BmobTableSchema;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.http.bean.R1;
import cn.bmob.v3.http.bean.Upyun;
import cn.bmob.v3.http.rx.RetryWithDelay;
import cn.bmob.v3.listener.BmobCallback;
import cn.bmob.v3.listener.DeleteBatchListener;
import cn.bmob.v3.listener.LogInListener;
import cn.bmob.v3.listener.QueryListListener;
import cn.bmob.v3.listener.QueryListener;
import cn.bmob.v3.listener.UpdateListener;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BmobFactory {
    private static volatile BmobFactory mClient;
    private static byte[] lock;

    private BmobFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BmobFactory getInstance() {
        if (mClient != null) return mClient;
        byte[] byArray = lock;
        synchronized (lock) {
            if (mClient != null) return mClient;
            mClient = new BmobFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mClient;
        }
    }

    public static void rEmptyListener(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(" listener must not be null ");
        }
    }

    public static R1 rContext() {
        return new R1(Bmob.getApplicationContext() == null, new BmobException(9012, "context is null(9012)."));
    }

    public static R1 rEmpty(String s, String error) {
        return new R1(TextUtils.isEmpty((CharSequence)s), new BmobException(9018, error));
    }

    public static R1 rEmpty(String s, int code, String error) {
        return new R1(TextUtils.isEmpty((CharSequence)s), new BmobException(code, error));
    }

    public static R1 rNull(Object o, int code, String error) {
        return new R1(o == null, new BmobException(code, error));
    }

    public static R1 rNull(Object o, String error) {
        boolean isOk = false;
        if (o instanceof String) {
            if (TextUtils.isEmpty((CharSequence)((String)o))) {
                isOk = true;
            }
        } else {
            isOk = o == null;
        }
        return new R1(isOk, new BmobException(9018, error));
    }

    public static List<R1> rByNull(Object o, String error) {
        return Arrays.asList(BmobFactory.rContext(), BmobFactory.rNull(o, error));
    }

    public static List<R1> rByNull(Object o1, String error1, Object o2, String error2) {
        return Arrays.asList(BmobFactory.rNull(o1, error1), BmobFactory.rNull(o2, error2));
    }

    public static List<R1> rByNull(Object o1, String error1, Object o2, String error2, Object o3, String error3) {
        return Arrays.asList(BmobFactory.rNull(o1, error1), BmobFactory.rNull(o2, error2), BmobFactory.rNull(o3, error3));
    }

    public static List<R1> rByContext(String s, String error) {
        return Arrays.asList(BmobFactory.rContext(), BmobFactory.rEmpty(s, error));
    }

    public static List<R1> rByEmpty(String s1, String error1, String s2, String error2) {
        return Arrays.asList(BmobFactory.rEmpty(s1, error1), BmobFactory.rEmpty(s2, error2));
    }

    public static List<R1> rBySave(String tableName) {
        R1 r = new R1(tableName.equals("_User"), new BmobException(9011, "BmobUser does not support save operation,please used signUp method(9011)."));
        R1 r1 = new R1(!Utils.checkTableName(tableName, 1, 49) && !tableName.equals("_Role") && tableName.equals("_Installation") && tableName.equals("_Article"), new BmobException(9013, "BmobObject Object name(database table name) format is not correct(9013)."));
        return Arrays.asList(r, r1);
    }

    public static List<R1> rByBatch(JSONArray requests) {
        R1 r1 = new R1(requests.length() == 0, new BmobException(9005, "A batch operation can not be less than 0"));
        R1 r2 = new R1(requests.length() > 50, new BmobException(9005, "A batch operation can not be more than 50"));
        return Arrays.asList(r1, r2);
    }

    public static List<R1> rByDeleteCDNBatch(String[] urls) {
        R1 r1 = new R1(urls.length == 0, new BmobException(9005, "urls length can not be less than 0"));
        return Arrays.asList(BmobFactory.rNull(urls, "urls must not be null"), r1);
    }

    public RxBmob createBQLStatisticRequest(String url, JSONObject params, BmobCallback listener) {
        return new RxBmob.Builder().check(Collections.emptyList()).nextTest(url, params).mapStatistics().subscribe(listener).build();
    }

    public RxBmob createCheckRequest(List<R1> list, String url, JSONObject params, BmobCallback listener) {
        return new RxBmob.Builder().check(list).nextTest(url, params).mapVoid().subscribe(listener).build();
    }

    public RxBmob createCountRequest(List<R1> list, String url, JSONObject params, BmobCallback listener) {
        return new RxBmob.Builder().check(list).nextTest(url, params).mapCount().subscribe(listener).build();
    }

    public RxBmob createStatisticsRequest(List<R1> list, String url, JSONObject params, BmobCallback listener) {
        return new RxBmob.Builder().check(list).nextTest(url, params).mapStatistics().subscribe(listener).build();
    }

    public <T> RxBmob createLoginRequest(final Class<T> clazz, List<R1> list, String url, JSONObject params, LogInListener<T> listener) {
        return new RxBmob.Builder().check(list).nextTest(url, params).doOnNext(new Consumer<JsonElement>(){

            public void accept(JsonElement jsonElement) {
                BLog.e(jsonElement.toString());
                BmobContentProvider.updateUser(jsonElement.toString(), clazz);
                JsonElement session = jsonElement.getAsJsonObject().get("sessionToken");
                if (session != null) {
                    String sessionToken = session.getAsString();
                    BmobContentProvider.updateSessionToken(sessionToken);
                }
            }
        }).mapT(clazz).subscribe(listener).build();
    }

    public RxBmob createTimeRequest(QueryListener<Long> listener) {
        return new RxBmob.Builder().check(Collections.emptyList()).nextTest(BmobURL.getDefault().getUrl("timestamp"), new JSONObject()).map(new Function<JsonElement, Long>(){

            public Long apply(JsonElement data) {
                return data.getAsJsonObject().get("S").getAsLong();
            }
        }).subscribe(listener).build();
    }

    public RxBmob createAllTableSchemaRequest(JSONObject params, QueryListListener<BmobTableSchema> listener) {
        return new RxBmob.Builder().check(Collections.emptyList()).nextTest(BmobURL.getDefault().getUrl("schemas"), params).map(new Function<JsonElement, List<BmobTableSchema>>(){

            public List<BmobTableSchema> apply(JsonElement data) {
                try {
                    ArrayList<BmobTableSchema> schemas = new ArrayList<BmobTableSchema>();
                    JsonArray ary = data.getAsJsonObject().getAsJsonArray("results");
                    JSONArray json = new JSONArray(ary.toString());
                    if (json != null && json.length() > 0) {
                        for (int i = 0; i < json.length(); ++i) {
                            JSONObject obj = json.getJSONObject(i);
                            String className = obj.getString("className");
                            JSONObject fields = obj.getJSONObject("fields");
                            BmobTableSchema schema = new BmobTableSchema(className, Utils.parse2Map(fields));
                            schemas.add(schema);
                        }
                    }
                    return schemas;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).subscribe(listener).build();
    }

    public RxBmob createTableSchemaRequest(JSONObject params, QueryListener<BmobTableSchema> listener) {
        return new RxBmob.Builder().check(Collections.emptyList()).nextTest(BmobURL.getDefault().getUrl("schemas"), params).map(new Function<JsonElement, BmobTableSchema>(){

            public BmobTableSchema apply(JsonElement data) {
                try {
                    JsonObject obj = data.getAsJsonObject();
                    JSONObject json = new JSONObject(obj.toString());
                    String className = json.getString("className");
                    JSONObject fields = json.getJSONObject("fields");
                    BmobTableSchema schema = new BmobTableSchema(className, Utils.parse2Map(fields));
                    return schema;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).subscribe(listener).build();
    }

    public Observable<Upyun> createCDNObservable() {
        return this.createCDNRequest().getObservable();
    }

    public RxBmob createCDNRequest() {
        return new RxBmob.Builder().direct(BmobURL.getDefault().getUrl("cdn"), null).mapCDN().doOnNext(new Consumer<Upyun>(){

            public void accept(final Upyun result) {
                Schedulers.io().createWorker().schedule(new Runnable(){

                    @Override
                    public void run() {
                        String json = GsonUtil.toJson(result);
                        BmobContentProvider.updateUpyun(json, BmobClient.curCDNVersion);
                    }
                });
            }
        }).build();
    }

    private RxBmob createSaveCDNRequest(String url, String filename, long filesize, UpdateListener listener) {
        JSONObject params = new JSONObject();
        JSONObject data = new JSONObject();
        try {
            data.put("url", (Object)url);
            data.put("filename", (Object)filename);
            data.put("filesize", filesize);
            data.put("cdn", (Object)"upyun");
            params.put("data", (Object)data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().direct(BmobURL.getDefault().getUrl("savecdnupload"), params).mapSaveCDN().retryWhen(new RetryWithDelay(2, 1000)).subscribe(listener).build();
    }

    private Disposable saveCDNDisposable(String url, String filename, long filesize, UpdateListener listener) {
        return this.createSaveCDNRequest(url, filename, filesize, listener).getDisposable();
    }

    public Observable saveCDN(final String url, final String filename, final long filesize) {
        return new RxBmob.Builder().create((ObservableOnSubscribe)new ObservableOnSubscribe<BmobException>(){

            public void subscribe(final ObservableEmitter<BmobException> emitter) {
                BmobFactory.this.saveCDNDisposable(url, filename, filesize, new UpdateListener(){

                    @Override
                    public void done(BmobException e) {
                        if (e == null) {
                            BLog.i("saveCDN success");
                            BmobException bmobException = new BmobException();
                            emitter.onNext((Object)bmobException);
                        } else {
                            BLog.e(e.getMessage());
                            emitter.onNext((Object)e);
                        }
                        emitter.onComplete();
                    }
                });
            }
        }).build().getObservable();
    }

    public RxBmob createDeleteCDNRequest(List<R1> list, String url, UpdateListener listener) {
        JSONObject params = new JSONObject();
        JSONObject data = new JSONObject();
        try {
            data.put("filename", (Object)Utils.convertUrl(url));
            data.put("cdn", (Object)"upyun");
            params.put("data", (Object)data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(list).nextTest(BmobURL.getDefault().getUrl("delcdnupload"), params).mapDeleteCDN().subscribe(listener).build();
    }

    public RxBmob createDeleteBatchCDNRequest(String[] urls, DeleteBatchListener listener) {
        JSONObject params = new JSONObject();
        JSONObject data = new JSONObject();
        try {
            JSONArray upyun = new JSONArray();
            int size = urls.length;
            for (int i = 0; i < size; ++i) {
                String url = urls[i];
                upyun.put((Object)Utils.convertUrl(url));
            }
            data.put("upyun", (Object)upyun);
            params.put("data", (Object)data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return new RxBmob.Builder().check(BmobFactory.rByDeleteCDNBatch(urls)).nextTest(BmobURL.getDefault().getUrl("delcdnbatch"), params).mapCDNDeleteBatch().subscribe(listener).build();
    }

    public static CheckInfo checkNull(String objectId) {
        boolean isOk = objectId != null && !"".equals(objectId);
        return new CheckInfo(isOk, "objectId is can not be null");
    }

    static {
        lock = new byte[0];
    }

    public static class CheckInfo {
        Object object;
        String objName;
        boolean isOk;

        public CheckInfo() {
        }

        public CheckInfo(Object object, String objName) {
            this.object = object;
            this.objName = objName;
        }

        public void work() {
            String template = "{0} is must not be null";
            String errorDetails = template.replace("{0}", this.objName);
            if (this.object == null) {
                this.isOk = false;
                throw new IllegalArgumentException(errorDetails);
            }
            this.isOk = true;
        }
    }
}

