/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http;

import android.content.Context;
import android.os.AsyncTask;
import android.os.PowerManager;
import cn.bmob.v3.datatype.up.UploadClient;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.listener.DownloadFileListener;
import cn.bmob.v3.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;

public class BmobFileDownloader
extends AsyncTask<Void, Long, BmobException> {
    private PowerManager.WakeLock mWakeLock;
    private UploadClient okHttpClient;
    private DownloadFileListener callback;
    private String url;
    private File savePath;
    private Context context;

    public BmobFileDownloader(Context context, String url, File savePath, DownloadFileListener callback) {
        this.context = context;
        this.okHttpClient = new UploadClient();
        this.url = url;
        this.callback = callback;
        this.savePath = savePath;
        Utils.mkdirs(savePath.getParentFile());
        if (savePath.exists()) {
            savePath.delete();
        }
    }

    protected void onPreExecute() {
        super.onPreExecute();
        PowerManager pm = (PowerManager)this.context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, ((Object)((Object)this)).getClass().getName());
        this.mWakeLock.acquire();
        if (this.callback != null) {
            this.callback.internalStart();
        }
    }

    protected BmobException doInBackground(Void ... params) {
        BmobException ex = null;
        try {
            Response response = this.okHttpClient.download(this.url);
            long total = response.body().contentLength();
            this.saveFile(response);
            if (total == this.savePath.length()) {
                ex = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ex = new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957");
        }
        catch (BmobException e1) {
            e1.printStackTrace();
            ex = e1;
        }
        return ex;
    }

    protected void onProgressUpdate(Long ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.callback != null && values != null && values.length >= 2) {
            long sum = values[0];
            long total = values[1];
            int progress = (int)((float)sum * 100.0f / (float)total);
            this.callback.onProgress(progress, total);
        }
    }

    protected void onPostExecute(BmobException e) {
        super.onPostExecute((Object)e);
        this.mWakeLock.release();
        if (e == null) {
            if (this.callback != null) {
                this.callback.done(this.savePath.getAbsolutePath(), (BmobException)null);
            }
        } else if (this.callback != null) {
            this.callback.done(null, new BmobException(e.getErrorCode(), e.getMessage()));
        }
        if (this.callback != null) {
            this.callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveFile(Response response) throws IOException {
        InputStream is = null;
        byte[] buf = new byte[1024];
        int len = 0;
        FileOutputStream fos = null;
        try {
            is = response.body().byteStream();
            long total = response.body().contentLength();
            long sum = 0L;
            Utils.mkdirs(this.savePath.getParentFile());
            fos = new FileOutputStream(this.savePath);
            while ((len = is.read(buf)) != -1) {
                sum += (long)len;
                fos.write(buf, 0, len);
                if (this.callback == null) continue;
                this.publishProgress(new Long[]{sum, total});
            }
            fos.flush();
            String string = this.savePath.getAbsolutePath();
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

