/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http;

import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.RequestUtils;
import cn.bmob.v3.http.bean.Init;
import cn.bmob.v3.http.bean.Migration;
import cn.bmob.v3.util.BLog;

public class BmobURL {
    private static volatile BmobURL instance;
    private static byte[] lock;
    private String defaultBaseUrl;
    private static String standbyBaseUrl;
    private String baseUrl;
    public static final String BASE_URL_TEST = "https://opentest.bmob.cn/8/";
    public static final String BASE_URL_INNER = "http://p.bmob.cn/8/";
    public final String RESPONSE_ID = "Response-Id";
    private String secretUrl;
    private String initUrl;
    private String createUrl;
    private String UPDATE_URL;
    private String DELETE_URL;
    private String FIND_URL;
    private String collectUrl;
    private String signupUrl;
    private String loginUrl;
    private String loginOrSignupUrl;
    private String resetUrl;
    private String resetPasswordByCodeUrl;
    private String updateUserPwd;
    private String emailVerifyUrl;
    private String timestampUrl;
    private String batchUrl;
    private String PUSH_URL;
    private String fileUrl;
    private String uploadUrl;
    private String uploadMkfileUrl;
    private String uploadBputUrl;
    private String delFileUrl;
    private String thumbnailUrl;
    private String functionUrl;
    private String realTimeDataUrl;
    private String sqlqueryUrl;
    private String requestSMSUrl;
    private String requestSMSCodeUrl;
    private String verifySMSCodeUrl;
    private String querySMSUrl;
    private String deviceUrl;
    private String phoneCiUrl;
    private String getSchemas;
    private Migration mMigration;

    public static String getStandbyBaseUrl() {
        return standbyBaseUrl;
    }

    private BmobURL() {
        this.baseUrl = this.defaultBaseUrl = "https://open.cctvcloud.cn/8/";
        this.RESPONSE_ID = "Response-Id";
        this.secretUrl = this.defaultBaseUrl + "secret";
        this.initUrl = this.defaultBaseUrl + "init";
        this.createUrl = this.defaultBaseUrl + "create";
        this.UPDATE_URL = this.defaultBaseUrl + "update";
        this.DELETE_URL = this.defaultBaseUrl + "delete";
        this.FIND_URL = this.defaultBaseUrl + "find";
        this.collectUrl = this.defaultBaseUrl + "collect";
        this.signupUrl = this.defaultBaseUrl + "signup";
        this.loginUrl = this.defaultBaseUrl + "login";
        this.loginOrSignupUrl = this.defaultBaseUrl + "login_or_signup";
        this.resetUrl = this.defaultBaseUrl + "reset";
        this.resetPasswordByCodeUrl = this.defaultBaseUrl + "phone_reset";
        this.updateUserPwd = this.defaultBaseUrl + "update_user_password";
        this.emailVerifyUrl = this.defaultBaseUrl + "email_verify";
        this.timestampUrl = this.defaultBaseUrl + "timestamp";
        this.batchUrl = this.defaultBaseUrl + "batch";
        this.PUSH_URL = this.defaultBaseUrl + "push";
        this.fileUrl = "http://file.bmob.cn";
        this.uploadUrl = this.defaultBaseUrl + "files";
        this.uploadMkfileUrl = this.defaultBaseUrl + "mkfile";
        this.uploadBputUrl = this.defaultBaseUrl + "bput";
        this.delFileUrl = this.defaultBaseUrl + "delfile";
        this.thumbnailUrl = this.defaultBaseUrl + "thumbnail";
        this.functionUrl = this.defaultBaseUrl + "functions";
        this.realTimeDataUrl = "";
        this.sqlqueryUrl = this.defaultBaseUrl + "cloud_query";
        this.requestSMSUrl = this.defaultBaseUrl + "request_sms";
        this.requestSMSCodeUrl = this.defaultBaseUrl + "request_sms_code";
        this.verifySMSCodeUrl = this.defaultBaseUrl + "verify_sms_code";
        this.querySMSUrl = this.defaultBaseUrl + "query_sms";
        this.deviceUrl = this.defaultBaseUrl + "device";
        this.phoneCiUrl = this.defaultBaseUrl + "phone_ci";
        this.getSchemas = this.defaultBaseUrl + "schemas";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BmobURL getDefault() {
        if (instance != null) return instance;
        byte[] byArray = lock;
        synchronized (lock) {
            if (instance != null) return instance;
            instance = new BmobURL();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setUrls(Init init) {
        if (BmobClient.isIsNewDomain()) {
            BLog.e(this.defaultBaseUrl);
            BLog.e(this.fileUrl);
            BLog.e(this.realTimeDataUrl);
        } else {
            this.fileUrl = init.getFile();
            this.realTimeDataUrl = init.getIo();
        }
    }

    public String getUrl(String urlOption, Migration migration) {
        String id = "?id=" + RequestUtils.getId();
        if (null == migration) {
            return this.getUrl(urlOption);
        }
        this.mMigration = migration;
        return this.mMigration.getUrlByOption(urlOption) + id;
    }

    public String getUrl(String option) {
        String id = "?id=" + RequestUtils.getId();
        if (!BmobClient.hasInit()) {
            return this.defaultBaseUrl + option + id;
        }
        if (this.mMigration == null) {
            return this.defaultBaseUrl + option + id;
        }
        return this.mMigration.getUrlByOption(option) + id;
    }

    public String getDefaultBaseUrl() {
        return this.defaultBaseUrl;
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.setDefaultBaseUrl(defaultBaseUrl, null);
    }

    public void setDefaultBaseUrl(String defaultBaseUrl, String ioUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
        this.baseUrl = defaultBaseUrl;
        this.realTimeDataUrl = ioUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getSecretUrl() {
        return this.getDefaultBaseUrl() + "secret";
    }

    public String getInitUrl() {
        return this.getDefaultBaseUrl() + "init";
    }

    public String getCollectUrl() {
        return this.getDefaultBaseUrl() + "collect";
    }

    public String getCreateUrl() {
        return this.getDefaultBaseUrl() + "create";
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public String getPhoneCiUrl() {
        return this.getDefaultBaseUrl() + "phone_ci";
    }

    public String getUpdateUserPwd() {
        return this.getDefaultBaseUrl() + "update_user_password";
    }

    public String getRealTimeDataUrl() {
        return this.realTimeDataUrl;
    }

    static {
        lock = new byte[0];
        standbyBaseUrl = "https://open.cctvcloud.cn/8/";
    }
}

