/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http;

import android.text.TextUtils;
import cn.bmob.v3.BmobArticle;
import cn.bmob.v3.BmobInstallation;
import cn.bmob.v3.BmobObject;
import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.BmobRole;
import cn.bmob.v3.BmobUser;
import cn.bmob.v3.datatype.BmobDate;
import cn.bmob.v3.datatype.BmobGeoPoint;
import cn.bmob.v3.datatype.BmobPointer;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryConditions {
    public static final int QUERY_TYPE_TABLE = 1;
    public static final int QUERY_TYPE_V3 = 2;
    public static final int QUERY_TYPE_COUNT = 3;
    public static final int QUERY_TYPE_STATISTICS = 4;
    public static final int QUERY_TYPE_BQL = 5;
    private int queryType;
    private JSONObject params = new JSONObject();
    private JSONObject data = new JSONObject();
    private Class<?> clazz;
    private JSONObject where = new JSONObject();
    private String keys;
    private Integer limit;
    private Integer skip;
    private String order;
    private String include;
    private String objectId;
    private String groupby;
    private String sum;
    private String average;
    private String max;
    private String min;
    private boolean hasGroupCount = false;
    private JSONObject having = new JSONObject();
    private String bql;
    private Object[] values = null;

    public int getQueryType() {
        return this.queryType;
    }

    public void setQueryType(int type) {
        this.queryType = type;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public JSONObject getWhere() {
        return this.where;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public JSONObject getParams() {
        return this.params;
    }

    public void setParams(JSONObject params) {
        this.params = params;
    }

    public void addWhereLessThan(String key, Object value) {
        this.addCondition(key, "$lt", value);
    }

    public void addWhereLessThanOrEqualTo(String key, Object value) {
        this.addCondition(key, "$lte", value);
    }

    public void addWhereGreaterThan(String key, Object value) {
        this.addCondition(key, "$gt", value);
    }

    public void addWhereGreaterThanOrEqualTo(String key, Object value) {
        this.addCondition(key, "$gte", value);
    }

    public void addWhereEqualTo(String key, Object value) {
        if (value instanceof BmobPointer) {
            try {
                JSONObject obj = new JSONObject(GsonUtil.toJson(value));
                this.addCondition(key, null, obj);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.addCondition(key, null, value);
        }
    }

    public void addWhereNotEqualTo(String key, Object value) {
        this.addCondition(key, "$ne", value);
    }

    public void addWhereContainsAll(String key, Collection<?> values) {
        JSONArray array = new JSONArray();
        for (Object object : values) {
            array.put(object);
        }
        this.addCondition(key, "$all", array);
    }

    public void addWhereContainedIn(String key, Collection<? extends Object> values) {
        JSONArray array = new JSONArray();
        for (Object object : values) {
            array.put(object);
        }
        this.addCondition(key, "$in", array);
    }

    public void addWhereNotContainedIn(String key, Collection<? extends Object> values) {
        JSONArray array = new JSONArray();
        for (Object object : values) {
            array.put(object);
        }
        this.addCondition(key, "$nin", array);
    }

    public void addWhereMatches(String key, String regex) {
        this.addCondition(key, "$regex", regex);
    }

    public void addWhereNear(String key, BmobGeoPoint point) {
        this.addCondition(key, "$nearSphere", point);
    }

    public void addWhereWithinMiles(String key, BmobGeoPoint point, double maxDistance) {
        this.addGeoPoint(key, "$maxDistanceInMiles", point, maxDistance);
    }

    public void addWhereWithinKilometers(String key, BmobGeoPoint point, double maxDistance) {
        this.addGeoPoint(key, "$maxDistanceInKilometers", point, maxDistance);
    }

    public void addWhereWithinRadians(String key, BmobGeoPoint point, double maxDistance) {
        this.addGeoPoint(key, "$maxDistanceInKilometers", point, maxDistance);
    }

    private void addGeoPoint(String key, String condition, BmobGeoPoint point, double maxDistance) {
        this.addCondition(key, "$nearSphere", point);
        this.addCondition(key, condition, maxDistance);
    }

    public void addWhereWithinGeoBox(String key, BmobGeoPoint southwest, BmobGeoPoint northeast) {
        ArrayList<BmobGeoPoint> array = new ArrayList<BmobGeoPoint>();
        array.add(southwest);
        array.add(northeast);
        this.addCondition(key, "$within", array);
    }

    public void addWhereExists(String key) {
        this.addCondition(key, "$exists", true);
    }

    public void addWhereDoesNotExists(String key) {
        this.addCondition(key, "$exists", false);
    }

    public void addWhereRelatedTo(String key, BmobPointer pointer) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("key", (Object)key);
            obj.put("object", (Object)new JSONObject(GsonUtil.toJson(pointer)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.addCondition("$relatedTo", null, obj);
    }

    public <E> void addWhereMatchesQuery(String key, String className, BmobQuery<E> innerQuery) {
        try {
            JSONObject obj = new JSONObject();
            obj.put("where", (Object)innerQuery.getWhere());
            obj.put("className", (Object)className);
            this.addCondition(key, "$inQuery", obj);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public <E> void addWhereDoesNotMatchQuery(String key, String className, BmobQuery<E> innerQuery) {
        try {
            JSONObject obj = new JSONObject();
            obj.put("where", (Object)innerQuery.getWhere());
            obj.put("className", (Object)className);
            this.addCondition(key, "$notInQuery", obj);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addQueryKeys(String keys) {
        this.keys = keys;
    }

    public <T> void or(List<BmobQuery<T>> where2) {
        JSONArray ja = new JSONArray();
        for (BmobQuery<T> bmobQuery : where2) {
            ja.put((Object)bmobQuery.getWhere());
        }
        this.addCondition("$or", null, ja);
    }

    public <T> void and(List<BmobQuery<T>> where) {
        JSONArray ja = new JSONArray();
        for (BmobQuery<T> bmobQuery : where) {
            ja.put((Object)bmobQuery.getWhere());
        }
        this.addCondition("$and", null, ja);
    }

    public void addCondition(String key, String condition, Object value) {
        try {
            if (TextUtils.isEmpty((CharSequence)condition)) {
                if (value instanceof BmobUser) {
                    BmobUser bo = (BmobUser)value;
                    JSONObject obj = new JSONObject();
                    obj.put("__type", (Object)"Pointer");
                    obj.put("objectId", (Object)bo.getObjectId());
                    obj.put("className", (Object)"_User");
                    this.where.put(key, (Object)obj);
                } else if (value instanceof BmobInstallation) {
                    BmobInstallation bo = (BmobInstallation)value;
                    JSONObject obj = new JSONObject();
                    obj.put("__type", (Object)"Pointer");
                    obj.put("objectId", (Object)bo.getObjectId());
                    obj.put("className", (Object)"_Installation");
                    this.where.put(key, (Object)obj);
                } else if (value instanceof BmobObject) {
                    BmobObject bo = (BmobObject)value;
                    JSONObject obj = new JSONObject();
                    obj.put("__type", (Object)"Pointer");
                    obj.put("objectId", (Object)bo.getObjectId());
                    obj.put("className", (Object)bo.getClass().getSimpleName());
                    this.where.put(key, (Object)obj);
                } else if (value instanceof BmobGeoPoint) {
                    value = new JSONObject(GsonUtil.toJson(value));
                    this.where.put(key, value);
                } else if (value instanceof BmobDate) {
                    value = new JSONObject(GsonUtil.toJson(value));
                    this.where.put(key, value);
                } else if (value instanceof ArrayList) {
                    ArrayList list = (ArrayList)value;
                    JSONArray arr = new JSONArray();
                    JSONObject geoPoint = new JSONObject();
                    geoPoint.put("__type", (Object)"GeoPoint");
                    geoPoint.put("longitude", ((BmobGeoPoint)list.get(0)).getLongitude());
                    geoPoint.put("latitude", ((BmobGeoPoint)list.get(0)).getLatitude());
                    JSONObject geoPoint1 = new JSONObject();
                    geoPoint1.put("__type", (Object)"GeoPoint");
                    geoPoint1.put("longitude", ((BmobGeoPoint)list.get(1)).getLongitude());
                    geoPoint1.put("latitude", ((BmobGeoPoint)list.get(1)).getLatitude());
                    arr.put((Object)geoPoint);
                    arr.put((Object)geoPoint1);
                    JSONObject obj = new JSONObject();
                    obj.put("$box", (Object)arr);
                    value = obj;
                    this.where.put(key, value);
                } else {
                    this.where.put(key, value);
                }
            } else {
                Object existingValue;
                JSONObject obj;
                BmobObject bo;
                if (value instanceof BmobGeoPoint) {
                    value = new JSONObject(GsonUtil.toJson(value));
                } else if (value instanceof BmobUser) {
                    bo = (BmobUser)value;
                    obj = new JSONObject();
                    obj.put("__type", (Object)"Pointer");
                    obj.put("objectId", (Object)bo.getObjectId());
                    obj.put("className", (Object)"_User");
                    value = obj;
                } else if (value instanceof BmobInstallation) {
                    bo = (BmobInstallation)value;
                    obj = new JSONObject();
                    obj.put("__type", (Object)"Pointer");
                    obj.put("objectId", (Object)bo.getObjectId());
                    obj.put("className", (Object)"_Installation");
                    value = obj;
                } else if (value instanceof BmobObject) {
                    bo = (BmobObject)value;
                    obj = new JSONObject();
                    obj.put("__type", (Object)"Pointer");
                    obj.put("objectId", (Object)bo.getObjectId());
                    obj.put("className", (Object)bo.getClass().getSimpleName());
                    value = obj;
                } else if (value instanceof BmobDate) {
                    value = new JSONObject(GsonUtil.toJson(value));
                } else if (value instanceof ArrayList) {
                    ArrayList list = (ArrayList)value;
                    JSONArray arr = new JSONArray();
                    JSONObject geoPoint = new JSONObject();
                    geoPoint.put("__type", (Object)"GeoPoint");
                    geoPoint.put("longitude", ((BmobGeoPoint)list.get(0)).getLongitude());
                    geoPoint.put("latitude", ((BmobGeoPoint)list.get(0)).getLatitude());
                    JSONObject geoPoint1 = new JSONObject();
                    geoPoint1.put("__type", (Object)"GeoPoint");
                    geoPoint1.put("longitude", ((BmobGeoPoint)list.get(1)).getLongitude());
                    geoPoint1.put("latitude", ((BmobGeoPoint)list.get(1)).getLatitude());
                    arr.put((Object)geoPoint);
                    arr.put((Object)geoPoint1);
                    JSONObject obj2 = new JSONObject();
                    obj2.put("$box", (Object)arr);
                    value = obj2;
                }
                JSONObject where = null;
                if (this.where.has(key) && (existingValue = this.where.get(key)) instanceof JSONObject) {
                    where = (JSONObject)existingValue;
                }
                if (where == null) {
                    where = new JSONObject();
                }
                where.put(condition, value);
                this.where.put(key, (Object)where);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getSum() {
        return this.sum;
    }

    public String getAverage() {
        return this.average;
    }

    public String getMax() {
        return this.max;
    }

    public String getMin() {
        return this.min;
    }

    public JSONObject getHaving() {
        return this.having;
    }

    public boolean isHasGroupCount() {
        return this.hasGroupCount;
    }

    public void setHasGroupCount(boolean hasCount) {
        this.hasGroupCount = hasCount;
    }

    public void groupby(String[] groupKeys) {
        this.groupby = Utils.parseArray2String(groupKeys);
    }

    public void sum(String[] sumKeys) {
        this.sum = Utils.parseArray2String(sumKeys);
    }

    public void average(String[] averageKeys) {
        this.average = Utils.parseArray2String(averageKeys);
    }

    public void max(String[] maxKeys) {
        this.max = Utils.parseArray2String(maxKeys);
    }

    public void min(String[] minKeys) {
        this.min = Utils.parseArray2String(minKeys);
    }

    public void having(HashMap<String, Object> map) {
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                try {
                    this.having.put(key, val);
                }
                catch (JSONException jSONException) {}
            }
        }
    }

    public void setBql(String bql) {
        this.bql = bql;
    }

    public String getBql() {
        return this.bql;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public JSONObject assembleParams() {
        try {
            if (this.getQueryType() == 1 || this.getQueryType() == 2) {
                if (this.getObjectId() != null) {
                    this.params.put("objectId", (Object)this.getObjectId());
                } else if (this.where.length() > 0) {
                    this.data.put("where", (Object)this.where);
                }
                if (!TextUtils.isEmpty((CharSequence)this.keys)) {
                    this.data.put("keys", (Object)this.keys);
                }
                this.data.put("limit", (Object)this.limit);
                this.data.put("skip", (Object)this.skip);
                if (!TextUtils.isEmpty((CharSequence)this.order)) {
                    this.data.put("order", (Object)this.order);
                }
                if (!TextUtils.isEmpty((CharSequence)this.include)) {
                    this.data.put("include", (Object)this.include);
                }
            } else if (this.getQueryType() == 3) {
                if (this.where.length() != 0) {
                    this.data.put("where", (Object)this.where);
                }
                this.data.put("limit", 0);
                this.data.put("count", true);
            } else if (this.getQueryType() == 4) {
                if (this.where.length() != 0) {
                    this.data.put("where", (Object)this.where);
                }
                this.data.put("keys", (Object)this.keys);
                this.data.put("skip", (Object)this.skip);
                this.data.put("limit", (Object)this.limit);
                this.data.put("order", (Object)this.order);
                if (!TextUtils.isEmpty((CharSequence)this.include)) {
                    this.data.put("include", (Object)this.include);
                }
                this.data.put("sum", (Object)this.sum);
                this.data.put("max", (Object)this.max);
                this.data.put("min", (Object)this.min);
                this.data.put("average", (Object)this.average);
                this.data.put("groupby", (Object)this.groupby);
                if (this.having.length() != 0) {
                    this.data.put("having", (Object)this.having);
                }
                if (this.hasGroupCount) {
                    this.data.put("groupcount", true);
                }
            } else if (this.getQueryType() == 5) {
                if (!TextUtils.isEmpty((CharSequence)this.bql)) {
                    this.data.put("bql", (Object)this.bql);
                }
                if (this.values != null && this.values.length > 0) {
                    JSONArray ary = new JSONArray();
                    for (Object o : this.values) {
                        ary.put(o);
                    }
                    this.data.put("values", (Object)ary);
                }
            } else {
                if (this.getObjectId() != null) {
                    this.params.put("objectId", (Object)this.getObjectId());
                } else if (this.where.length() > 0) {
                    this.data.put("where", (Object)this.where);
                }
                if (!TextUtils.isEmpty((CharSequence)this.keys)) {
                    this.data.put("keys", (Object)this.keys);
                }
                this.data.put("limit", (Object)this.limit);
                this.data.put("skip", (Object)this.skip);
                if (!TextUtils.isEmpty((CharSequence)this.order)) {
                    this.data.put("order", (Object)this.order);
                }
                if (!TextUtils.isEmpty((CharSequence)this.include)) {
                    this.data.put("include", (Object)this.include);
                }
                if (!TextUtils.isEmpty((CharSequence)this.bql)) {
                    this.data.put("bql", (Object)this.bql);
                }
                if (this.values != null && this.values.length > 0) {
                    JSONArray ary = new JSONArray();
                    for (Object o : this.values) {
                        ary.put(o);
                    }
                    this.data.put("values", (Object)ary);
                }
            }
            if (this.clazz != null) {
                if (BmobUser.class.isAssignableFrom(this.clazz)) {
                    this.params.put("c", (Object)"_User");
                } else if (BmobInstallation.class.isAssignableFrom(this.clazz)) {
                    this.params.put("c", (Object)"_Installation");
                } else if (BmobRole.class.isAssignableFrom(this.clazz)) {
                    this.params.put("c", (Object)"_Role");
                } else if (BmobArticle.class.isAssignableFrom(this.clazz)) {
                    this.params.put("c", (Object)"_Article");
                } else {
                    this.params.put("c", (Object)this.clazz.getSimpleName());
                }
            }
            this.params.put("data", (Object)this.data);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.params;
    }
}

