/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import cn.bmob.v3.helper.BmobNative;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.EncryptMD5;
import java.security.MessageDigest;
import java.util.Locale;

public class RequestUtils {
    public static String getAcceptId() {
        return BmobNative.getAcceptId();
    }

    public static String encrySecretDataWithKey1(String agent, String source) {
        return BmobNative.encrypt(agent, source);
    }

    public static String decrySecretDataWithKey2(String responseId, String data) {
        return BmobNative.decrypt(responseId, data);
    }

    public static String encryDataWithSecretKey(String requestBody) {
        return BmobNative.encryptByKey(requestBody);
    }

    public static String decryDataWithSecretKey(String data) {
        return BmobNative.decryptByKey(data);
    }

    public static String getAppKey() {
        return BmobNative.getAppId();
    }

    public static String getId() {
        String appid = BmobNative.getAppId();
        String id = appid.substring(appid.length() - 6);
        return id;
    }

    public static long getTimeStamp() {
        int interval = Integer.parseInt(BmobNative.getInterval());
        long localTime = System.currentTimeMillis() / 1000L;
        long newTime = localTime - (long)interval;
        return newTime;
    }

    public static String getAppSign(Context context) {
        String appSign = RequestUtils.isDebuggable(context) ? RequestUtils.getSignature(context) + "/" + 0 : RequestUtils.getSignature(context) + "/" + 1;
        BLog.e("appSign:" + RequestUtils.getSignature(context));
        return appSign;
    }

    private static String getSignature(Context context) {
        String signature = "";
        try {
            Signature[] sigs = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)64).signatures;
            byte[] line = sigs[0].toByteArray();
            signature = EncryptMD5.hexdigest(line);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return signature;
    }

    private static boolean isDebuggable(Context ctx) {
        try {
            ApplicationInfo info = ctx.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getInstallationId(Context context) {
        String fakeUid;
        String m_szLongID = fakeUid = RequestUtils.getFakeUniqueID();
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(m_szLongID.getBytes(), 0, m_szLongID.length());
            byte[] p_md5Data = m.digest();
            String m_szUniqueID = new String();
            for (int i = 0; i < p_md5Data.length; ++i) {
                int b = 0xFF & p_md5Data[i];
                if (b <= 15) {
                    m_szUniqueID = m_szUniqueID + "0";
                }
                m_szUniqueID = m_szUniqueID + Integer.toHexString(b);
            }
            m_szUniqueID = m_szUniqueID.toUpperCase(Locale.CHINA);
            return m_szUniqueID;
        }
        catch (Exception e) {
            e.printStackTrace();
            return m_szLongID.toUpperCase(Locale.CHINA);
        }
    }

    public static String getCombinedDeviceID(Context context) {
        String fakeUid;
        String m_szLongID = fakeUid = RequestUtils.getFakeUniqueID();
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(m_szLongID.getBytes(), 0, m_szLongID.length());
            byte[] p_md5Data = m.digest();
            String m_szUniqueID = new String();
            for (int i = 0; i < p_md5Data.length; ++i) {
                int b = 0xFF & p_md5Data[i];
                if (b <= 15) {
                    m_szUniqueID = m_szUniqueID + "0";
                }
                m_szUniqueID = m_szUniqueID + Integer.toHexString(b);
            }
            m_szUniqueID = m_szUniqueID.toUpperCase(Locale.CHINA);
            return m_szUniqueID;
        }
        catch (Exception e) {
            e.printStackTrace();
            return m_szLongID.toLowerCase(Locale.CHINA);
        }
    }

    private static String getFakeUniqueID() {
        return "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
    }
}

