/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http;

import android.text.TextUtils;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.BmobUser;
import cn.bmob.v3.datatype.BatchResult;
import cn.bmob.v3.datatype.BmobReturn;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.RequestUtils;
import cn.bmob.v3.http.bean.Api;
import cn.bmob.v3.http.bean.CDN;
import cn.bmob.v3.http.bean.R1;
import cn.bmob.v3.http.bean.Result;
import cn.bmob.v3.http.bean.Upyun;
import cn.bmob.v3.listener.BmobCallback;
import cn.bmob.v3.listener.BmobCallback1;
import cn.bmob.v3.listener.BmobCallback2;
import cn.bmob.v3.listener.DeleteBatchListener;
import cn.bmob.v3.listener.FindListener;
import cn.bmob.v3.listener.QueryListener;
import cn.bmob.v3.listener.SQLQueryListener;
import cn.bmob.v3.listener.UploadFileListener;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.ManifestUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function3;
import io.reactivex.rxjava3.functions.Function4;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RxBmob {
    final Observable observable;
    final Disposable mDisposable;

    public RxBmob() {
        this(new Builder());
    }

    public RxBmob(Builder builder) {
        this.observable = builder.observable.compose(BmobClient.applySchedulers());
        this.mDisposable = builder.mDisposable;
    }

    public Observable getObservable() {
        return this.observable.hide();
    }

    public Disposable getDisposable() {
        return this.mDisposable;
    }

    private static String getStackMsg(Exception e) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        return sb.toString();
    }

    private static String getStackMsg(Throwable e) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        return sb.toString();
    }

    public static final class Builder {
        Observable observable = Observable.empty();
        Disposable mDisposable = this.observable.subscribe();

        public Builder check(boolean checkNetwork, final List<R1> list) {
            if (list == null) {
                throw new IllegalArgumentException("R1 list is null ");
            }
            Observable oR1 = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(ObservableEmitter<String> emitter) {
                    int count = 0;
                    for (R1 r1 : list) {
                        if (!r1.getR().booleanValue()) continue;
                        emitter.onError((Throwable)r1.getE());
                        ++count;
                        break;
                    }
                    if (count == 0) {
                        emitter.onNext((Object)"");
                    }
                }
            });
            Observable oContext = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                    if (Bmob.getApplicationContext() == null) {
                        emitter.onError((Throwable)new BmobException(9012, "context is null(9012)."));
                    } else {
                        emitter.onNext((Object)"");
                    }
                }
            });
            Observable oAppKey = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                    String appkey = RequestUtils.getAppKey();
                    if (TextUtils.isEmpty((CharSequence)appkey)) {
                        emitter.onError((Throwable)new BmobException(9001, "AppKey is Null, Please initialize BmobSDK(9001)."));
                    } else {
                        emitter.onNext((Object)"");
                    }
                }
            });
            Observable oNetwork = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(ObservableEmitter<String> emitter) {
                    if (emitter.isDisposed()) {
                        return;
                    }
                    if (!ManifestUtils.detectNetWork(Bmob.getApplicationContext())) {
                        emitter.onError((Throwable)new BmobException(9016, "The network is not available,please check your network!(9016)"));
                    } else {
                        emitter.onNext((Object)"");
                    }
                }
            });
            this.observable = checkNetwork ? Observable.combineLatest((ObservableSource)oContext, (ObservableSource)oAppKey, (ObservableSource)oNetwork, (ObservableSource)oR1, (Function4)new Function4<String, String, String, String, Boolean>(){

                public Boolean apply(String context, String appKey, String network, String r1) {
                    return TextUtils.isEmpty((CharSequence)context) && TextUtils.isEmpty((CharSequence)appKey) && TextUtils.isEmpty((CharSequence)network) && TextUtils.isEmpty((CharSequence)r1);
                }
            }) : Observable.combineLatest((ObservableSource)oContext, (ObservableSource)oAppKey, (ObservableSource)oR1, (Function3)new Function3<String, String, String, Boolean>(){

                public Boolean apply(String context, String appKey, String r1) {
                    return TextUtils.isEmpty((CharSequence)context) && TextUtils.isEmpty((CharSequence)appKey) && TextUtils.isEmpty((CharSequence)r1);
                }
            });
            Consumer<Boolean> onNext = new Consumer<Boolean>(){

                public void accept(Boolean result) {
                    BLog.e("check result:" + result);
                }
            };
            Consumer<Throwable> onError = new Consumer<Throwable>(){

                public void accept(Throwable e) {
                    BLog.e(e.getMessage());
                }
            };
            Action onComplete = new Action(){

                public void run() {
                    BLog.e("complete");
                }
            };
            DisposableContainer disposableContainer = new DisposableContainer(){

                public boolean add(Disposable d) {
                    return false;
                }

                public boolean remove(Disposable d) {
                    return false;
                }

                public boolean delete(Disposable d) {
                    return false;
                }
            };
            this.mDisposable = this.observable.subscribe((Consumer)onNext, (Consumer)onError, onComplete, disposableContainer);
            return this;
        }

        public Builder checkTest(boolean checkNetwork, final List<R1> list, final BmobCallback listener) {
            if (list == null) {
                throw new IllegalArgumentException("R1 list is null ");
            }
            Observable oR1 = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(ObservableEmitter<String> emitter) {
                    int count = 0;
                    for (R1 r1 : list) {
                        if (!r1.getR().booleanValue()) continue;
                        emitter.onError((Throwable)r1.getE());
                        ++count;
                        break;
                    }
                    if (count == 0) {
                        emitter.onNext((Object)"");
                    }
                }
            });
            Observable oContext = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                    if (Bmob.getApplicationContext() == null) {
                        emitter.onError((Throwable)new BmobException(9012, "context is null(9012)."));
                    } else {
                        emitter.onNext((Object)"");
                    }
                }
            });
            Observable oAppKey = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                    String appkey = RequestUtils.getAppKey();
                    if (TextUtils.isEmpty((CharSequence)appkey)) {
                        emitter.onError((Throwable)new BmobException(9001, "AppKey is Null, Please initialize BmobSDK(9001)."));
                    } else {
                        emitter.onNext((Object)"");
                    }
                }
            });
            Observable oNetwork = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

                public void subscribe(ObservableEmitter<String> emitter) {
                    if (emitter.isDisposed()) {
                        return;
                    }
                    if (!ManifestUtils.detectNetWork(Bmob.getApplicationContext())) {
                        emitter.onError((Throwable)new BmobException(9016, "The network is not available,please check your network!(9016)"));
                    } else {
                        emitter.onNext((Object)"");
                    }
                }
            });
            this.observable = checkNetwork ? Observable.combineLatest((ObservableSource)oContext, (ObservableSource)oAppKey, (ObservableSource)oNetwork, (ObservableSource)oR1, (Function4)new Function4<String, String, String, String, Boolean>(){

                public Boolean apply(String context, String appKey, String network, String r1) {
                    return TextUtils.isEmpty((CharSequence)context) && TextUtils.isEmpty((CharSequence)appKey) && TextUtils.isEmpty((CharSequence)network) && TextUtils.isEmpty((CharSequence)r1);
                }
            }) : Observable.combineLatest((ObservableSource)oContext, (ObservableSource)oAppKey, (ObservableSource)oR1, (Function3)new Function3<String, String, String, Boolean>(){

                public Boolean apply(String context, String appKey, String r1) {
                    return TextUtils.isEmpty((CharSequence)context) && TextUtils.isEmpty((CharSequence)appKey) && TextUtils.isEmpty((CharSequence)r1);
                }
            });
            Consumer<Boolean> onNext = new Consumer<Boolean>(){

                public void accept(Boolean result) {
                    BLog.e("" + result);
                }
            };
            Consumer<Throwable> onError = new Consumer<Throwable>(){

                public void accept(Throwable e) {
                    if (listener instanceof BmobCallback2) {
                        ((BmobCallback2)listener).done(null, e);
                    } else if (listener instanceof BmobCallback1) {
                        ((BmobCallback1)listener).done(e);
                    } else if (listener instanceof UploadFileListener) {
                        ((UploadFileListener)listener).done(new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                    }
                }
            };
            Action onComplete = new Action(){

                public void run() {
                    BLog.e("complete");
                }
            };
            DisposableContainer disposableContainer = new DisposableContainer(){

                public boolean add(Disposable d) {
                    return false;
                }

                public boolean remove(Disposable d) {
                    return false;
                }

                public boolean delete(Disposable d) {
                    return false;
                }
            };
            this.mDisposable = this.observable.subscribe((Consumer)onNext, (Consumer)onError, onComplete, disposableContainer);
            return this;
        }

        public Builder check(List<R1> list) {
            return this.check(true, list);
        }

        public Builder create(ObservableOnSubscribe f) {
            this.observable = Observable.create((ObservableOnSubscribe)f);
            return this;
        }

        public Builder create(Observable o) {
            this.observable = o;
            return this;
        }

        public Builder nextTest(String url, JSONObject params) {
            this.observable = BmobClient.getInstance().request(url, params);
            return this;
        }

        public <T> Builder next(final Observable<T> nextObservable) {
            this.observable = this.observable.concatMap(new Function<Boolean, Observable<T>>(){

                public Observable<T> apply(Boolean aBoolean) throws Exception {
                    return nextObservable;
                }
            });
            return this;
        }

        public Builder direct(String url, JSONObject params) {
            this.observable = BmobClient.getInstance().request(url, params);
            return this;
        }

        public <T> Builder doOnNext(Consumer<T> consumer) {
            this.observable = this.observable.doOnNext(consumer);
            return this;
        }

        public Builder merge(Observable o1, Observable o2) {
            this.observable = Observable.merge((ObservableSource)o1, (ObservableSource)o2);
            return this;
        }

        public Builder zip(Observable o1, Observable o2, BiFunction biFunction) {
            this.observable = Observable.zip((ObservableSource)o1, (ObservableSource)o2, (BiFunction)biFunction);
            return this;
        }

        public Builder retryWhen(Function<Observable<? extends Throwable>, Observable<?>> fuc1) {
            this.observable = this.observable.retryWhen(fuc1);
            return this;
        }

        public <T, R> Builder map(Function<T, R> listener) {
            this.observable = this.observable.map(listener);
            return this;
        }

        public Builder mapJSONObject() {
            this.observable = this.observable.map((Function)new Function<JsonElement, JSONObject>(){

                public JSONObject apply(JsonElement jsonElement) throws Exception {
                    JSONObject obj = new JSONObject(jsonElement.toString());
                    return obj;
                }
            });
            return this;
        }

        public Builder mapJSONArray() {
            this.observable = this.observable.map((Function)new Function<JsonElement, JSONArray>(){

                public JSONArray apply(JsonElement jsonElement) throws Exception {
                    JSONArray ary = new JSONArray(jsonElement.getAsJsonObject().get("results").getAsJsonArray().toString());
                    return ary;
                }
            });
            return this;
        }

        public Builder mapCDN() {
            this.observable = this.observable.map((Function)new Function<JsonElement, Upyun>(){

                public Upyun apply(JsonElement jsonElement) throws Exception {
                    String cdn = jsonElement.getAsJsonObject().get("cdn").getAsJsonObject().toString();
                    CDN result = CDN.parse(cdn);
                    return result.getUpyun();
                }
            });
            return this;
        }

        public Builder mapSaveCDN() {
            this.observable = this.observable.map((Function)new Function<JsonElement, BmobException>(){

                public BmobException apply(JsonElement jsonElement) throws Exception {
                    String msg = jsonElement.getAsJsonObject().get("msg").getAsString();
                    if (msg != null && msg.equals("ok")) {
                        return new BmobException();
                    }
                    throw Exceptions.propagate((Throwable)new BmobException(9020, msg));
                }
            });
            return this;
        }

        public Builder mapDeleteCDN() {
            this.observable = this.observable.map((Function)new Function<JsonElement, BmobException>(){

                public BmobException apply(JsonElement jsonElement) throws Exception {
                    String msg = jsonElement.getAsJsonObject().get("msg").getAsString();
                    if (msg != null && msg.equals("ok")) {
                        return new BmobException();
                    }
                    throw Exceptions.propagate((Throwable)new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                }
            });
            return this;
        }

        public Builder mapCDNDeleteBatch() {
            this.observable = this.observable.map((Function)new Function<JsonElement, BmobReturn<String[]>>(){

                public BmobReturn<String[]> apply(JsonElement jsonElement) throws Exception {
                    Api ar = (Api)GsonUtil.toObject(jsonElement.toString(), Api.class);
                    Result result = ar.getResult();
                    if (result != null) {
                        int code = result.getCode();
                        String msg = result.getMessage();
                        if (code != 200) {
                            JsonObject jo = ar.getData().getAsJsonObject();
                            JsonArray upyun = jo.get("upyun").getAsJsonArray();
                            if (upyun != null && upyun.size() > 0) {
                                int size = upyun.size();
                                String[] ary = new String[upyun.size()];
                                for (int i = 0; i < size; ++i) {
                                    ary[i] = upyun.get(i).getAsString();
                                }
                                return new BmobReturn<String[]>(ary, new BmobException(code, msg));
                            }
                            return new BmobReturn<Object>(null, new BmobException(code, msg));
                        }
                        return new BmobReturn<Object>(null, null);
                    }
                    return new BmobReturn<Object>(null, new BmobException(9002, jsonElement.toString()));
                }
            });
            return this;
        }

        public Builder mapVoid() {
            this.observable = this.observable.map((Function)new Function<JsonElement, BmobException>(){

                public BmobException apply(JsonElement jsonElement) throws Exception {
                    return new BmobException();
                }
            });
            return this;
        }

        public Builder mapCount() {
            this.observable = this.observable.map((Function)new Function<JsonElement, Object>(){

                public Object apply(JsonElement jsonElement) throws Exception {
                    return jsonElement.getAsJsonObject().get("count").getAsInt();
                }
            });
            return this;
        }

        public Builder mapStatistics() {
            this.observable = this.observable.map((Function)new Function<JsonElement, JSONArray>(){

                public JSONArray apply(JsonElement jsonElement) throws Exception {
                    JSONArray json;
                    try {
                        JsonArray ary = jsonElement.getAsJsonObject().get("results").getAsJsonArray();
                        json = ary != null && ary.size() > 0 ? new JSONArray(ary.toString()) : null;
                    }
                    catch (JSONException e) {
                        json = null;
                    }
                    return json;
                }
            });
            return this;
        }

        public Builder mapString() {
            this.observable = this.observable.map((Function)new Function<JsonElement, String>(){

                public String apply(JsonElement jsonElement) throws Exception {
                    return jsonElement.toString();
                }
            });
            return this;
        }

        public <T> Builder mapT(final Class<T> clazz) {
            this.observable = this.observable.map(new Function<JsonElement, T>(){

                public T apply(JsonElement jsonElement) throws Exception {
                    return GsonUtil.toObject(jsonElement, clazz);
                }
            });
            return this;
        }

        public Builder mapBatch() {
            this.observable = this.observable.map((Function)new Function<JsonElement, List<BatchResult>>(){

                public List<BatchResult> apply(JsonElement jsonElement) throws Exception {
                    ArrayList<BatchResult> results = new ArrayList<BatchResult>();
                    try {
                        results.clear();
                        JSONArray ary = new JSONArray(jsonElement.toString());
                        int length = ary.length();
                        for (int i = 0; i < length; ++i) {
                            JSONObject obj = ary.getJSONObject(i);
                            BatchResult result = new BatchResult();
                            if (obj.has("success")) {
                                result.setSuccess(true);
                                JSONObject success = obj.getJSONObject("success");
                                if (success.has("createdAt")) {
                                    result.setCreatedAt(success.getString("createdAt"));
                                }
                                if (success.has("objectId")) {
                                    result.setObjectId(success.getString("objectId"));
                                }
                                if (success.has("updatedAt")) {
                                    result.setUpdatedAt(success.getString("updatedAt"));
                                }
                            } else if (obj.has("error")) {
                                result.setSuccess(false);
                                JSONObject error = obj.getJSONObject("error");
                                result.setError(new BmobException(error.has("code") ? error.getInt("code") : 9015, error.has("error") ? error.getString("error") : "\u6279\u91cf\u64cd\u4f5c\u51fa\u9519"));
                            } else {
                                result.setSuccess(false);
                                result.setError(new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                            }
                            results.add(result);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    return results;
                }
            });
            return this;
        }

        public Builder mapGetObject() {
            this.observable = this.observable.map((Function)new Function<JsonElement, String>(){

                public String apply(JsonElement jsonElement) throws Exception {
                    return jsonElement.toString();
                }
            });
            return this;
        }

        public Builder mapFindObjects() {
            this.observable = this.observable.map((Function)new Function<JsonElement, String>(){

                public String apply(JsonElement jsonElement) throws Exception {
                    return jsonElement.getAsJsonObject().getAsJsonArray("results").toString();
                }
            });
            return this;
        }

        public Builder mapSQLQuery() {
            this.observable = this.observable.map((Function)new Function<JsonElement, String>(){

                public String apply(JsonElement element) {
                    return element.toString();
                }
            });
            return this;
        }

        public Builder mapPolicyQuery(final BmobCallback listener) {
            this.observable = this.observable.map((Function)new Function<JsonElement, String>(){

                public String apply(JsonElement element) {
                    String data;
                    if (listener instanceof QueryListener || listener instanceof SQLQueryListener) {
                        data = element.toString();
                        Type actualTypeArgument = ((ParameterizedType)listener.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                        if (actualTypeArgument == BmobUser.class) {
                            BmobContentProvider.updateUser(data, actualTypeArgument.getClass());
                            JsonElement session = element.getAsJsonObject().get("sessionToken");
                            if (session != null) {
                                String sessionToken = session.getAsString();
                                BmobContentProvider.updateSessionToken(sessionToken);
                            }
                        }
                    } else if (listener instanceof FindListener) {
                        data = element.getAsJsonObject().getAsJsonArray("results").toString();
                    } else {
                        throw Exceptions.propagate((Throwable)new BmobException(9015, " mapPolicyQuery\u65b9\u6cd5\u4e0d\u652f\u6301BmobCallback"));
                    }
                    return data;
                }
            });
            return this;
        }

        public Builder observeOn(Scheduler scheduler) {
            this.observable = this.observable.observeOn(scheduler);
            return this;
        }

        public Builder subscribeOn(Scheduler scheduler) {
            this.observable = this.observable.subscribeOn(scheduler);
            return this;
        }

        public Builder subscribe(final BmobCallback listener) {
            if (listener == null) {
                BLog.e("listener is null,just create observable.");
                return this;
            }
            Consumer<Object> onNext = new Consumer<Object>(){

                public void accept(Object o) {
                    if (o == null) {
                        BLog.e("value is null");
                        return;
                    }
                    if (listener instanceof UploadFileListener) {
                        if (o instanceof BmobException && ((BmobException)o).getErrorCode() == 0) {
                            ((UploadFileListener)listener).done(null);
                        } else {
                            ((UploadFileListener)listener).done((BmobException)o);
                        }
                    } else if (listener instanceof DeleteBatchListener) {
                        BmobReturn bmobReturn = (BmobReturn)o;
                        if (bmobReturn.getE() == null) {
                            ((DeleteBatchListener)listener).done(null, null);
                        } else {
                            ((DeleteBatchListener)listener).done((String[])bmobReturn.getT(), bmobReturn.getE());
                        }
                    } else if (listener instanceof BmobCallback2) {
                        ((BmobCallback2)listener).done(o, null);
                    } else if (listener instanceof BmobCallback1) {
                        if (o instanceof BmobException && ((BmobException)o).getErrorCode() == 0) {
                            ((BmobCallback1)listener).done(null);
                        } else {
                            ((BmobCallback1)listener).done(o);
                        }
                    } else {
                        BLog.e("not support this callback");
                    }
                }
            };
            Consumer<Throwable> onError = new Consumer<Throwable>(){

                public void accept(Throwable e) {
                    if (listener instanceof UploadFileListener) {
                        if (e instanceof BmobException) {
                            BmobException bmobException = (BmobException)e;
                            ((UploadFileListener)listener).done(bmobException);
                        } else {
                            ((UploadFileListener)listener).done(new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                        }
                    } else if (listener instanceof DeleteBatchListener) {
                        if (e instanceof BmobException) {
                            BmobException bmobException = (BmobException)e;
                            ((DeleteBatchListener)listener).done(null, bmobException);
                        } else {
                            ((DeleteBatchListener)listener).done(null, new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                        }
                    } else if (listener instanceof BmobCallback2) {
                        if (e instanceof BmobException) {
                            BmobException bmobException = (BmobException)e;
                            ((BmobCallback2)listener).done(null, bmobException);
                        } else {
                            ((BmobCallback2)listener).done(null, new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                        }
                    } else if (listener instanceof BmobCallback1) {
                        if (e instanceof BmobException) {
                            BmobException bmobException = (BmobException)e;
                            ((BmobCallback1)listener).done(bmobException);
                        } else {
                            ((BmobCallback1)listener).done(new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
                        }
                    } else {
                        BLog.e("not support this callback");
                    }
                }
            };
            Action onComplete = new Action(){

                public void run() {
                    listener.onFinish();
                }
            };
            DisposableContainer container = new DisposableContainer(){

                public boolean add(Disposable d) {
                    return false;
                }

                public boolean remove(Disposable d) {
                    return false;
                }

                public boolean delete(Disposable d) {
                    return false;
                }
            };
            this.mDisposable = this.observable.subscribe((Consumer)onNext, (Consumer)onError, onComplete, container);
            return this;
        }

        public RxBmob build() {
            return new RxBmob(this);
        }
    }
}

