/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http.cache;

import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.http.BmobFactory;
import cn.bmob.v3.http.bean.R1;
import cn.bmob.v3.http.cache.CENPolicyQuery;
import cn.bmob.v3.http.cache.COPolicyQuery;
import cn.bmob.v3.http.cache.CTEPolicyQuery;
import cn.bmob.v3.http.cache.ICPolicyQuery;
import cn.bmob.v3.http.cache.NECPolicyQuery;
import cn.bmob.v3.http.cache.NOPolicyQuery;
import cn.bmob.v3.http.cache.PolicyQuery;
import cn.bmob.v3.listener.BmobCallback;
import cn.bmob.v3.listener.QueryListener;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class PolicyFactory {
    private static Map<BmobQuery.CachePolicy, PolicyQuery> strategyMap = new HashMap<BmobQuery.CachePolicy, PolicyQuery>();
    private static volatile PolicyFactory mClient;
    private static byte[] lock;

    private PolicyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PolicyFactory getInstance() {
        if (mClient != null) return mClient;
        byte[] byArray = lock;
        synchronized (lock) {
            if (mClient != null) return mClient;
            mClient = new PolicyFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mClient;
        }
    }

    public PolicyQuery create(BmobQuery.CachePolicy type) {
        return strategyMap.get((Object)type);
    }

    public <T> Disposable createPolicySubscription(String objectId, Class<T> clazz, BmobQuery.CachePolicy policy, long maxCacheAge, String url, JSONObject params, BmobCallback listener) {
        PolicyQuery query = this.create(policy);
        List<R1> list = listener instanceof QueryListener ? BmobFactory.rByContext(objectId, "objectId can't be empty") : Collections.emptyList();
        return query.subscribe(clazz, list, url, params, maxCacheAge, listener);
    }

    static {
        strategyMap.put(BmobQuery.CachePolicy.IGNORE_CACHE, new ICPolicyQuery());
        strategyMap.put(BmobQuery.CachePolicy.NETWORK_ONLY, new NOPolicyQuery());
        strategyMap.put(BmobQuery.CachePolicy.CACHE_ONLY, new COPolicyQuery());
        strategyMap.put(BmobQuery.CachePolicy.CACHE_ELSE_NETWORK, new CENPolicyQuery());
        strategyMap.put(BmobQuery.CachePolicy.CACHE_THEN_NETWORK, new CTEPolicyQuery());
        strategyMap.put(BmobQuery.CachePolicy.NETWORK_ELSE_CACHE, new NECPolicyQuery());
        lock = new byte[0];
    }
}

