/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http.cache;

import android.text.TextUtils;
import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.datatype.BmobQueryResult;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.RxBmob;
import cn.bmob.v3.http.bean.R1;
import cn.bmob.v3.http.rx.PolicyAction1;
import cn.bmob.v3.listener.BmobCallback;
import cn.bmob.v3.listener.BmobCallback2;
import cn.bmob.v3.listener.FindListener;
import cn.bmob.v3.listener.QueryListener;
import cn.bmob.v3.listener.SQLQueryListener;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.CacheHelper;
import cn.bmob.v3.util.ZipUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PolicyQuery<T> {
    public abstract Disposable subscribe(Class<T> var1, List<R1> var2, String var3, JSONObject var4, long var5, BmobCallback var7);

    public abstract boolean needNetwork();

    public abstract BmobQuery.CachePolicy cachePolicy();

    public Disposable createSubscription(Observable<String> observable, final QueryListener<String> listener) {
        Consumer<String> onNext = new Consumer<String>(){

            public void accept(String s) {
                listener.done(s, null);
            }
        };
        Consumer<Throwable> onError = new Consumer<Throwable>(){

            public void accept(Throwable e) {
                if (e instanceof BmobException) {
                    BmobException bmobException = (BmobException)e;
                    PolicyQuery.this.onErrorListener(bmobException, listener);
                } else if (e instanceof ClassCastException) {
                    BLog.i("createSubscription accept \u65f6\u51fa\u73b0 ClassCastException");
                } else {
                    BLog.i("createSubscription accept \u65f6\u51fa\u73b0\u672a\u77e5\u5f02\u5e38");
                }
            }
        };
        Action onComplete = new Action(){

            public void run() {
                listener.onFinish();
            }
        };
        DisposableContainer disposableContainer = new DisposableContainer(){

            public boolean add(Disposable d) {
                return false;
            }

            public boolean remove(Disposable d) {
                return false;
            }

            public boolean delete(Disposable d) {
                return false;
            }
        };
        return observable.subscribe((Consumer)onNext, (Consumer)onError, onComplete, disposableContainer);
    }

    public Observable cacheObservable(List<R1> list, JSONObject params, long maxCacheAge) {
        return new RxBmob.Builder().check(this.needNetwork(), list).next(this.createCacheObservable(params, maxCacheAge)).build().getObservable();
    }

    public Observable networkObservable(List<R1> list, String url, JSONObject params, BmobCallback listener) {
        return new RxBmob.Builder().check(this.needNetwork(), list).next(this.createNetworkObservable(url, params, listener)).build().getObservable();
    }

    private Observable createCacheObservable(final JSONObject params, final long maxCacheAge) {
        return new RxBmob.Builder().create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(ObservableEmitter<String> emitter) {
                if (emitter.isDisposed()) {
                    BLog.i("createCacheObservable:subscribe is cancel ");
                    return;
                }
                String cacheKey = CacheHelper.getCacheKey(params);
                Object cached = CacheHelper.jsonFromKeyValueCache(cacheKey, maxCacheAge);
                BLog.i("cache data:" + (cached == null ? "no cache" : cached.toString()));
                emitter.onNext((Object)(cached == null ? "" : cached.toString()));
                if (PolicyQuery.this.cachePolicy() == BmobQuery.CachePolicy.CACHE_ONLY) {
                    emitter.onComplete();
                }
            }
        }).build().getObservable();
    }

    private Observable<String> createGetObjectObservable(String url, JSONObject params) {
        return new RxBmob.Builder().direct(url, params).mapGetObject().doOnNext(new PolicyAction1(false, this.cachePolicy(), params)).build().getObservable();
    }

    private Observable<String> createFindObjectsObservable(String url, JSONObject params) {
        return new RxBmob.Builder().direct(url, params).mapFindObjects().doOnNext(new PolicyAction1(false, this.cachePolicy(), params)).build().getObservable();
    }

    private Observable<String> createSQLQueryObservable(String url, JSONObject params) {
        return new RxBmob.Builder().direct(url, params).mapSQLQuery().doOnNext(new PolicyAction1(true, this.cachePolicy(), params)).build().getObservable();
    }

    private Observable createNetworkObservable(String url, final JSONObject params, final BmobCallback listener) {
        return new RxBmob.Builder().direct(url, params).mapPolicyQuery(listener).doOnNext(new Consumer<String>(){

            public void accept(final String data) {
                if (listener == null) {
                    BLog.e("bmob", " listener is null ");
                    return;
                }
                if (PolicyQuery.this.cachePolicy() != BmobQuery.CachePolicy.IGNORE_CACHE) {
                    final Scheduler.Worker worker = Schedulers.io().createWorker();
                    worker.schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (PolicyQuery.this.needCache(data, listener)) {
                                CacheHelper.saveToKeyValueCache(CacheHelper.getCacheKey(params), ZipUtil.compress(data));
                            } else {
                                BLog.e("no data need to be cache");
                                worker.dispose();
                            }
                        }
                    });
                } else {
                    BLog.e("IGNORE_CACHE\uff1a\u8be5\u7b56\u7565\u4e0b\u65e0\u9700\u7f13\u5b58\u6570\u636e");
                }
            }
        }).build().getObservable();
    }

    private boolean needCache(String data, BmobCallback listener) {
        String result;
        if (listener instanceof SQLQueryListener) {
            JSONArray ary = null;
            try {
                JSONObject obj = new JSONObject(data);
                if (obj.has("results")) {
                    ary = obj.getJSONArray("results");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            result = ary == null ? "" : ary.toString();
        } else {
            result = data;
        }
        try {
            List list = GsonUtil.toList(result);
            return list != null && list.size() > 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    public void onNextListener(Class<T> clazz, String data, BmobCallback listener) {
        if (listener == null) {
            BLog.e("bmob", " listener is null ");
            return;
        }
        if ((this.cachePolicy() == BmobQuery.CachePolicy.CACHE_ONLY || this.cachePolicy() == BmobQuery.CachePolicy.NETWORK_ELSE_CACHE) && TextUtils.isEmpty((CharSequence)data)) {
            this.onErrorListener(new BmobException(9009, "No cache data."), listener);
            return;
        }
        Gson gson = new GsonBuilder().create();
        if (listener instanceof QueryListener) {
            BLog.i("getObject data\uff1a" + data);
            Object d = gson.fromJson(data, clazz);
            ((QueryListener)listener).done(d, null);
        } else if (listener instanceof FindListener) {
            ArrayList<Object> list = new ArrayList<Object>();
            List old = (List)gson.fromJson(data, List.class);
            if (old != null) {
                for (int i = 0; i < old.size(); ++i) {
                    String json = gson.toJson(old.get(i));
                    Object t = gson.fromJson(json, clazz);
                    list.add(t);
                }
            }
            ((FindListener)listener).done(list, null);
        } else if (listener instanceof SQLQueryListener) {
            ArrayList<Object> list = new ArrayList<Object>();
            int count = 0;
            try {
                JSONArray ary;
                List old;
                JSONObject obj = new JSONObject(data);
                if (obj.has("results") && (old = (List)gson.fromJson((ary = obj.getJSONArray("results")).toString(), List.class)) != null) {
                    for (int i = 0; i < old.size(); ++i) {
                        String json = gson.toJson(old.get(i));
                        Object t = gson.fromJson(json, clazz);
                        list.add(t);
                    }
                }
                if (obj.has("count")) {
                    count = obj.getInt("count");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BLog.i("query sql datas\uff1a" + count + ",\n" + data);
            ((SQLQueryListener)listener).done(new BmobQueryResult(list, count), null);
        } else {
            BLog.e("bmob", " onNextListener does not support this listener");
        }
    }

    public void onErrorListener(BmobException e, BmobCallback listener) {
        if (listener != null && listener instanceof BmobCallback2) {
            ((BmobCallback2)listener).done(null, e);
        } else {
            BLog.e("bmob", " listener is null ");
        }
    }
}

