/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http.interceptor;

import cn.bmob.v3.Bmob;
import cn.bmob.v3.helper.RequestHelper;
import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RequestUtils;
import cn.bmob.v3.util.BLog;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class RequestInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        String url = original.url().toString();
        BLog.i("url:" + url);
        String agent = RequestHelper.getUserAgent(Bmob.getApplicationContext());
        JSONObject obj = BmobClient.createParams(Bmob.getApplicationContext(), new JSONObject(), url);
        BLog.i("obj:" + obj);
        String encrytData = url.equals(BmobURL.getDefault().getSecretUrl()) ? RequestUtils.encrySecretDataWithKey1(agent, obj.toString()) : RequestUtils.encryDataWithSecretKey(obj.toString());
        RequestBody body = RequestBody.create((MediaType)BmobClient.MEDIA_TYPE, (String)encrytData);
        Request.Builder newBuilder = original.newBuilder().header("Content-Type", "text/plain; charset=utf-8").header("Accept-Encoding", "gzip,deflate,sdch").header("User-Agent", agent).post(body);
        if (!url.equals(BmobURL.getDefault().getSecretUrl())) {
            newBuilder.addHeader("Accept-Id", RequestUtils.getAcceptId());
        }
        Request newRequest = newBuilder.build();
        BLog.i("\u8bf7\u6c42\u5934:" + newRequest.headers().toString());
        return chain.proceed(newRequest);
    }
}

