/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http.interceptor;

import android.text.TextUtils;
import cn.bmob.v3.helper.BmobNative;
import cn.bmob.v3.http.BmobClient;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.RequestUtils;
import cn.bmob.v3.http.bean.Api;
import cn.bmob.v3.http.bean.Result;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.EncryptUtils;
import cn.bmob.v3.util.HtmlUtils;
import cn.bmob.v3.util.ZipUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ResponseInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request orignalRequest = chain.request();
        String url = orignalRequest.url().toString();
        Response originalResponse = chain.proceed(orignalRequest);
        byte[] bytes = originalResponse.body().bytes();
        String decryData = ZipUtil.getRealString(bytes);
        BLog.i("before enc:" + decryData);
        String data = "";
        if (TextUtils.isEmpty((CharSequence)decryData)) {
            Api api = new Api();
            Result result = new Result();
            result.setCode(9002);
            result.setMessage("The response content is null or empty.");
            api.setResult(result);
            Gson gson = new Gson();
            data = gson.toJson((Object)api, Api.class);
        } else if (ResponseInterceptor.validate(decryData)) {
            data = decryData;
            BLog.i("JSON DATA:" + data);
        } else {
            String title = HtmlUtils.getTitle(decryData);
            if (!TextUtils.isEmpty((CharSequence)title)) {
                Api api = new Api();
                Result result = new Result();
                result.setCode(9002);
                result.setMessage(decryData);
                api.setResult(result);
                Gson gson = new Gson();
                data = gson.toJson((Object)api, Api.class);
                BLog.i("HTML DATA:" + data);
            } else {
                try {
                    String secret = "/secret";
                    if (url.contains(secret)) {
                        String responseId = originalResponse.header(BmobURL.getDefault().RESPONSE_ID, "");
                        if (!TextUtils.isEmpty((CharSequence)responseId)) {
                            data = RequestUtils.decrySecretDataWithKey2(responseId, decryData);
                            if (TextUtils.isEmpty((CharSequence)data)) {
                                BLog.e(responseId);
                                String key = responseId.substring(responseId.length() - 16);
                                data = EncryptUtils.decrypt(key, key, decryData);
                                BLog.e("Java Secret API Response :" + data);
                            }
                        } else {
                            BLog.e("bmob", "responseId is null");
                            Api api = new Api();
                            Result result = new Result();
                            result.setCode(9002);
                            result.setMessage(decryData);
                            api.setResult(result);
                            Gson gson = new Gson();
                            data = gson.toJson((Object)api, Api.class);
                        }
                    } else {
                        data = RequestUtils.decryDataWithSecretKey(decryData);
                        if (TextUtils.isEmpty((CharSequence)data)) {
                            String key = BmobNative.SECRET_KEY.substring(BmobNative.SECRET_KEY.length() - 16);
                            data = EncryptUtils.decrypt(key, key, decryData);
                            BLog.e("Java Other API Response :" + data);
                        }
                    }
                    BLog.i("Secret Decrypt DATA:" + data);
                }
                catch (Exception e) {
                    data = decryData;
                    BLog.i("Decrypt Exception, Encrypt DATA:" + data);
                }
            }
        }
        ResponseBody responseBody = ResponseBody.create((MediaType)BmobClient.MEDIA_TYPE, (String)data);
        return originalResponse.newBuilder().body(responseBody).build();
    }

    public static boolean validate(String jsonStr) {
        JsonElement jsonElement;
        try {
            jsonElement = new JsonParser().parse(jsonStr);
        }
        catch (Exception e) {
            return false;
        }
        if (jsonElement == null) {
            return false;
        }
        return jsonElement.isJsonObject();
    }
}

