/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http.rx;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Looper;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Action;

public class BroadcastObservable
implements ObservableOnSubscribe<Boolean> {
    private final Context context;

    public BroadcastObservable(Context context) {
        this.context = context;
    }

    public static Observable<Boolean> fromConnectivityManager(Context context) {
        return Observable.create((ObservableOnSubscribe)new BroadcastObservable(context)).share();
    }

    private boolean isConnectedToInternet() {
        ConnectivityManager manager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private static Disposable unsubscribeInUiThread(final Action action) {
        return Disposable.fromAction((Action)new Action(){

            public void run() throws Throwable {
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    action.run();
                } else {
                    final Scheduler.Worker inner = AndroidSchedulers.mainThread().createWorker();
                    inner.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                action.run();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                            inner.dispose();
                        }
                    });
                }
            }
        });
    }

    public void subscribe(final ObservableEmitter<Boolean> emitter) throws Exception {
        final BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                emitter.onNext((Object)BroadcastObservable.this.isConnectedToInternet());
            }
        };
        this.context.registerReceiver(receiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        emitter.setDisposable(BroadcastObservable.unsubscribeInUiThread(new Action(){

            public void run() throws Exception {
                BroadcastObservable.this.context.unregisterReceiver(receiver);
            }
        }));
    }
}

