/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http.rx;

import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.CacheHelper;
import cn.bmob.v3.util.ZipUtil;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import org.json.JSONObject;

public class PolicyAction1
implements Consumer<String> {
    boolean isSqlQuery;
    BmobQuery.CachePolicy cachePolicy;
    JSONObject params;

    public PolicyAction1(boolean isSqlQuery, BmobQuery.CachePolicy cachePolicy, JSONObject params) {
        this.isSqlQuery = isSqlQuery;
        this.cachePolicy = cachePolicy;
        this.params = params;
    }

    public void accept(final String data) {
        if (this.cachePolicy != BmobQuery.CachePolicy.IGNORE_CACHE) {
            final Scheduler.Worker worker = Schedulers.io().createWorker();
            worker.schedule(new Runnable(){

                @Override
                public void run() {
                    String result = PolicyAction1.this.isSqlQuery ? data.split("&")[1] : data;
                    List list = GsonUtil.toList(result);
                    BLog.i("size:" + list.size());
                    if (list != null && list.size() > 0) {
                        CacheHelper.saveToKeyValueCache(CacheHelper.getCacheKey(PolicyAction1.this.params), ZipUtil.compress(result));
                    } else {
                        BLog.e("no data need to be cache");
                        worker.dispose();
                    }
                }
            });
        } else {
            BLog.e("IGNORE_CACHE\uff1a\u8be5\u7b56\u7565\u4e0b\u65e0\u9700\u7f13\u5b58\u6570\u636e");
        }
    }
}

