/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.http.rx;

import android.content.Context;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.http.rx.BroadcastObservable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.concurrent.TimeUnit;

public class RetryWithNetworkChange
implements Function<Observable<? extends Throwable>, Observable<?>> {
    private final int maxTimeout;
    private final Observable<Boolean> isConnected;
    private final int startTimeOut;
    private int timeout;

    public RetryWithNetworkChange(Context context, int startTimeOut, int maxTimeout) {
        this.startTimeOut = startTimeOut;
        this.maxTimeout = maxTimeout;
        this.timeout = startTimeOut;
        this.isConnected = this.getConnectedObservable(context);
    }

    public Observable<?> apply(Observable<? extends Throwable> observable) {
        return observable.flatMap((Function)new Function<Throwable, Observable<Boolean>>(){

            public Observable<Boolean> apply(Throwable throwable) {
                if (throwable instanceof BmobException && ((BmobException)throwable).getErrorCode() == 9016) {
                    return RetryWithNetworkChange.this.isConnected;
                }
                return Observable.error((Throwable)throwable);
            }
        }).compose(this.attachTimeout());
    }

    private ObservableTransformer<Boolean, Boolean> attachTimeout() {
        return new ObservableTransformer<Boolean, Boolean>(){

            public ObservableSource<Boolean> apply(Observable<Boolean> upstream) {
                return upstream.timeout((long)RetryWithNetworkChange.this.timeout, TimeUnit.SECONDS).doOnError((Consumer)new Consumer<Throwable>(){

                    public void accept(Throwable throwable) {
                        if (throwable instanceof BmobException) {
                            RetryWithNetworkChange.this.timeout = RetryWithNetworkChange.this.timeout > RetryWithNetworkChange.this.maxTimeout ? RetryWithNetworkChange.this.maxTimeout : RetryWithNetworkChange.this.timeout + RetryWithNetworkChange.this.startTimeOut;
                        }
                    }
                });
            }
        };
    }

    private Observable<Boolean> getConnectedObservable(Context context) {
        return BroadcastObservable.fromConnectivityManager(context).distinctUntilChanged().filter((Predicate)new Predicate<Boolean>(){

            public boolean test(Boolean aBoolean) throws Exception {
                return aBoolean;
            }
        });
    }
}

