/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.realtime;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Base64;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.helper.BmobNative;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.util.BLog;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Client {
    public static final String TAG = "Client";
    public static final String ACTION_UPDATE_TABLE = "updateTable";
    public static final String ACTION_DELETE_TABLE = "deleteTable";
    public static final String ACTION_UPDATE_ROW = "updateRow";
    public static final String ACTION_DELETE_ROW = "deleteRow";
    private ClientListener mClientListener;
    public String DEFAULT_REAL_TIME_DATA_HOST;
    public static final String DEFAULT_REAL_TIME_DATA_PATH_WEBSOCKET = "websocket/";
    public static final String PROTOCOL_WEBSOCKET = "websocket";
    private OkHttpClient mOkHttpClient;
    private WebSocket mWebSocket;
    int ackCount = 0;
    private ListenHandler mListenHandler = new ListenHandler();

    public Client() {
        this.mOkHttpClient = new OkHttpClient();
        this.DEFAULT_REAL_TIME_DATA_HOST = "http://" + BmobURL.getDefault().getRealTimeDataUrl() + ":3010/socket.io/1/";
    }

    public void connect(ClientListener clientListener) {
        this.mClientListener = clientListener;
        ConfigTask configTask = new ConfigTask();
        configTask.execute(new Void[0]);
    }

    public String getServerConfiguration() throws IOException {
        Request.Builder builder = new Request.Builder();
        builder.url(this.DEFAULT_REAL_TIME_DATA_HOST);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)"");
        builder.post(requestBody);
        builder.header("User-Agent", "android-websockets-2.0");
        Request request = builder.build();
        Call call = this.mOkHttpClient.newCall(request);
        Response response = call.execute();
        String result = response.body().string();
        return result;
    }

    private void newWebSocket(String session, final OnNewWebsocketListener onNewWebsocketListener) {
        Request.Builder builder = new Request.Builder();
        final String key = this.createSecret();
        BLog.e("key:" + key);
        String url = this.DEFAULT_REAL_TIME_DATA_HOST + DEFAULT_REAL_TIME_DATA_PATH_WEBSOCKET + session;
        builder.url(url);
        builder.header("GET", "HTTP/1.1");
        builder.header("Upgrade", PROTOCOL_WEBSOCKET);
        builder.header("Connection", "Upgrade");
        builder.header("User-Agent", "android-websockets-2.0");
        builder.header("Sec-WebSocket-Key", key);
        builder.header("Sec-WebSocket-Version", "13");
        Request request = builder.build();
        this.mOkHttpClient.newWebSocket(request, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                BLog.e("onOpen\uff1a" + response.message());
                Headers headers = response.headers();
                BLog.e("onOpen\uff1a" + headers.toString());
                try {
                    BLog.e("onOpen\uff1a" + response.body().string());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String expected = Client.this.expectedKey(key);
                BLog.e("onOpen\uff1a" + expected);
            }

            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                try {
                    Client.this.handleMessage(webSocket, text, onNewWebsocketListener);
                }
                catch (JSONException e) {
                    onNewWebsocketListener.onFailure((Exception)((Object)e));
                    e.printStackTrace();
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                BLog.e("onClosing\uff1a" + reason);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                BLog.e("onClosed\uff1a" + reason);
                onNewWebsocketListener.onDisconnected();
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                super.onFailure(webSocket, t, response);
                BLog.e("onFailure\uff1a" + t.toString());
                onNewWebsocketListener.onDisconnected();
            }
        });
    }

    private void handleMessage(WebSocket webSocket, String text, OnNewWebsocketListener onNewWebsocketListener) throws JSONException {
        BLog.e("onMessage\uff1a" + text);
        String[] parts = text.split(":", 4);
        int code = Integer.parseInt(parts[0]);
        switch (code) {
            case 0: {
                onNewWebsocketListener.onDisconnected();
                break;
            }
            case 1: {
                onNewWebsocketListener.onConnected(webSocket);
                break;
            }
            case 2: {
                this.send("2::");
                onNewWebsocketListener.onHeartbeat();
                break;
            }
            case 3: {
                onNewWebsocketListener.onStringMessage();
                break;
            }
            case 4: {
                String dataString = parts[3];
                JSONObject jsonMessage = new JSONObject(dataString);
                onNewWebsocketListener.onJsonMessage();
                break;
            }
            case 5: {
                String dataString = parts[3];
                JSONObject data = new JSONObject(dataString);
                String event = data.getString("name");
                JSONArray args = data.optJSONArray("args");
                BLog.e(event);
                if (!event.equals("server_pub")) break;
                BLog.e(event);
                String json = args.getString(0);
                onNewWebsocketListener.onChange(new JSONObject(json));
                break;
            }
            case 6: {
                String[] ackParts = parts[3].split("\\+", 2);
                JSONArray arguments = null;
                if (ackParts.length == 2) {
                    arguments = new JSONArray(ackParts[1]);
                }
                String data = "";
                if (arguments != null) {
                    data = data + "+" + arguments.toString();
                }
                webSocket.send(String.format("6:::%s%s", parts[1], data));
                break;
            }
            case 7: {
                onNewWebsocketListener.onError(parts[2], parts[3]);
                break;
            }
            case 8: {
                onNewWebsocketListener.onNoop();
                break;
            }
        }
    }

    private String createSecret() {
        int length = 16;
        byte[] nonce = new byte[length];
        for (int i = 0; i < length; ++i) {
            nonce[i] = (byte)(Math.random() * 256.0);
        }
        return Base64.encodeToString((byte[])nonce, (int)0).trim();
    }

    private String expectedKey(String secret) {
        try {
            String GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            String secretGUID = secret + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(secretGUID.getBytes());
            return Base64.encodeToString((byte[])digest, (int)0).trim();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public void emitRaw(int type, String message) {
        String id = "" + this.ackCount++;
        String ack = id + "+";
        String send = String.format("%d:%s:%s:%s", type, ack, "", message);
        BLog.e("\u5ba2\u6237\u7aef\u53d1\u9001\uff1a" + send);
        this.send(send);
    }

    public void send(String text) {
        BLog.e("send\uff1a" + text);
        this.mWebSocket.send(text);
    }

    public void subTableUpdate(String tableName) {
        JSONArray args = new JSONArray();
        args.put((Object)this.getArgs(tableName, "", ACTION_UPDATE_TABLE).toString());
        this.emit("client_sub", args);
    }

    public void unsubTableUpdate(String tableName) {
        JSONArray args = new JSONArray();
        args.put((Object)this.getArgs(tableName, "", "unsub_updateTable").toString());
        this.emit("client_unsub", args);
    }

    public void subTableDelete(String tableName) {
        JSONArray args = new JSONArray();
        args.put((Object)this.getArgs(tableName, "", ACTION_DELETE_TABLE).toString());
        this.emit("client_sub", args);
    }

    public void unsubTableDelete(String tableName) {
        JSONArray args = new JSONArray();
        args.put((Object)this.getArgs(tableName, "", "unsub_deleteTable").toString());
        this.emit("client_unsub", args);
    }

    public void subRowUpdate(String tableName, String objectId) {
        JSONArray args = new JSONArray();
        args.put((Object)this.getArgs(tableName, objectId, ACTION_UPDATE_ROW).toString());
        this.emit("client_sub", args);
    }

    public void unsubRowUpdate(String tableName, String objectId) {
        JSONArray args = new JSONArray();
        args.put((Object)this.getArgs(tableName, objectId, "unsub_updateRow").toString());
        this.emit("client_unsub", args);
    }

    public void subRowDelete(String tableName, String objectId) {
        JSONArray args = new JSONArray();
        args.put((Object)this.getArgs(tableName, objectId, ACTION_DELETE_ROW).toString());
        this.emit("client_sub", args);
    }

    public void unsubRowDelete(String tableName, String objectId) {
        JSONArray args = new JSONArray();
        args.put((Object)this.getArgs(tableName, objectId, "unsub_deleteRow").toString());
        this.emit("client_unsub", args);
    }

    private JSONObject getArgs(String tableName, String objectId, String action) {
        JSONObject j = new JSONObject();
        try {
            j.put("appKey", (Object)BmobNative.getAppId());
            j.put("tableName", (Object)tableName);
            j.put("objectId", (Object)objectId);
            j.put("action", (Object)action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public void emit(String name, JSONArray args) {
        JSONObject event = new JSONObject();
        try {
            event.put("name", (Object)name);
            event.put("args", (Object)args);
            this.emitRaw(5, event.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void listenRealTime(String session) {
        this.newWebSocket(session, new OnNewWebsocketListener(){

            @Override
            public void onFailure(Exception ex) {
                Message message = new Message();
                message.what = -1;
                message.obj = ex;
                Client.this.mListenHandler.sendMessage(message);
            }

            @Override
            public void onDisconnected() {
                Client.this.mWebSocket.send(String.format("0::%s", ""));
                Message message = new Message();
                message.what = 0;
                Client.this.mListenHandler.sendMessage(message);
            }

            @Override
            public void onConnected(WebSocket webSocket) {
                Client.this.mWebSocket = webSocket;
                Client.this.mWebSocket.send(String.format("1::%s", ""));
                Message message = new Message();
                message.what = 1;
                Client.this.mListenHandler.sendMessage(message);
            }

            @Override
            public void onHeartbeat() {
                BLog.e("onHeartbeat");
            }

            @Override
            public void onStringMessage() {
            }

            @Override
            public void onJsonMessage() {
            }

            @Override
            public void onChange(JSONObject jsonObject) {
                BLog.e("onDataChange");
                Message message = new Message();
                message.what = 5;
                message.obj = jsonObject;
                Client.this.mListenHandler.sendMessage(message);
            }

            @Override
            public void onAck() {
            }

            @Override
            public void onError(String err, String error) {
                Message message = new Message();
                message.what = -1;
                message.obj = new Exception(err + ":" + error);
                Client.this.mListenHandler.sendMessage(message);
            }

            @Override
            public void onNoop() {
            }
        });
    }

    private class ListenHandler
    extends Handler {
        private ListenHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case -1: {
                    Exception exception = (Exception)msg.obj;
                    Client.this.mClientListener.onConnectCompleted(Client.this, exception);
                    break;
                }
                case 0: {
                    Client.this.mClientListener.onDisconnectCompleted(Client.this);
                    break;
                }
                case 1: {
                    Client.this.mClientListener.onConnectCompleted(Client.this, null);
                    break;
                }
                case 5: {
                    JSONObject jsonObject = (JSONObject)msg.obj;
                    Client.this.mClientListener.onDataChange(Client.this, jsonObject);
                    break;
                }
            }
        }
    }

    class ConfigTask
    extends AsyncTask<Void, Void, String> {
        ConfigTask() {
        }

        protected String doInBackground(Void ... voids) {
            try {
                return Client.this.getServerConfiguration();
            }
            catch (IOException e) {
                if (e == null) {
                    return null;
                }
                return e.getMessage();
            }
        }

        protected void onPostExecute(String config) {
            super.onPostExecute((Object)config);
            this.handleConfig(config);
        }

        private void handleConfig(String config) {
            if (TextUtils.isEmpty((CharSequence)config)) {
                Client.this.mClientListener.onConnectCompleted(Client.this, new BmobException(9015, "\u8bf7\u68c0\u67e5\u5982\u4e0b\u539f\u56e0\uff1a1\u3001\u662f\u5426\u6dfb\u52a0\u4e86\u8bf7\u6c42\u7f51\u7edc\u6743\u9650\uff1b 2\u3001\u662f\u5426\u63a5\u5165\u4e86\u4f60\u81ea\u5df1\u7684\u5907\u6848\u57df\u540d\uff1b 3\u3001\u662f\u5426\u5728\u7528\u6a21\u62df\u5668\u6216\u8005\u771f\u673a\u6d4b\u8bd5\u65f6\uff0c\u6ca1\u6709\u6253\u5f00\u7f51\u7edc\uff1b 4\u3001\u662f\u5426\u80fd\u591fping\u901a\u4f60\u7684cname\uff1b 5\u3001targetSdkVersion\u5927\u4e8e27\u4ee5\u4e0a\u65f6\uff0c\u662f\u5426\u91c7\u7528https\u8bf7\u6c42\u6216\u8005\u8bbe\u7f6e\u4e86\u7f51\u7edc\u5b89\u5168\u914d\u7f6e.\u8be6\u7ec6\u8bb2\u89e3\u8bf7\u67e5\u770b\u6587\u7ae0\uff1ahttps://blog.csdn.net/m0_74037076/article/details/131123957"));
            } else {
                String[] parts = config.split(":");
                if (parts.length == 0 || parts.length < 4) {
                    Client.this.mClientListener.onConnectCompleted(Client.this, new BmobException(9015, "AppKey is Null, Please initialize BmobSDK(9001)."));
                } else {
                    String[] transports;
                    HashSet<String> set;
                    final String session = parts[0];
                    String heartbeat = parts[1];
                    String transportsLine = parts[3];
                    int heartbeatInt = 0;
                    if (!"".equals(heartbeat)) {
                        heartbeatInt = Integer.parseInt(heartbeat) / 2 * 1000;
                    }
                    if (!(set = new HashSet<String>(Arrays.asList(transports = transportsLine.split(",")))).contains(Client.PROTOCOL_WEBSOCKET)) {
                        Client.this.mClientListener.onConnectCompleted(Client.this, new BmobException(9015, " \u4f60\u7684\u8bbe\u5907\u4e0d\u652f\u6301websocket"));
                    } else {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                Client.this.listenRealTime(session);
                            }
                        }).start();
                    }
                }
            }
        }
    }

    public static interface ClientListener {
        public void onConnectCompleted(Client var1, Exception var2);

        public void onDisconnectCompleted(Client var1);

        public void onDataChange(Client var1, JSONObject var2);
    }

    private static interface OnNewWebsocketListener {
        public void onFailure(Exception var1);

        public void onDisconnected();

        public void onConnected(WebSocket var1);

        public void onHeartbeat();

        public void onStringMessage();

        public void onJsonMessage();

        public void onChange(JSONObject var1);

        public void onAck();

        public void onError(String var1, String var2);

        public void onNoop();
    }
}

