/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.update;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import android.widget.Toast;
import cn.bmob.v3.BmobQuery;
import cn.bmob.v3.datatype.BmobFile;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.listener.BmobDialogButtonListener;
import cn.bmob.v3.listener.BmobUpdateListener;
import cn.bmob.v3.listener.FindListener;
import cn.bmob.v3.update.AppVersion;
import cn.bmob.v3.update.UpdateDialogActivity;
import cn.bmob.v3.update.UpdateResponse;
import cn.bmob.v3.update.res.UpdateConfig;
import cn.bmob.v3.util.BLog;
import cn.bmob.v3.util.BmobContentProvider;
import cn.bmob.v3.util.DownloadApk;
import cn.bmob.v3.util.FileUtils;
import cn.bmob.v3.util.InstallUtil;
import cn.bmob.v3.util.ManifestUtils;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BmobUpdateAgent {
    private static BmobUpdateListener updateListener = null;
    private static BmobDialogButtonListener dialogListener;

    public static void initAppVersion() {
        AppVersion app = new AppVersion();
        app.setUpdate_log("");
        app.setVersion("");
        app.setVersion_i(0);
        app.setTarget_size("0");
        app.setPath(BmobFile.createEmptyFile());
        app.setAndroid_url("");
        app.setChannel("");
        app.setIos_url("");
        app.setIsforce(false);
        app.setPlatform("Android");
        final Observable saveObservable = app.saveObservable().map((Function)new Function<String, BmobException>(){

            public BmobException apply(String s) {
                return new BmobException();
            }
        });
        BmobQuery<AppVersion> query = new BmobQuery<AppVersion>();
        query.setLimit(1);
        query.findObjectsObservable(AppVersion.class).concatMap((Function)new Function<List<AppVersion>, Observable<BmobException>>(){

            public Observable<BmobException> apply(List<AppVersion> appVersions) {
                if (appVersions == null || appVersions.size() <= 0) {
                    return saveObservable;
                }
                return Observable.error((Throwable)new BmobException(9015, "AppVersion\u8868\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u521b\u5efa"));
            }
        }).onErrorResumeNext((Function)new Function<Throwable, Observable<? extends BmobException>>(){

            public Observable<? extends BmobException> apply(Throwable e) {
                if (e instanceof BmobException && ((BmobException)e).getErrorCode() == 101) {
                    return saveObservable;
                }
                return Observable.error((Throwable)e);
            }
        }).subscribe((Observer)new Observer<BmobException>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(BmobException aVoid) {
                BLog.i("AppVersion create success");
            }

            public void onError(Throwable throwable) {
                BLog.e(throwable.getMessage());
            }

            public void onComplete() {
            }
        });
    }

    public static void update(Context context) {
        if ("3".equals(ManifestUtils.getNetType(context)) || !UpdateConfig.isUpdateOnlyWifi()) {
            UpdateConfig.setUpdateForce(false);
            UpdateConfig.setSilentDownload(false);
            BmobUpdateAgent.checkVer(context);
        }
    }

    public static boolean deleteApk() {
        return FileUtils.deleteQuietly(new File(InstallUtil.getAppDir()));
    }

    public static void forceUpdate(Context context) {
        UpdateConfig.setUpdateForce(true);
        UpdateConfig.setSilentDownload(false);
        BmobUpdateAgent.checkVer(context);
    }

    public static void silentUpdate(Context context) {
        if ("3".equals(ManifestUtils.getNetType(context)) || !UpdateConfig.isUpdateOnlyWifi()) {
            UpdateConfig.setUpdateForce(false);
            UpdateConfig.setSilentDownload(true);
            BmobUpdateAgent.checkVer(context);
        }
    }

    public static void setDefault() {
        BmobUpdateAgent.setUpdateOnlyWifi(true);
        BmobUpdateAgent.setUpdateListener(null);
        BmobUpdateAgent.setDialogListener(null);
    }

    public static void setUpdateOnlyWifi(boolean updateOnlyWifi) {
        UpdateConfig.setUpdateOnlyWifi(updateOnlyWifi);
    }

    public static void setUpdateCheckConfig(boolean isCheck) {
        UpdateConfig.setUpdateCheck(isCheck);
    }

    public static void setUpdateListener(BmobUpdateListener paramBmobUpdateListener) {
        updateListener = paramBmobUpdateListener;
    }

    public static void setDialogListener(BmobDialogButtonListener buttonListener) {
        dialogListener = buttonListener;
    }

    static void dialogResult(int paramInt, Context paramContext, UpdateResponse paramUpdateResponse, File paramFile) {
        switch (paramInt) {
            case 6: {
                if (!UpdateConfig.isSilentDownload() && dialogListener != null) {
                    dialogListener.onClick(6);
                }
                BmobUpdateAgent.updateApp(paramContext, paramUpdateResponse, paramFile);
                break;
            }
            case 7: {
                if (dialogListener == null) break;
                dialogListener.onClick(7);
                break;
            }
            case 8: {
                if (dialogListener == null) break;
                dialogListener.onClick(8);
                break;
            }
        }
    }

    private static void updateApp(Context paramContext, UpdateResponse paramUpdateResponse, File paramFile) {
        if (paramFile != null && paramFile.exists()) {
            long currentLength = paramFile.length();
            long total = paramUpdateResponse.target_size;
            if (total > 0L) {
                if (currentLength >= total) {
                    InstallUtil.startInstall(paramContext, paramFile);
                } else {
                    BmobUpdateAgent.downloadApk(true, paramContext, paramUpdateResponse, paramFile);
                }
            } else {
                paramFile.delete();
                if (updateListener != null) {
                    updateListener.onUpdateReturned(2, new UpdateResponse(2, ""));
                }
            }
        } else {
            BmobUpdateAgent.downloadApk(true, paramContext, paramUpdateResponse, paramFile);
        }
    }

    private static void downloadApk(boolean isDelete, Context paramContext, UpdateResponse paramUpdateResponse, File paramFile) {
        if (isDelete && paramFile != null && paramFile.exists()) {
            paramFile.delete();
        }
        DownloadApk dla = new DownloadApk(paramContext, paramUpdateResponse.path);
        dla.startDownload();
    }

    private static boolean checkConfig(Context paramContext) {
        if (!UpdateConfig.isUpdateCheck()) {
            return true;
        }
        boolean i = false;
        int j = 0;
        boolean k = false;
        boolean m = false;
        try {
            PackageInfo localPackageInfo = paramContext.getPackageManager().getPackageInfo(paramContext.getPackageName(), 4101);
            if (localPackageInfo.activities != null) {
                for (j = 0; j < localPackageInfo.activities.length; ++j) {
                    if (!"cn.bmob.v3.update.UpdateDialogActivity".equals(localPackageInfo.activities[j].name)) continue;
                    i = true;
                }
            }
            if (!i) {
                Toast.makeText((Context)paramContext, (CharSequence)"Please add Activity in AndroidManifest!", (int)0).show();
                return false;
            }
            if (localPackageInfo.requestedPermissions != null) {
                for (int n = 0; n < localPackageInfo.requestedPermissions.length; ++n) {
                    if ("android.permission.WRITE_EXTERNAL_STORAGE".equals(localPackageInfo.requestedPermissions[n])) {
                        j = 1;
                        continue;
                    }
                    if ("android.permission.ACCESS_NETWORK_STATE".equals(localPackageInfo.requestedPermissions[n])) {
                        k = true;
                        continue;
                    }
                    if (!"android.permission.INTERNET".equals(localPackageInfo.requestedPermissions[n])) continue;
                    m = true;
                }
            }
            boolean bl = i = j != 0 && k && m;
            if (!i) {
                Toast.makeText((Context)paramContext, (CharSequence)"Please add Permission in AndroidManifest!", (int)0).show();
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static void checkVer(final Context context) {
        if (!BmobUpdateAgent.checkConfig(context)) {
            return;
        }
        BmobQuery<AppVersion> query = new BmobQuery<AppVersion>();
        query.addWhereEqualTo("platform", "Android");
        String channel = UpdateConfig.getChannel(context);
        if (!TextUtils.isEmpty((CharSequence)channel)) {
            query.addWhereEqualTo("channel", channel);
        }
        query.addWhereGreaterThan("version_i", ManifestUtils.getVersionCode());
        query.order("-version_i");
        query.findObjects(new FindListener<AppVersion>(){

            @Override
            public void done(List<AppVersion> objects, BmobException e) {
                if (e == null) {
                    if (objects != null && objects.size() > 0) {
                        UpdateResponse ur = new UpdateResponse(objects.get(0));
                        if (ur.target_size <= 0L) {
                            if (updateListener != null) {
                                updateListener.onUpdateReturned(2, new UpdateResponse(2, "target_size\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u5bf9\uff0c\u8bf7\u586b\u5199apk\u6587\u4ef6\u5927\u5c0f(long\u7c7b\u578b)\u3002"));
                            }
                            return;
                        }
                        if (TextUtils.isEmpty((CharSequence)ur.path)) {
                            if (updateListener != null) {
                                updateListener.onUpdateReturned(2, new UpdateResponse(2, "path/android_url\u9700\u586b\u5199\u5176\u4e2d\u4e4b\u4e00\u3002"));
                            }
                            return;
                        }
                        if (updateListener != null) {
                            updateListener.onUpdateReturned(0, ur);
                        }
                        File file = new File(InstallUtil.getAppDir(), ur.path_md5 + ".apk");
                        if (UpdateConfig.isSilentDownload()) {
                            if (file.exists()) {
                                BmobUpdateAgent.parseResult(context, ur, file, false);
                            } else {
                                BmobUpdateAgent.dialogResult(6, context, ur, file);
                            }
                        } else if (UpdateConfig.isUpdateForce()) {
                            BmobUpdateAgent.parseResult(context, ur, file, false);
                        } else if (!BmobUpdateAgent.isIgnored(String.valueOf(ur.version_i))) {
                            BmobUpdateAgent.parseResult(context, ur, file, true);
                        } else if (updateListener != null) {
                            updateListener.onUpdateReturned(3, new UpdateResponse(3, "\u8be5\u7248\u672c\u5df2\u88ab\u5ffd\u7565\u66f4\u65b0"));
                        }
                    } else if (updateListener != null) {
                        updateListener.onUpdateReturned(1, new UpdateResponse(1, "\u672a\u67e5\u8be2\u5230\u7248\u672c\u66f4\u65b0\u4fe1\u606f\u3002"));
                    }
                } else if (updateListener != null) {
                    updateListener.onUpdateReturned(-1, new UpdateResponse(e.getErrorCode(), e.getMessage()));
                }
            }
        });
    }

    private static void parseResult(Context context, UpdateResponse response, File file, boolean isShow) {
        int now_ver = ManifestUtils.getVersionCode();
        if (now_ver < response.version_i) {
            Intent intent = new Intent(context, UpdateDialogActivity.class);
            intent.putExtra("response", (Serializable)response);
            if (file.exists()) {
                intent.putExtra("file", file.getPath());
            }
            intent.putExtra("showCheckBox", isShow);
            context.startActivity(intent);
        } else if (updateListener != null) {
            updateListener.onUpdateReturned(1, new UpdateResponse(1, "\u5df2\u7ecf\u662f\u6700\u65b0\u7248\u672c\u4e86\uff0c\u65e0\u9700\u66f4\u65b0\u3002"));
        }
    }

    public static boolean isIgnored(String version) {
        List<String> curs = BmobUpdateAgent.getLocalVersions();
        if (curs != null && curs.size() > 0) {
            return curs.contains(version);
        }
        return false;
    }

    private static List<String> getLocalVersions() {
        String cur = BmobContentProvider.getIgnoreVersions();
        if (cur != null && !cur.equals("")) {
            if (cur.contains("&")) {
                String[] ss = cur.split("&");
                ArrayList<String> vs = new ArrayList<String>();
                for (String t : ss) {
                    vs.add(t);
                }
                return vs;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(cur);
            return list;
        }
        return new ArrayList<String>();
    }

    public static void add2IgnoreVersion(String version) {
        List<String> curs = BmobUpdateAgent.getLocalVersions();
        if (curs != null && curs.size() > 0) {
            if (!curs.contains(version)) {
                curs.add(version);
            }
        } else {
            curs.add(version);
        }
        BmobUpdateAgent.saveIgnoreVersion(curs);
    }

    public static void deleteIgnoreVersion(String version) {
        List<String> curs = BmobUpdateAgent.getLocalVersions();
        if (curs != null && curs.size() > 0 && curs.contains(version)) {
            curs.remove(version);
        }
        BmobUpdateAgent.saveIgnoreVersion(curs);
    }

    private static void saveIgnoreVersion(List<String> locals) {
        if (locals != null && locals.size() > 0) {
            int total = locals.size();
            StringBuilder local = new StringBuilder();
            for (int i = 0; i < total; ++i) {
                local.append(locals.get(i));
                if (i == total - 1) continue;
                local.append("&");
            }
            BmobContentProvider.updateIgnoreVersions(local.toString());
        } else {
            BmobContentProvider.updateIgnoreVersions("");
        }
    }

    public static void deleteResponse(UpdateResponse updateResponse) {
        if (updateResponse == null) {
            return;
        }
        File file = new File(InstallUtil.getAppDir(), updateResponse.path_md5 + ".apk");
        if (file != null && file.exists()) {
            file.delete();
        }
    }
}

