/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.update;

import android.content.Context;
import cn.bmob.v3.exception.BmobException;
import cn.bmob.v3.update.AppVersion;
import cn.bmob.v3.util.BmobResource;
import cn.bmob.v3.util.EncryptMD5;
import cn.bmob.v3.util.Utils;
import java.io.Serializable;

public class UpdateResponse
implements Serializable {
    private static final long serialVersionUID = 287172543706916699L;
    public String path;
    public String path_md5;
    public String version = null;
    public Integer version_i;
    public String updateLog = null;
    public long target_size;
    public Boolean isforce;
    public BmobException exception;

    public UpdateResponse(AppVersion app) {
        this.parseJson(app);
    }

    public UpdateResponse(int code, String error) {
        this.exception = new BmobException(code, error);
    }

    public BmobException getException() {
        return this.exception;
    }

    private void parseJson(AppVersion app) {
        this.updateLog = app.getUpdate_log();
        this.version = app.getVersion();
        this.version_i = app.getVersion_i();
        if (this.version_i == null) {
            this.version_i = 0;
        }
        this.isforce = app.getIsforce();
        if (this.isforce == null) {
            this.isforce = false;
        }
        if (app.getPath() != null) {
            this.path = app.getPath().getFileUrl();
            this.path_md5 = EncryptMD5.setMD5(this.path);
        } else if (app.getAndroid_url() != null) {
            this.path = app.getAndroid_url();
            this.path_md5 = EncryptMD5.setMD5(this.path);
        }
        try {
            this.target_size = Long.parseLong(app.getTarget_size());
        }
        catch (Exception e) {
            this.target_size = 0L;
        }
    }

    public String getUpdateInfo(Context paramContext, boolean isDownloaded) {
        String str1 = paramContext.getString(BmobResource.getInstance(paramContext).getString("BMNewVersion"));
        String str2 = paramContext.getString(BmobResource.getInstance(paramContext).getString("BMTargetSize"));
        String str4 = paramContext.getString(BmobResource.getInstance(paramContext).getString("BMUpdateContent"));
        String str5 = paramContext.getString(BmobResource.getInstance(paramContext).getString("BMDialog_InstallAPK"));
        if (isDownloaded) {
            return this.getFormatString(4, str1, str2, str4, str5, "", "");
        }
        String str6 = "";
        String format_size = Utils.convertFileSize(this.target_size);
        return this.getFormatString(6, str1, str2, str4, str5, str6, format_size);
    }

    private String getFormatString(int count, String str1, String str2, String str4, String str5, String str6, String format_size) {
        String format = "";
        Object[] obj = null;
        if (this.updateLog.contains("\uff1b")) {
            String[] logAry = this.updateLog.split("\uff1b");
            int len = logAry.length;
            StringBuilder sb = new StringBuilder();
            obj = new Object[6 + len];
            if (count == 4) {
                sb.append("%s %s\n%s\n\n%s");
                obj[0] = str1;
                obj[1] = this.version;
                obj[2] = str5;
                obj[3] = str4;
            } else if (count == 6) {
                sb.append("%s %s\n%s %s%s\n\n%s");
                obj[0] = str1;
                obj[1] = this.version;
                obj[2] = str2;
                obj[3] = format_size;
                obj[4] = str6;
                obj[5] = str4;
            }
            for (int i = 0; i < len; ++i) {
                if (i != len - 1) {
                    sb.append("\n%s");
                    obj[count + i] = logAry[i] + "\uff1b";
                    continue;
                }
                sb.append("\n%s");
                obj[count + i] = logAry[i];
            }
            format = sb.toString();
        } else if (count == 4) {
            format = "%s %s\n%s\n\n%s\n%s\n";
            obj = new Object[]{str1, this.version, str5, str4, this.updateLog};
        } else if (count == 6) {
            format = "%s %s\n%s %s%s\n\n%s\n%s\n";
            obj = new Object[]{str1, this.version, str2, format_size, str6, str4, this.updateLog};
        }
        return String.format(format, obj);
    }
}

