/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class AppUtils {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String SHA256 = "SHA256";

    public static String getSignature(Context context) {
        return AppUtils.getMD5(context, context.getPackageName());
    }

    public static String getMD5(Context context, String packageName) {
        return AppUtils.getSingInfo(context, packageName, MD5).get(0);
    }

    public static String getSHA1(Context context, String packageName) {
        return AppUtils.getSingInfo(context, packageName, SHA1).get(0);
    }

    public static String getSHA256(Context context, String packageName) {
        return AppUtils.getSingInfo(context, packageName, SHA256).get(0);
    }

    public static ArrayList<String> getSingInfo(Context context, String packageName, String type) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Signature[] signs;
            for (Signature sig : signs = AppUtils.getSignatures(context, packageName)) {
                String tmp = "error!";
                if (MD5.equals(type)) {
                    tmp = AppUtils.getSignatureString(sig, MD5);
                } else if (SHA1.equals(type)) {
                    tmp = AppUtils.getSignatureString(sig, SHA1);
                } else if (SHA256.equals(type)) {
                    tmp = AppUtils.getSignatureString(sig, SHA256);
                }
                result.add(tmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Signature[] getSignatures(Context context, String packageName) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageCodePath(), 64);
            return packageInfo.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSignatureString(Signature sig, String type) {
        byte[] hexBytes = sig.toByteArray();
        String fingerprint = "error!";
        try {
            MessageDigest digest = MessageDigest.getInstance(type);
            if (digest != null) {
                byte[] digestBytes = digest.digest(hexBytes);
                StringBuilder sb = new StringBuilder();
                for (byte digestByte : digestBytes) {
                    sb.append(Integer.toHexString(digestByte & 0xFF | 0x100), 1, 3);
                }
                fingerprint = sb.toString();
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return fingerprint;
    }
}

