/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.text.TextUtils;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class BLog {
    private static final int CHUNK_SIZE = 4000;
    private static final int JSON_INDENT = 4;
    private static final int MAX_METHOD_COUNT = 5;
    private static final int MIN_STACK_OFFSET = 3;
    private static final Settings settings = new Settings();
    private static final char TOP_LEFT_CORNER = '\u2554';
    private static final char BOTTOM_LEFT_CORNER = '\u255a';
    private static final char MIDDLE_CORNER = '\u255f';
    private static final char HORIZONTAL_DOUBLE_LINE = '\u2551';
    private static final String DOUBLE_DIVIDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String SINGLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String MIDDLE_BORDER = "\u255f\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static String TAG = "bmob";

    private BLog() {
    }

    public static Settings init() {
        return settings;
    }

    public static Settings init(String tag) {
        if (tag == null) {
            throw new NullPointerException("tag may not be null");
        }
        if (tag.trim().length() == 0) {
            throw new IllegalStateException("tag may not be empty");
        }
        TAG = tag;
        return settings;
    }

    public static void d(String message) {
        BLog.d(TAG, message);
    }

    public static void d(String tag, String message) {
        BLog.d(tag, message, BLog.settings.methodCount);
    }

    public static void d(String message, int methodCount) {
        BLog.d(TAG, message, methodCount);
    }

    public static void d(String tag, String message, int methodCount) {
        BLog.validateMethodCount(methodCount);
        BLog.log(3, tag, message, methodCount);
    }

    public static void e(String message) {
        BLog.e(TAG, message);
    }

    public static void e(String tag, String message) {
        BLog.e(tag, message, null, BLog.settings.methodCount);
    }

    public static void e(Exception e) {
        BLog.e(TAG, null, e, BLog.settings.methodCount);
    }

    public static void e(String tag, Exception e) {
        BLog.e(tag, null, e, BLog.settings.methodCount);
    }

    public static void e(String message, int methodCount) {
        BLog.validateMethodCount(methodCount);
        BLog.e(TAG, message, methodCount);
    }

    public static void e(String tag, String message, int methodCount) {
        BLog.validateMethodCount(methodCount);
        BLog.e(tag, message, null, methodCount);
    }

    public static void e(String tag, String message, Exception e) {
        BLog.e(tag, message, e, BLog.settings.methodCount);
    }

    public static void e(String tag, String message, Exception e, int methodCount) {
        BLog.validateMethodCount(methodCount);
        if (e != null && message != null) {
            message = message + " : " + e.toString();
        }
        if (e != null && message == null) {
            message = e.toString();
        }
        if (message == null) {
            message = "No message/exception is set";
        }
        BLog.log(6, tag, message, methodCount);
    }

    public static void w(String message) {
        BLog.w(TAG, message);
    }

    public static void w(String tag, String message) {
        BLog.w(tag, message, BLog.settings.methodCount);
    }

    public static void w(String message, int methodCount) {
        BLog.w(TAG, message, methodCount);
    }

    public static void w(String tag, String message, int methodCount) {
        BLog.validateMethodCount(methodCount);
        BLog.log(5, tag, message, methodCount);
    }

    public static void i(String message) {
        BLog.i(TAG, message);
    }

    public static void i(String tag, String message) {
        BLog.i(tag, message, BLog.settings.methodCount);
    }

    public static void i(String message, int methodCount) {
        BLog.i(TAG, message, methodCount);
    }

    public static void i(String tag, String message, int methodCount) {
        BLog.validateMethodCount(methodCount);
        BLog.log(4, tag, message, methodCount);
    }

    public static void v(String message) {
        BLog.v(TAG, message);
    }

    public static void v(String tag, String message) {
        BLog.v(tag, message, BLog.settings.methodCount);
    }

    public static void v(String message, int methodCount) {
        BLog.v(TAG, message, methodCount);
    }

    public static void v(String tag, String message, int methodCount) {
        BLog.validateMethodCount(methodCount);
        BLog.log(2, tag, message, methodCount);
    }

    public static void wtf(String message) {
        BLog.wtf(TAG, message);
    }

    public static void wtf(String tag, String message) {
        BLog.wtf(tag, message, BLog.settings.methodCount);
    }

    public static void wtf(String message, int methodCount) {
        BLog.wtf(TAG, message, methodCount);
    }

    public static void wtf(String tag, String message, int methodCount) {
        BLog.validateMethodCount(methodCount);
        BLog.log(7, tag, message, methodCount);
    }

    public static void json(String json) {
        BLog.json(TAG, json);
    }

    public static void json(String tag, String json) {
        BLog.json(tag, json, BLog.settings.methodCount);
    }

    public static void json(String json, int methodCount) {
        BLog.json(TAG, json, methodCount);
    }

    public static void json(String tag, String json, int methodCount) {
        BLog.validateMethodCount(methodCount);
        if (TextUtils.isEmpty((CharSequence)json)) {
            BLog.d(tag, "Empty/Null json content", methodCount);
            return;
        }
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(4);
                BLog.d(tag, message, methodCount);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(4);
                BLog.d(tag, message, methodCount);
            }
        }
        catch (JSONException e) {
            BLog.d(tag, e.getCause().getMessage() + "\n" + json, methodCount);
        }
    }

    private static synchronized void log(int logType, String tag, String message, int methodCount) {
        if (BLog.settings.logLevel == LogLevel.NONE) {
            return;
        }
        BLog.logTopBorder(logType, tag);
        BLog.logHeaderContent(logType, tag, methodCount);
        byte[] bytes = message.getBytes();
        int length = bytes.length;
        if (length <= 4000) {
            if (methodCount > 0) {
                BLog.logDivider(logType, tag);
            }
            BLog.logContent(logType, tag, message);
            BLog.logBottomBorder(logType, tag);
            return;
        }
        if (methodCount > 0) {
            BLog.logDivider(logType, tag);
        }
        for (int i = 0; i < length; i += 4000) {
            int count = Math.min(length - i, 4000);
            BLog.logContent(logType, tag, new String(bytes, i, count));
        }
        BLog.logBottomBorder(logType, tag);
    }

    private static void logTopBorder(int logType, String tag) {
        BLog.logChunk(logType, tag, TOP_BORDER);
    }

    private static void logHeaderContent(int logType, String tag, int methodCount) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (BLog.settings.showThreadInfo) {
            BLog.logChunk(logType, tag, "\u2551 Thread: " + Thread.currentThread().getName());
            BLog.logDivider(logType, tag);
        }
        String level = "";
        int stackOffset = BLog.getStackOffset(trace);
        for (int i = methodCount; i > 0; --i) {
            int stackIndex = i + stackOffset;
            StringBuilder builder = new StringBuilder();
            builder.append("\u2551 ").append(level).append(BLog.getSimpleClassName(trace[stackIndex].getClassName())).append(".").append(trace[stackIndex].getMethodName()).append(" ").append(" (").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
            level = level + "   ";
            BLog.logChunk(logType, tag, builder.toString());
        }
    }

    private static void logBottomBorder(int logType, String tag) {
        BLog.logChunk(logType, tag, BOTTOM_BORDER);
    }

    private static void logDivider(int logType, String tag) {
        BLog.logChunk(logType, tag, MIDDLE_BORDER);
    }

    private static void logContent(int logType, String tag, String chunk) {
        String[] lines;
        for (String line : lines = chunk.split(System.getProperty("line.separator"))) {
            BLog.logChunk(logType, tag, "\u2551 " + line);
        }
    }

    private static void logChunk(int logType, String tag, String chunk) {
        String finalTag = BLog.formatTag(tag);
        switch (logType) {
            case 6: {
                Log.e((String)finalTag, (String)chunk);
                break;
            }
            case 4: {
                Log.i((String)finalTag, (String)chunk);
                break;
            }
            case 2: {
                Log.v((String)finalTag, (String)chunk);
                break;
            }
            case 5: {
                Log.w((String)finalTag, (String)chunk);
                break;
            }
            case 7: {
                Log.wtf((String)finalTag, (String)chunk);
                break;
            }
            default: {
                Log.d((String)finalTag, (String)chunk);
            }
        }
    }

    private static String getSimpleClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return name.substring(lastIndex + 1);
    }

    private static void validateMethodCount(int methodCount) {
        if (methodCount < 0 || methodCount > 5) {
            throw new IllegalStateException("methodCount must be > 0 and < 5");
        }
    }

    private static String formatTag(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag) && !TextUtils.equals((CharSequence)TAG, (CharSequence)tag)) {
            return TAG + "-" + tag;
        }
        return TAG;
    }

    private static int getStackOffset(StackTraceElement[] trace) {
        for (int i = 3; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            if (e.getClassName().equals(Log.class.getName())) continue;
            return --i;
        }
        return -1;
    }

    public static enum LogLevel {
        FULL,
        NONE;

    }

    public static class Settings {
        int methodCount = 5;
        boolean showThreadInfo = true;
        LogLevel logLevel = LogLevel.NONE;

        public Settings hideThreadInfo() {
            this.showThreadInfo = false;
            return this;
        }

        public Settings setMethodCount(int methodCount) {
            BLog.validateMethodCount(methodCount);
            this.methodCount = methodCount;
            return this;
        }

        public Settings setLogLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }
    }
}

