/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Binder;
import android.util.Log;
import cn.bmob.v3.Bmob;
import cn.bmob.v3.helper.GsonUtil;
import cn.bmob.v3.http.BmobURL;
import cn.bmob.v3.http.bean.Init;
import cn.bmob.v3.util.Base64Coder;
import cn.bmob.v3.util.BmobDbOpenHelper;
import cn.bmob.v3.util.CompatibleInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;

public class BmobContentProvider
extends ContentProvider {
    private static String AUTHORITY;
    private static Uri GAME_CONTENT_URI;
    private static UriMatcher mUriMatcher;
    private static SQLiteDatabase mDb;
    private static Context mContext;
    private static String table;

    public boolean onCreate() {
        return false;
    }

    public static void initProvider(Context context) {
        mContext = context;
        table = "bmob";
        AUTHORITY = mContext.getPackageName() + ".BmobContentProvider";
        GAME_CONTENT_URI = Uri.parse((String)("content://" + AUTHORITY + "/bmob"));
        mUriMatcher = new UriMatcher(-1);
        mUriMatcher.addURI(AUTHORITY, "bmob", 0);
        mDb = new BmobDbOpenHelper(mContext).getWritableDatabase();
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        String table = "bmob";
        if (mDb == null) {
            Log.e((String)"Bmob", (String)"Please init Bmob SDK in Application's onCreate method.");
            return null;
        }
        return mDb.query(table, projection, selection, selectionArgs, null, sortOrder, null);
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        mDb.insert(table, null, values);
        mContext.getContentResolver().notifyChange(uri, null);
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        mDb.delete(table, selection, selectionArgs);
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        mDb.update(table, values, selection, selectionArgs);
        return 0;
    }

    public static String getUser() {
        Cursor cursor = BmobContentProvider.getCursor();
        if (cursor == null) {
            return null;
        }
        if (cursor.moveToFirst()) {
            String str = cursor.getString(cursor.getColumnIndex("user"));
            cursor.close();
            if (str == null || "".equals(str)) {
                return null;
            }
            if (str.startsWith("{")) {
                return str;
            }
            ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(Base64Coder.decode(str));
            try {
                CompatibleInputStream inputStream = new CompatibleInputStream(arrayInputStream);
                Object o = inputStream.readObject();
                inputStream.close();
                arrayInputStream.close();
                return GsonUtil.toJson(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Cursor getCursor() {
        Binder.getCallingPid();
        return Bmob.getApplicationContext().getContentResolver().query(GAME_CONTENT_URI, new String[]{"sessionToken", "user", "api", "file", "push", "io", "upyun", "upyunVer", "ignoreversions", "installation"}, null, null, null);
    }

    public static void updateUpyun(String upyun, int upyunVersion) {
        ContentValues contentValues = BmobContentProvider.getContentValues();
        contentValues.put("upyun", upyun);
        contentValues.put("upyunVer", Integer.valueOf(upyunVersion));
        BmobContentProvider.updateProvider(contentValues);
    }

    public static String getUpyun() {
        Cursor cursor = BmobContentProvider.getCursor();
        String result = "";
        if (cursor.moveToFirst()) {
            result = cursor.getString(cursor.getColumnIndex("upyun"));
        }
        if (cursor != null) {
            cursor.close();
        }
        return result;
    }

    public static int getUpyunVersion() {
        Cursor cursor = BmobContentProvider.getCursor();
        int result = -1;
        if (cursor.moveToFirst()) {
            result = cursor.getInt(cursor.getColumnIndex("upyunVer"));
        }
        if (cursor != null) {
            cursor.close();
        }
        return result;
    }

    public static void updateInit(Init init) {
        ContentValues contentValues = BmobContentProvider.getContentValues();
        contentValues.put("api", init.getApi());
        contentValues.put("file", init.getFile());
        contentValues.put("push", init.getPush());
        contentValues.put("io", init.getIo());
        BmobContentProvider.updateProvider(contentValues);
    }

    public static String getFile() {
        Cursor cursor = BmobContentProvider.getCursor();
        String result = BmobURL.getDefault().getFileUrl();
        if (cursor.moveToFirst()) {
            result = cursor.getString(cursor.getColumnIndex("file"));
        }
        if (cursor != null) {
            cursor.close();
        }
        return result;
    }

    public static String getIO() {
        Cursor cursor = BmobContentProvider.getCursor();
        String result = BmobURL.getDefault().getRealTimeDataUrl();
        if (cursor.moveToFirst()) {
            result = cursor.getString(cursor.getColumnIndex("io"));
        }
        if (cursor != null) {
            cursor.close();
        }
        return result;
    }

    public static String getSessionToken() {
        Cursor cursor = BmobContentProvider.getCursor();
        String sessionToken = "";
        if (cursor == null) {
            return null;
        }
        if (cursor.moveToFirst()) {
            sessionToken = cursor.getString(cursor.getColumnIndex("sessionToken"));
        }
        cursor.close();
        return sessionToken;
    }

    public static String getInstallation() {
        Cursor cursor = BmobContentProvider.getCursor();
        String result = "";
        if (cursor.moveToFirst()) {
            result = cursor.getString(cursor.getColumnIndex("installation"));
        }
        if (cursor != null) {
            cursor.close();
        }
        return result;
    }

    public static <T> void updateUser(String user, Class<T> clazz) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(arrayOutputStream);
            objectOutputStream.writeObject(GsonUtil.toObject(user, clazz));
            objectOutputStream.flush();
            byte[] data = arrayOutputStream.toByteArray();
            objectOutputStream.close();
            arrayOutputStream.close();
            String userCache = new String(Base64Coder.encode(data));
            ContentValues contentValues = BmobContentProvider.getContentValues();
            contentValues.put("user", userCache);
            BmobContentProvider.updateProvider(contentValues);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeLocalUser() {
        ContentValues contentValues = BmobContentProvider.getContentValues();
        contentValues.put("user", "");
        BmobContentProvider.updateProvider(contentValues);
    }

    public static void updateSessionToken(String sessionToken) {
        ContentValues contentValues = BmobContentProvider.getContentValues();
        contentValues.put("sessionToken", sessionToken);
        BmobContentProvider.updateProvider(contentValues);
    }

    public static void updateInstallation(String installation) {
        ContentValues contentValues = BmobContentProvider.getContentValues();
        contentValues.put("installation", installation);
        BmobContentProvider.updateProvider(contentValues);
    }

    public static void updateIgnoreVersions(String ignoreVersions) {
        ContentValues contentValues = BmobContentProvider.getContentValues();
        contentValues.put("ignoreversions", ignoreVersions);
        BmobContentProvider.updateProvider(contentValues);
    }

    public static String getIgnoreVersions() {
        Cursor cursor = BmobContentProvider.getCursor();
        String result = "";
        if (cursor.moveToFirst()) {
            result = cursor.getString(cursor.getColumnIndex("ignoreversions"));
        }
        if (cursor != null) {
            cursor.close();
        }
        return result;
    }

    public static ContentValues getContentValues() {
        ContentValues mContentValues = new ContentValues();
        mContentValues.put("_id", Integer.valueOf(1));
        return mContentValues;
    }

    public static void updateProvider(ContentValues contentValues) {
        Cursor cursor = BmobContentProvider.getCursor();
        if (cursor == null) {
            return;
        }
        if (cursor.getCount() > 0) {
            Bmob.getApplicationContext().getContentResolver().update(GAME_CONTENT_URI, contentValues, "_id = ?", new String[]{"1"});
        } else {
            Bmob.getApplicationContext().getContentResolver().insert(GAME_CONTENT_URI, contentValues);
        }
        cursor.close();
    }
}

