/*
 * Decompiled with CFR 0.152.
 */
package cn.bmob.v3.util;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import androidx.core.app.NotificationCompat;

public class BmobNotificationManager
extends ContextWrapper {
    private static volatile BmobNotificationManager INSTANCE;
    private static NotificationManager manager;

    public BmobNotificationManager(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BmobNotificationManager getInstance(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<BmobNotificationManager> clazz = BmobNotificationManager.class;
        synchronized (BmobNotificationManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new BmobNotificationManager(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private Bitmap getAppIcon() {
        BitmapDrawable bitmapDrawable = (BitmapDrawable)this.getApplicationInfo().loadIcon(this.getPackageManager());
        Bitmap appIcon = bitmapDrawable.getBitmap();
        return appIcon;
    }

    private String getTicker() {
        return this.getResources().getString(this.getResourcesId("bmob_im_notification_ticker"));
    }

    private int getResourcesId(String name) {
        int resId = this.getResources().getIdentifier(name, "string", this.getPackageName());
        if (resId == 0) {
            throw new RuntimeException("Error getting resource. Make sure you have copied all resources (values/bmob_im_notification_strings.xml) from SDK to your project. ");
        }
        return resId;
    }

    public void showNotification(Bitmap largerIcon, String title, String content, String ticker, Intent intent, int importance, int sound) {
        this.showNotification(largerIcon, title, content, ticker, intent, "BMOBIM_ID", "BMOBIM_NAME", importance, sound);
    }

    public void showNotification(Bitmap largerIcon, String title, String content, String ticker, PendingIntent intent, int importance, int sound) {
        this.showNotification(largerIcon, title, content, ticker, intent, "BMOBIM_ID", "BMOBIM_NAME", importance, sound);
    }

    public void showNotification(Bitmap largerIcon, String title, String content, String ticker, Intent intent, String channelId, String channelName, int importance, int sound) {
        Notification notification;
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x8000000);
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannel(channelId, channelName, importance);
            notification = this.getNotification_O(largerIcon, title, content, ticker, pendingIntent, channelId).build();
        } else {
            notification = this.getNotification_N(largerIcon, title, content, ticker, pendingIntent, channelId, sound).build();
        }
        this.getManager().notify(0, notification);
    }

    public void showNotification(Bitmap largerIcon, String title, String content, String ticker, PendingIntent pendingIntent, String channelId, String channelName, int importance, int sound) {
        Notification notification;
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannel(channelId, channelName, importance);
            notification = this.getNotification_O(largerIcon, title, content, ticker, pendingIntent, channelId).build();
        } else {
            notification = this.getNotification_N(largerIcon, title, content, ticker, pendingIntent, channelId, sound).build();
        }
        this.getManager().notify(0, notification);
    }

    public void cancelNotification() {
        INSTANCE = null;
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        nm.cancel(0);
    }

    @TargetApi(value=26)
    public void createNotificationChannel(String channelId, String channelName, int importance) {
        NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, importance);
        this.getManager().createNotificationChannel(channel);
    }

    private NotificationManager getManager() {
        if (manager == null) {
            manager = (NotificationManager)this.getSystemService("notification");
        }
        return manager;
    }

    @TargetApi(value=26)
    public Notification.Builder getNotification_O(Bitmap largerIcon, String title, String content, String ticker, PendingIntent pendingIntent, String channelId) {
        return new Notification.Builder(this.getApplicationContext(), channelId).setTicker((CharSequence)ticker).setLargeIcon(largerIcon).setSmallIcon(this.getApplicationInfo().icon).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setAutoCancel(true).setContentIntent(pendingIntent);
    }

    public NotificationCompat.Builder getNotification_N(Bitmap largerIcon, String title, String content, String ticker, PendingIntent pendingIntent, String channelId, int sound) {
        return new NotificationCompat.Builder(this.getApplicationContext(), channelId).setTicker((CharSequence)ticker).setLargeIcon(largerIcon).setSmallIcon(this.getApplicationInfo().icon).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setAutoCancel(true).setDefaults(sound).setContentIntent(pendingIntent);
    }

    public static void showNotification(Context context, int icon, String title, String content, String ticker, PendingIntent pendingIntent) {
        Bitmap largeIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)icon);
        BmobNotificationManager.getInstance(context).showNotification(largeIcon, title, content, ticker, pendingIntent, 1, 8);
    }
}

